/*  -*- Mode: C -*- 
 * This file is part of xnetmaj
 * 
 * pixread.h -- 
 * 
 * $Id: pixread.h,v 1.1 1995/04/23 01:32:45 ksr Exp ksr $
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Tue Apr 11 11:14:36 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Tue May  9 15:31:25 1995
 * description:
 * 
 * history:
 */

#ifndef _READPIX_H
#define _READPIX_H

/*
   pixread.h
 */

#include "widget/widget.h"
#include "dev/gdev.h"
#include "geom.h"

extern gdev_t main_gdev;

#define read_pix(_name, _xpm)  \
   gdev_create_pixmapfromdata (main_gdev, identstr(_name), \
                                     fbitmap(_name), \
                                     &_xpm.pm, \
                                     &_xpm.Mpm);

#define read_pix_idx(_name, _xpm)  \
   gdev_create_pixmapfromdata (main_gdev, identstr(_name), \
                                     _name, \
                                     &_xpm.pm, \
                                     &_xpm.Mpm);

#define fbitmap(a)   identcat(a,_xpm)

typedef struct gpixmap2
  {
    gpixmap_t pm;
    gpixmap_t Mpm;
  }
 *gpixmap2_t;

#if pixread
#define _extern_
#else
#define _extern_ extern
#endif

#include "pixdec.h"
#include "pixbdig.h"
#include "pixmisc.h"
#include "pixyaku.h"
#include "pmutil.h"

#endif

#define PAIOPEN 1
#define PAIDARK 2
