/*  -*- Mode: C -*- 
 * This file is part of xnetmaj
 * 
 * res.c -- 
 * 
 * $Id: res.c,v 1.1 1995/04/23 01:32:45 ksr Exp ksr $
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Tue Apr 11 11:13:51 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Tue Apr 18 11:00:17 1995
 * description:
 *   ui_res and ui_choice routine
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */

#include "xnet.h"
#include "pixread.h"
#include "xnetmaj.h"

extern int auto_stop;
int in_res;
int in_choice;

ui_res (gp, howp)
     global_t *gp;
     int *howp;
{
  int c, i, j, n, ret, pai;
  gpixmap2_t args[25];
  int pais[25];
  extern integer_t iam;

retry:
  *howp = 0;
  c = 0;

  iam = mytblpos (vself);

  if (auto_stop)
    {
      result_t y;
      if (!hand[vself].reach
	  && (T_GET (rvp->attr) != T_HN_KAN)
	  && (T_GET (rvp->attr) != T_HN_KAN_C))
	{
	  if (hand_can_pon (gp, vself, rvp->out)
	      || (hand_can_kan (gp, vself, rvp->out) == 2)
	      || ((cur_player + 1) % 4 == vself
		  && hand_can_tiex (gp, vself, rvp->out)))
	    c = ' ';
	}
      if (c == 0)
	{
	  hand_insert (gp, vself, rvp->out);
	  if (result_calc_yaku (gp, vself, &y) > 0)
	    c = ' ';
	  hand_delete (gp, vself, rvp->out, 0);
	}
    }

  if (c == 0 || c != ' ')
    {
      return R_ACK;
    }
  in_res = 1;
  ret = choice (gp, 0, 0, args, CH_TIE, 1);
  in_res = 0;
  switch (ret)
    {
    case X_CANCEL:
      return R_ACK;
    case X_TIE:
      break;
    case X_PON:
      return R_PON;
    case X_KAN:
      return R_KAN;
    case X_RON:
      return R_RON;
    }
  if ((cur_player + 1) % 4 != vself)
    goto retry;

  n = hand[vself].closed_num;
  i = 0;
  for (j = 0; j < n; j++)
    {
      pai = hand[vself].closed[j];
      if (i != 0 && P_KIND (pai) == P_KIND (pais[i]))
	continue;
      if (hand_can_tie (gp, vself, rvp->out, pai))
	{
	  pais[i] = pai;
	  args[i] = pai2pix (pai, 0, 0, 0);
	  i++;
	}
    }
  if (i == 0)
    goto retry;
  if (i == 1)
    {
      *howp = pais[0];
      return R_TIE;
    }
  in_res = 1;
  ret = choice (gp, i, i, args, CH_TIE, 0);
  in_res = 0;
  iam = -1;

  if (ret == X_CANCEL)
    goto retry;
  if (ret >= i)
    {
      goto retry;
    }
  *howp = pais[ret];
  return R_TIE;
}

ui_choice (gp)
     global_t *gp;
{
  int i, j, n, ret, pai, oldpai, kan;
  gpixmap2_t args[25];
  int pais[25];
  int mode = CH_NORM;
  int who;
  widget_t canvas;

  canvas = mark_frame[mytblpos (vself)];
  mark (canvas);


loop:
#if 0				/* draw in choice frame */
  n = hand[vself].closed_num;
  for (i = 0; i < n; i++)
    {
      args[i] = pai2pix (hand[vself].closed[i], 0, 0, 0);
    }
#endif
  n = hand[vself].closed_num;
  in_choice = 1;
  ret = choice (gp, 0, n, args, mode, 0);
  in_choice = 0;
  if (ret < n)
    {
      ask_pai = hand[vself].closed[ret];
    }
  else if (ret == X_REACH)
    {
      mode = (mode == 1) ? CH_NORM : 1;
      ask_attr = (mode == 1) ? T_RV_RCH : T_RV;
      goto loop;
    }
  else if (ret == X_KAN)
    {
      oldpai = -1;
      n = hand[vself].closed_num;
      i = 0;
      for (j = 0; j < n; j++)
	{
	  pai = hand[vself].closed[j];
	  kan = hand_can_kan (gp, vself, pai);
	  if ((kan == 3 || kan == 1)
	      && P_KIND (pai) != oldpai)
	    {
	      pais[i] = pai;
	      args[i] = pai2pix (pai, 0, 0, 0);
	      i++;
	      oldpai = P_KIND (pai);
	    }
	}
      if (i == 0)
	goto loop;
      if (i == 1)
	{
	  ask_attr = T_HN_KAN;
	  ask_pai = pais[0];
	  return;
	}
      ret = choice (gp, i, i, args, CH_TIE, 2);
      if (ret == X_CANCEL)
	{
	  goto loop;
	}
      if (ret >= i)
	{
	  goto loop;
	}
      ask_pai = pais[ret];
      ask_attr = T_HN_KAN;
      return;
    }
  else if (ret == X_TUMO)
    {
      ask_attr = T_HN_TSM;
    }
  else
    {
      goto loop;
    }
}
