/*  -*- Mode: C -*- 
 * This file is part of xnetmaj
 * 
 * xnet.h -- 
 * 
 * $Id: xnet.h,v 1.1 1995/04/23 01:32:45 ksr Exp ksr $
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Tue Apr 11 11:14:13 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Wed May 17 22:30:21 1995
 * description:
 * 
 * history:
 */

#ifndef _XNET_H
#define _XNET_H

#ifdef __STDC__
#define identcat(a,b)   a##b
#define identstr(a)     #a
#else
#define identcat(a,b)   a/**/b
#define identstr(a)     "a"
#endif

#include <assert.h>
#include "widget/widget.h"

#define X_MIN X_CANCEL
#define X_CANCEL 20
#define X_PON 21
#define X_TIE 22
#define X_RON 23
#define X_KAN 24
#define X_REACH 26
#define X_TUMO 25

#define CH_NORM 0
#define CH_TIE  1
#define CH_KAN  2


struct view
  {
    widget_t _title_frame;
    widget_t _user_kaze[4];
    widget_t _mark_frame[4];
    widget_t _user_name[4];
    widget_t _user_state[4];
    widget_t _user_ppoint[4];
    widget_t _user_gpoint[4];
    widget_t _user_message[4];
    widget_t _hand_frame[4];
    widget_t _openhand_frame[4];
    widget_t _river_attr1[4];
    widget_t _river_frame[4];
    widget_t _river_attr2[4];
    widget_t _river_attr3[4];
    widget_t _river_attr4[4];
    widget_t _reststr_frame;
    widget_t _rest_frame;
    widget_t _choice_frame;
    widget_t _choicestate_frame;
    widget_t _dorastr_frame, _uradorastr_frame;
    widget_t _action;
    widget_t _kan_button, _tumo_button, _tie_button, _pon_button, _cancel_button,
      _ron_button, _reach_button;
    widget_t _state_frame, _dora_frame, _uradora_frame;
    widget_t _mt_reststr_frame;
    widget_t _mt_rest_frame;

    widget_t _pai_frame[4], _name_frame[4];
    widget_t _status_frame;
    widget_t _menu_frame;
    widget_t _one_button, _restart_button, _auto_button, _quit_button,
      _flush_button, _speed_button, _autoplay_button,  _auto_after_reach_button, _visible_button, _about_button;
  };

#define title_frame ((view)->_title_frame)
#define user_kaze ((view)->_user_kaze)
#define mark_frame ((view)->_mark_frame)
#define user_name ((view)->_user_name)
#define user_state ((view)->_user_state)
#define user_ppoint ((view)->_user_ppoint)
#define user_gpoint ((view)->_user_gpoint)
#define user_message ((view)->_user_message)
#define hand_frame ((view)->_hand_frame)
#define openhand_frame ((view)->_openhand_frame)
#define river_attr1 ((view)->_river_attr1)
#define river_frame ((view)->_river_frame)
#define river_attr2 ((view)->_river_attr2)
#define river_attr3 ((view)->_river_attr3)
#define river_attr4 ((view)->_river_attr4)
#define reststr_frame ((view)->_reststr_frame)
#define rest_frame ((view)->_rest_frame)
#define choice_frame ((view)->_choice_frame)
#define choicestate_frame ((view)->_choicestate_frame)
#define dorastr_frame ((view)->_dorastr_frame)
#define uradorastr_frame ((view)->_uradorastr_frame)
#define kan_button ((view)->_kan_button)
#define tumo_button ((view)->_tumo_button)
#define tie_button ((view)->_tie_button)
#define pon_button ((view)->_pon_button)
#define cancel_button ((view)->_cancel_button)
#define ron_button ((view)->_ron_button)
#define reach_button ((view)->_reach_button)
#define state_frame ((view)->_state_frame)
#define dora_frame ((view)->_dora_frame)
#define uradora_frame ((view)->_uradora_frame)
#define action ((view)->_action)
#define mt_reststr_frame ((view)->_mt_reststr_frame)
#define mt_rest_frame ((view)->_mt_rest_frame)
#define pai_frame  ((view)->_pai_frame)
#define name_frame ((view)->_name_frame)
#define status_frame ((view)->_status_frame)
#define menu_frame ((view)->_menu_frame)
#define restart_button ((view)->_restart_button)
#define one_button  ((view)->_one_button)
#define auto_button  ((view)->_auto_button)
#define quit_button  ((view)->_quit_button)
#define flush_button  ((view)->_flush_button)
#define speed_button  ((view)->_speed_button)
#define autoplay_button  ((view)->_autoplay_button)
#define auto_after_reach_button  ((view)->_auto_after_reach_button)
#define visible_button  ((view)->_visible_button)
#define about_button  ((view)->_about_button)

#if XNET
struct view view_struct;
struct view *view = &view_struct;
boolean flag_not_needredraw;
boolean flag_not_needdraw_hand;
#else
extern struct view *view;
extern boolean flag_not_needredraw;
extern boolean flag_not_needdraw_hand;
#endif

#include "geom.h"
#include "decl.h"

#define callbackarg_param    (w, val, arg) widget_t w; integer_t val; struct callbackarg *arg;

#endif


#define STOPVALUE  (-1)
