/*  -*- Mode: C -*- 
 * This file is part of xnetmaj
 * 
 * xui.c -- 
 * 
 * $Id: xui.c,v 1.1 1995/04/23 01:32:45 ksr Exp ksr $
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Tue Apr 11 11:13:47 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Thu Jun  8 01:38:35 1995
 * description:
 *   mainly user interface parts 
 *   called ui_??? from client main loop
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */

#include "xnet.h"
#include "xnetmaj.h"
#include "pixread.h"
#include "pmutil.h"

/* #include <alloca.h> */

extern int choiced;

#define D(a)

extern widget_t root_widget;
integer_t invisible_riverpai;

static struct
  {
    integer_t _tblpos[4];
  }
maptblpos[4] =
{
  {
    3, 0, 1, 2
  }
  ,
  {
    2, 3, 0, 1
  }
  ,
  {
    1, 2, 3, 0
  }
  ,
  {
    0, 1, 2, 3
  }
};

static integer_t *tblpos;
global_t *game_global;

integer_t
mytblpos (i)
integer_t i;
{
  return tblpos[i];
}

integer_t
pos2who (i)
integer_t i;
{
  int who;
  global_t *gp = game_global;
  for (who = 0; who < 4; who++)
    {
      if (pplayer[who] == i)
	{
	  return who;
	}
    }
  return who;
}

void
ui_init (gp,kind)
     global_t *gp; int kind; 
{
  extern widget_t board;
  game_global = gp;

  switch(kind) {
  case PROG_NETMAJ:
  case PROG_NETMAJ1:
  case PROG_PLVIEW:;
  }

  setup ();
  make_board ();
  make_point ();
  make_about ();

  read_pixmaps ();
  read_attr_pixmaps ();
  read_decorate_pixmaps ();

  widget_dev_map(board); /* display window here !! */
  widget_sync(board);
  openning ();

/*  board_reset (); */
  board_redraw (); 
}

#if 0
players (gp)
     global_t *gp;
{
  char buf[256];
  strcpy (buf, "auto");
  comment (self, 0, buf);
  execute_auto (buf);

  comment (self, 0, buf);
  execute_auto (buf);

  comment (self, 0, buf);
  execute_auto (buf);
}
#endif

void
ui_term ()
{
}


#define print_digit(p)      _print_digit(canvas, p)
#define print_kanjidigit(p) _print_kanjidigit(canvas, p)

static widget_t canvas;


_print_digit (w, val)
     widget_t w;
     integer_t val;
{
  char buffer[64], *p = buffer;
  sprintf (buffer, "%d", val);

  if (widget_text_p (w))
    {
      char *p = strdup (buffer);
      if (!p)
	{
	  fatal ("");
	}
      widget_configure (w, resource_text, p);
    }
  else
    {
      fprintf (stderr, "error print digit");
    }
}

static void
_print_kanjidigit (w, val)
     widget_t w;
{
  if (val < 0 || val > 10)
    {
      return;			/* unsupport 10 ponba or 10 kyoku */
    }
  else
    {
      _print_colorpixmap (w, pm_digit[val]);
    }
}

void
print_pmdigit (w, val)
     widget_t w;
     integer_t val;
{
  if (val < 0 || val > 10)
    {
      return;			/* unsupport 10 ponba or 10 kyoku */
    }
  else
    {
      _print_colorpixmap (w, pm_digit[val]);
    }
}

#define print_n_hon(val)  _print_n_hon(canvas, val)
static void
_print_n_hon (w, val)
     widget_t w;
{
  if (val >= 100) {
    return;
  }
  if (val < 0 || (val >= 10 && val < 100) )
    {
      pmcontainer_set_adigit(w, val, 0);
      return;
    }
  if (val > 5 || val == 0)
    {
      _print_colorpixmap (w, pm_digit[val]);
    }
  else
    {
      _print_colorpixmap (w, pm_n_hon[val]);
    }
}







static
draw_status (gp)
     global_t *gp;
{
  D (fprintf (stderr, "draw status"));

  if (!ch_dora && !ch_play)
    {
      return;
    }
  ch_dora = 0;

  canvas = state_frame;
  canvas_clear ();
  print_colorpixmap (pm_bturn_names[big_turn]);
  print_kanjidigit (small_turn + 1);
  print_colorpixmap (pm_sturn_sfx);
  print_n_hon (small_turn_cnt);
  print_colorpixmap (pm_sturn_cnt_sfx);

  canvas = reststr_frame;
  canvas_clear ();
  print_colorpixmap (pm_rest_str);
  canvas = rest_frame;
  print_digit (rest_point);

  canvas = mt_reststr_frame;
  canvas_clear ();
  print_colorpixmap (pm_mt_rest_str);
  canvas = mt_rest_frame;
  print_digit (mt_rest (gp));

  canvas = dorastr_frame;
  canvas_clear ();
  print_colorpixmap (pm_dora_str);

  canvas = dora_frame;
  canvas_clear ();
  print_colorpixmap2 (pai2pix (mt_dora (gp, 0), 3, 0, PAIOPEN));
  print_colorpixmap2 (pai2pix (mt_dora (gp, 1), 3, 0, PAIOPEN));
  print_colorpixmap2 (pai2pix (mt_dora (gp, 2), 3, 0, PAIOPEN));
  print_colorpixmap2 (pai2pix (mt_dora (gp, 3), 3, 0, PAIOPEN));
  print_colorpixmap2 (pai2pix (mt_dora (gp, 4), 3, 0, PAIOPEN));

  canvas = uradorastr_frame;
  canvas_clear ();
  print_colorpixmap (pm_uradora_str);

  canvas = uradora_frame;
  canvas_clear ();
  print_colorpixmap2 (pai2pix (mt_uradora (gp, 0), 3, 0, PAIOPEN));
  print_colorpixmap2 (pai2pix (mt_uradora (gp, 1), 3, 0, PAIOPEN));
  print_colorpixmap2 (pai2pix (mt_uradora (gp, 2), 3, 0, PAIOPEN));
  print_colorpixmap2 (pai2pix (mt_uradora (gp, 3), 3, 0, PAIOPEN));
  print_colorpixmap2 (pai2pix (mt_uradora (gp, 4), 3, 0, PAIOPEN));

  widget_display (status_frame);
  widget_flush (status_frame);
}

#define print_str(s)  _print_str(canvas, s)

void
_print_str (w, s)
     widget_t w;
     char *s;
{
  widget_configure (w, resource_text, s);
}

widget_t last_mark;

static void
draw_player (gp, who)
     global_t *gp;
{
  int i;
  int pp;

  if (!ch_play && !ch_point)
    return;

  ch_point = 0;
  pp = pplayer[who];

  canvas = user_kaze[tblpos[who]];
  canvas_clear ();
  print_colorpixmap (pm_bturn_names[who]);
  print_colorpixmap (pm_ie);

  canvas = user_state[tblpos[who]];
  canvas_clear ();
  if ((who + small_turn) % 4 == 0)
    {
      print_colorpixmap (pm_user_state);
    }
  canvas = user_name[tblpos[who]];
  print_str (player[pp].name);

  canvas = user_gpoint[tblpos[who]];
  print_digit (player[pp].gpoint);
  canvas = user_ppoint[tblpos[who]];
  print_digit (player[pp].ppoint);


  widget_display (name_frame[tblpos[who]]);
  widget_flush (name_frame[tblpos[who]]);
}

#if 0
static void
draw_river (gp, who)
     global_t *gp;
{
  int max;
  int pp;
  int i;
  int pai, reachpos = -1;
  char rattr[RIVER_MAX];

  if (!ch_river[who] && !ch_play) {
    return;
  }

  ch_river[who] = 0;

/* tumogiri */

/* count up river pais */
  for (max = 0; max < RIVER_MAX; max++)
    {
      if (!rv[who][max].in && !rv[who][max].out)
	{
	  break;
	}
    }
  pp = pplayer[who];

  memset(rattr, 1, max); /* opened */

  canvas = river_attr1[tblpos[who]];
  canvas_clear ();

  for (i = 0; i < max; i++)
    {
      pai = rv[who][i].in;
      if (pai && pai == rv[who][i].out)
	{
	  pai = P_INV3;
	}
      else
	{
	  pai = P_NULL;
	}
      {
	gpixmap2_t pix = &pm_attrtg;
	if (pai == P_NULL)
	  {
	    continue;
	  }
	print_colorpixmap_attr (pix, (i * ATTR_W));
      }
    }

/* pon, reach etc */
  {
    gpixmap2_t pix;
    canvas = river_attr2[tblpos[who]];
    canvas_clear ();

    for (i = 0; i < max; i++)
      {
	gpixmap2_t pix = attr2pix (rv[who][i].attr, 't');
	if (pix == &pm_attrnon)
	  {
	    continue;
	  }
	if (pix == &pm_attrreach)
	  {
	    reachpos = i;
	  }
	if (pix == &pm_attr4) 
	  {
	    rattr[i] = PAIOPEN|PAIDARK; /* not normal pai (dark) */
	  }
	if (pix == &pm_attrT) 
	  {
	    rattr[i] = PAIOPEN|PAIDARK; /* not normal pai (dark) */
	  }
	print_colorpixmap_attr (pix, (i * ATTR_W));
      }

/* something do to this pai */
    canvas = river_attr3[tblpos[who]];
    canvas_clear ();
    for (i = 0; i < max; i++)
      {
	gpixmap2_t pix;
	pix = attr2pix (rv[who][i].attr, 'r');
	if (pix == &pm_attrnon)
	  {
	    continue;
	  }
	rattr[i] |= PAIOPEN|PAIDARK; /* not normal pai (dark) */
	print_colorpixmap_attr (pix, (i * ATTR_W));
      }
  }

  canvas = river_frame[tblpos[who]];
  canvas_clear ();

  {
    integer_t current = 0;
    extern int rv_fixed;
    for (i = 0; i < max; i++)
      {
	int reach_p;
	gpixmap2_t paipix;

	pai = rv[who][i].out;
	if (rvp == &(rv[who][i]))
	  {
	    current = 1;
	  }
	reach_p = (reachpos == i);
	paipix = pai2pix (pai, tblpos[who], reach_p, rattr[i]);
	if (!rv_fixed && rvp == &(rv[who][i]))
	  {
	    print_colorpixmap2_withmargin (paipix, HANDPAIMARGIN);
	  }
	else
	  {
	    print_colorpixmap2 (paipix);
	  }
      }

    canvas = mark_frame[tblpos[who]];
    canvas_clear ();
    if (current)
      {
	last_mark = canvas;
	print_colorpixmap (pm_current);
      }
    widget_display (canvas);
    widget_flush (canvas);
  }

  {
    gpixmap2_t pix;
    canvas = river_attr4[tblpos[who]];
    canvas_clear ();
    for (i = 0; i < max; i++)
      {
	gpixmap2_t pix = attr2pix (rv[who][i].attr, 'f');
	if (pix == &pm_attrnon)
	  {
	    continue;
	  }
	print_colorpixmap_attr (pix, (i * ATTR_W));
      }
  }

  widget_display (river_frame[tblpos[who]]);
  widget_display (river_attr1[tblpos[who]]);
  widget_display (river_attr2[tblpos[who]]);
  widget_display (river_attr3[tblpos[who]]);
  widget_display (river_attr4[tblpos[who]]);
  widget_flush (river_frame[tblpos[who]]);
  widget_flush (river_attr1[tblpos[who]]);
  widget_flush (river_attr2[tblpos[who]]);
  widget_flush (river_attr3[tblpos[who]]);
  widget_flush (river_attr4[tblpos[who]]);
}
#else

static void
draw_river (gp, who)
     global_t *gp;
{
  int max;
  int pp;
  int i;
  int pai, reachpos = -1;
  char paiviewattr[RIVER_MAX];
  char riveridx[RIVER_MAX];
  integer_t current = 0;

  if (!ch_river[who] && !ch_play) {
    return;
  }

  ch_river[who] = 0;

/* count up river pais */
  for (max = 0; max < RIVER_MAX; max++)
    {
      if (!rv[who][max].in && !rv[who][max].out)
	{
	  break;
	}
    }
  pp = pplayer[who];

  memset(paiviewattr, PAIOPEN, max); /* opened  */

/* check removed pai */
  if (invisible_riverpai) {
    integer_t idx = 0;
    for (i = 0; i < max; i++)
      {
	gpixmap2_t pix;
	pix = attr2pix (rv[who][i].attr, 't');
	if (pix == &pm_attr4 || pix == &pm_attrT)  /* ankan and tumo */
	  {
	    goto removed;
	  }
	pix = attr2pix (rv[who][i].attr, 'r');
	if (pix != &pm_attrnon) {
	  goto removed;
	}
	riveridx[i] = idx++;
	continue;
      removed:
	pix = attr2pix (rv[who][i].attr, 't');
	if (pix == &pm_attrreach) {
	  riveridx[i] = idx++;
	  continue;
	}
        riveridx[i] = -1;
      }
  } else {
    for (i = 0; i < max; i++) {
        riveridx[i] = i;
    }
  }

  canvas = river_attr1[tblpos[who]];
  canvas_clear ();

  for (i = 0; i < max; i++)
    {
      pai = rv[who][i].in;
      if (pai && pai == rv[who][i].out)
	{
	  gpixmap2_t pix = &pm_attrtg;
	  if (riveridx[i] != -1) {
	    print_colorpixmap_attr (pix, (riveridx[i] * ATTR_W));
	  }
	}
    }

/* pon, reach etc */
  {
    gpixmap2_t pix;
    canvas = river_attr2[tblpos[who]];
    canvas_clear ();

    for (i = 0; i < max; i++)
      {
	gpixmap2_t pix = attr2pix (rv[who][i].attr, 't');
	if (pix == &pm_attrnon)
	  {
	    continue;
	  }
	if (pix == &pm_attrreach)
	  {
	    reachpos = i;
	  }
	if (pix == &pm_attr4 || pix == &pm_attrT) 
	  {
	    paiviewattr[i] = PAIOPEN|PAIDARK; /* not normal pai (dark) */
	  }
	if (riveridx[i] != -1) {
	  print_colorpixmap_attr (pix, (riveridx[i] * ATTR_W));
	}
      }

/* something do to this pai */
    canvas = river_attr3[tblpos[who]];
    canvas_clear ();
    for (i = 0; i < max; i++)
      {
	gpixmap2_t pix;
	pix = attr2pix (rv[who][i].attr, 'r');
	if (pix == &pm_attrnon)
	  {
	    continue;
	  }
	paiviewattr[i] |= PAIOPEN|PAIDARK; /* not normal pai (dark) */
	if (riveridx[i] != -1) {
	  print_colorpixmap_attr (pix, (riveridx[i] * ATTR_W));
	}
      }
  }

  canvas = river_frame[tblpos[who]];
  canvas_clear ();
  {
    extern int rv_fixed;
    for (i = 0; i < max; i++)
      {
	int reach_p;
	gpixmap2_t paipix;

	pai = rv[who][i].out;
	if (rvp == &(rv[who][i]))
	  {
	    current = 1;
	  }
	reach_p = (reachpos == i);
	paipix = pai2pix (pai, tblpos[who], reach_p, paiviewattr[i]);

        if (riveridx[i] == -1) {
	  continue;
	}
	if (!rv_fixed && rvp == &(rv[who][i]))
	  {
	    print_colorpixmap2_withmargin (paipix, HANDPAIMARGIN);
	  }
	else
	  {
	    print_colorpixmap2 (paipix);
	  }
      }
  }
  if (!invisible_riverpai) {
    gpixmap2_t pix;
    canvas = river_attr4[tblpos[who]];
    canvas_clear ();
    for (i = 0; i < max; i++)
      {
	gpixmap2_t pix = attr2pix (rv[who][i].attr, 'f');
	if (pix == &pm_attrnon)
	  {
	    continue;
	  }
	if (riveridx[i] != -1) {
	  print_colorpixmap_attr (pix, (riveridx[i] * ATTR_W));
	}
      }
  }

  canvas = mark_frame[tblpos[who]];
  canvas_clear ();
  if (current)
      {
	last_mark = canvas;
	print_colorpixmap (pm_current);
      }
  widget_display (canvas);
  widget_flush (canvas);
  widget_display (river_frame[tblpos[who]]);
  widget_display (river_attr1[tblpos[who]]);
  widget_display (river_attr2[tblpos[who]]);
  widget_display (river_attr3[tblpos[who]]);
  widget_display (river_attr4[tblpos[who]]);
  widget_flush (river_frame[tblpos[who]]);
  widget_flush (river_attr1[tblpos[who]]);
  widget_flush (river_attr2[tblpos[who]]);
  widget_flush (river_attr3[tblpos[who]]);
  widget_flush (river_attr4[tblpos[who]]);
}
#endif



static void
draw_hand (gp, who)
     global_t *gp;
{
  int i, j, k, n;
  int pp, pai, naki;
  int y;
  int opened = 0;

  if (!ch_hand[who] && !ch_play)
    {
      return;
    }
  ch_hand[who] = 0;

  pp = pplayer[who];

  n = hand[who].closed_num;
  canvas = hand_frame[tblpos[who]];
  canvas_clear ();

/*  for (k = 0; k < 4; k++)
    {
      if (k != vself)
	{
	  opened += !(hand[k].closed[0] < 4);
          
	}
    }
  if (opened == 1 || opened == 2) {
    return ;
  }
*/
  opened = 0;
  if (who == vself)
    {
      {
	int k;
	for (k = 0; k < 4; k++)
	  {
	    if (k != vself)
	      {
		opened |= !(hand[k].closed[0] < 4);
	      }
	  }
      }
      if (n != 14 && n != 11 && n != 8 && n != 5 && n != 2)
	{
	  goto normal;
	}
      if (opened) {
	widget_configure (canvas, resource_pixmapstart, PAI_W * 3);
      }
      for (i = 0; i < n - 1; i++)
	{
	  print_colorpixmap2 (pai2pix (hand[who].closed[i], tblpos[who], 0, opened));
	}
      print_colorpixmap2_withmargin (pai2pix (hand[who].closed[i], tblpos[who], 0, opened), HANDPAIMARGIN);
      if (opened) {
	widget_configure (canvas, resource_pixmapstart, HANDPAISTART);
      }
    }
  else
    {
      opened = !(hand[who].closed[0] < 4);	/* pai is invisible pai */
    normal:
      if (opened) {
	widget_configure (canvas, resource_pixmapstart, PAI_W * 3);
	for (i = 0; i < n; i++)
	  {
	    print_colorpixmap2 (pai2pix (hand[who].closed[i], tblpos[who], 0, opened));
	  }
	widget_configure (canvas, resource_pixmapstart, HANDPAISTART);
      } else {
	for (i = 0; i < n; i++)
	  {
	    print_colorpixmap2 (pai2pix (hand[who].closed[i], tblpos[who], 0, opened));
	  }
      }
    }

  n = hand[who].closed_num;
  i++;

  canvas = openhand_frame[tblpos[who]];

  naki = 0;
  for (j = 3; j >= 0; j--)
    {
      if (hand[who].opened_kind[j])
	{
	  naki++;
	}
    }
  canvas_clear ();
  if (naki)
    {
      widget_configure (canvas, resource_pixmapstart, (PAI_W * 8) +
			(3 - naki) * (PAI_W * 4) + (OPENPAIMARGIN * (3 - naki)));
      pmcontainer_clear (canvas);
      for (j = 3; j >= 0; j--)
	{
	  if (hand[who].opened_kind[j])
	    {
	      pmcontainer_set_margin (canvas, OPENPAIMARGIN);
	      for (k = 0; k < 4; k++)
		{
		  if (k == 3 && (hand[who].opened_kind[j] == H_TIE
				 || hand[who].opened_kind[j] == H_PON))
		    {
		      break;
		    }
		  pai = hand[who].opened[j][k];
		  if (hand[who].opened_kind[j] == H_KAN_CLOSED
		      && (k == 1 || k == 2))
		    {
		      pai = P_INV;
		    }
#if 0
		  print_colorpixmap2 (pai2pix (pai, tblpos[who], 0, PAIOPEN|PAIDARK));
#else 
		  print_colorpixmap2 (pai2pix (pai, tblpos[who], 0, PAIOPEN));
#endif
		  i++;
		}
	      pmcontainer_set_margin (canvas, 0);
	    }
	}
      widget_display (pai_frame[tblpos[who]]);
      widget_flush (pai_frame[tblpos[who]]);
    }
  else
    {
      widget_display (hand_frame[tblpos[who]]);
      widget_flush (hand_frame[tblpos[who]]);
    }
}

void
draw_title (gp)
global_t *gp;
{
/*  canvas = title_frame;
   canvas_clear ();
   print_colorpixmap (pm_title); */
/*  widget_display (menu_frame); */
  widget_flush (menu_frame);
}

ui_key ()
{
  extern widget_t root_widget;
  if (widget_eventsqueued (root_widget))
    {
      _widget_handle_event ();
    }
  return 0;
}


void
ui_draw (gp, redraw)
     global_t *gp;
{
  int i;

  D (fprintf (stderr, "ui draw"));

  flag_not_needredraw = 0;

  if (flag_not_needredraw) {
    return;
  }

  if (redraw)
    {
      ch_play = 1;
    }
  if (ch_play)
    {
      board_reset ();
    }
  tblpos = ((integer_t *) & (maptblpos[vself]._tblpos));	/* ANSI C */

  if (redraw) {
    draw_title (gp);
  }

  draw_status (gp);
  if ( flag_not_needdraw_hand ) {
    for (i = 0; i < 4; i++)
      {
	draw_player (gp, i);
      }
  } else {
    for (i = 0; i < 4; i++)
      {
	draw_player (gp, i);
	draw_river (gp, i);
	draw_hand (gp, i);
      }
  }
  board_sync ();
  ch_play = 0;
  flag_not_needdraw_hand = 0;
}

void
ui_expose (gp)
     global_t *gp;
{
/*  ui_draw (gp, 1); */
}



ui_menu (gp, c)
     global_t *gp;
     int c;
{
  return 0;
}


#include "misc.h"

extern integer_t flag_enable_select;
extern integer_t n_select;
extern integer_t readable_socket;
extern integer_t readable_key;
extern integer_t flag_enable_onboard;
extern integer_t iam;

integer_t
ui_event_wait (gp, time_out)
     global_t *gp;
{
  fd_set fds;
  struct timeval to, *top;
  int maxfd, fd;
  int xfd;
  D (fprintf (stderr, "ui event wait"));
  fd = callback_fd (gp);
  if (fd == -1)
    {
      goto xevent;
    }
  else if (fd == -2)
    {
      goto xevent;
    }
  else if (fd < 0)
    {
      goto xevent;
    }
  xfd = ConnectionNumber (xdisplay);
  FD_ZERO (&fds);
  FD_SET (0, &fds);
  FD_SET (fd, &fds);
  FD_SET (xfd, &fds);
  if (time_out >= 0)
    {
      to.tv_sec = time_out / 10;
      to.tv_usec = (time_out % 10) * 100000;
      top = &to;
    }
  else
    {
      top = 0;
    }
#define _max(a, b) ((a > b) ? a : b)
  maxfd = _max (fd, xfd);
  if (-1 == select (maxfd + 1,
		    &fds, (fd_set *) 0, (fd_set *) 0, top))
    {
      goto xevent;
    }
  if (fd && FD_ISSET (fd, &fds))
    {
      readable_socket = 1;
    }
  if (FD_ISSET (xfd, &fds))
    {
      readable_key = 1;
    xevent:
      if (widget_eventsqueued (root_widget))
	{
	  _widget_handle_event ();
	}
    }
  invoke_handlers ();
  return 0;
}

boolean button_map_p = 0;
boolean button_map_flag = 0;

void
board_button_map (flag)
{
  if (flag == 1)
    {
      widget_map (tie_button);
      widget_map (pon_button);
      widget_map (ron_button);
      widget_map (kan_button);
      widget_map (cancel_button);
    }
  else if (flag == 0)
    {
      widget_map (kan_button);
      widget_map (tumo_button);
      widget_map (reach_button);
    }
  button_map_p = 1;
  button_map_flag = flag;
}

void
board_button_display (flag)
{
  if (flag == 1)
    {				/* res */
      widget_display (tie_button);
      widget_display (pon_button);
      widget_display (ron_button);
      widget_display (kan_button);
      widget_display (cancel_button);
    }
  else if (flag == 0)
    {				/* choice */
      widget_display (tumo_button);
      widget_display (kan_button);
      widget_display (reach_button);
    }
}

void
board_button_unmap ()
{
  widget_unmap (kan_button);
  widget_unmap (tumo_button);
  widget_unmap (tie_button);
  widget_unmap (pon_button);
  widget_unmap (cancel_button);
  widget_unmap (ron_button);
  widget_xunmap (reach_button);
  button_map_p = 0;
}

/*
   choice:
   wake up new event loop ;

   This implementation is different from cui version, In `choice', we
   cannot handle socket IO.

 */
integer_t
choice (gp, n_draw, argc, argv, st, flag)
     global_t *gp;
     int n_draw;		/* number of pixmap2 in argv */
     int argc;			/* enable select number */
     gpixmap2_t argv[];
     int flag;			/* call from res, then 1, call from choice then 0 */
{
  int i;

  canvas = choicestate_frame;
  canvas_clear ();
  print_colorpixmap (pm_choice_state[st]);

  canvas = choice_frame;
  canvas_clear ();
  for (i = 0; i < n_draw; i++)
    {
      print_colorpixmap2 (argv[i]);
    }
  pmcontainer_display (choice_frame);
  pmcontainer_display (choicestate_frame);

  board_button_map (flag);
  board_button_display (flag);

  board_button_flush ();

  /* setup global variable for callback routines */
  flag_not_needredraw = 0;
  flag_enable_select = 1;
  n_select = argc;
  flag_enable_onboard = !flag;
  iam = tblpos[vself];
  if (flag_enable_onboard)
    {
      void board_button3press_callback ();
      widget_define_button_hook (3, board_button3press_callback);
    }
  get_choice ();

  n_select = 0;
  widget_define_button_hook (3, 0);

  pmcontainer_clear (choicestate_frame);
  pmcontainer_clear (choice_frame);
  pmcontainer_display (choicestate_frame);
  pmcontainer_display (choice_frame);
  board_button_unmap ();
  widget_display (action);
  board_button_flush ();

  return choiced;
}

void
mark (canvas)
     widget_t canvas;
{
  if (last_mark)
    {
      pmcontainer_clear (last_mark);
      widget_display (last_mark);
      widget_flush (last_mark);
      last_mark = 0;
    }
  canvas_clear ();
  print_colorpixmap (pm_current);
  widget_display (canvas);
  widget_flush (canvas);
  last_mark = canvas;
}




void restart_callback callbackarg_param
{
  do_disconnect (game_global);
  last_mark = 0;
}

void
game_redraw ()
{
  ui_draw (game_global, 1);
}

void flush_callback callbackarg_param
{
  extern widget_t root_widget;
  game_redraw ();
  widget_flush (root_widget);
  widget_sync (root_widget);
}

void invisible_config()
{
  extern int black, yellow, white;
  if (invisible_riverpai) {
    widget_configure (visible_button, resource_textcolor, black);
  } else {
    widget_configure (visible_button, resource_textcolor, white);
  }
}

void visible_callback callbackarg_param
{
  invisible_riverpai = !invisible_riverpai ;
  invisible_config();
  game_redraw ();
  widget_flush (root_widget);
  widget_sync (root_widget);
}
