/*  -*- Mode: C -*- 
 * This file is part of xnetmaj
 * 
 * yaku.c -- 
 * 
 * $Id: yaku.c,v 1.1 1995/04/23 01:32:45 ksr Exp ksr $
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Tue Apr 11 11:13:27 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Thu Jun  8 19:38:18 1995
 * description:
 *   draw yaku and points window
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */

#include "xnet.h"
#include "pixread.h"
#include "xnetmaj.h"

widget_t point;
extern integer_t xwidth, xheight;
static widget_t point_header;
static widget_t point_results;
static widget_t point_home[4];
static widget_t point_home_user[4];
static widget_t point_home_point[4];
static widget_t point_fu;
static widget_t point_fustr;
static widget_t point_fan;
static widget_t point_fanstr;
static widget_t point_yaku[30];
static widget_t point_yaku_point[30];

extern global_t *hora_global;

void keywait_callback ();
void quit_callback ();





widget_t
create_basic_info_frame (type, parent, pmframes, centerwidth, frame3_p, button_p)
     char *type;
     widget_t parent;
     widget_t pmframes[5];
     integer_t centerwidth;
     integer_t frame3_p;
     integer_t button_p;
{
  widget_t frame1, frame2, frame3, frame2left, frame2center, frame2right, frame4;
  widget_t okbutton, quitbutton;
  int x;
  integer_t frame1h, frame2h, frame3h, frame4h;
  extern int yellow;

  frame1 = widget_create ("frame", parent);
  frame2 = widget_create ("frame", parent);
  frame3 = widget_create ("pmcontainer", parent);
  frame4 = widget_create ("frame", parent);

  widget_configure (frame1, resource_packed, resource_horizontal);
  widget_set_geometry(frame1, xwidth, TOPMARGIN);
  widget_configure (frame1, resource_wrap, 0);

  widget_configure (frame2, resource_packed, resource_horizontal);
  widget_configure (frame4, resource_packed, resource_horizontal);
  frame2left = widget_create ("pmcontainer", frame2);
  frame2center = widget_create (type, frame2);
  frame2right = widget_create ("pmcontainer", frame2);

#if PAI3D
#define CENTERH 400
#else
#define CENTERH 300
#endif
  frame1h = TOPMARGIN;
  if (frame3_p) {
    frame3h = BOTTOMMARGIN;
  } else {
    frame3h = 5;
  }

  if (frame1h < 0) { frame1h = 5, frame3h = 5; } 

  frame4h = BUTTON_H;
  frame2h = xheight - (frame1h + frame3h + frame4h + BUTTON_H);

  widget_set_geometry (frame1, xwidth, frame1h);
  widget_configure (frame1, resource_wrap, 0);
  widget_set_geometry (frame3, xwidth, frame3h);
  widget_set_geometry (frame2, xwidth, frame2h);
   { 
     integer_t leftmargin = (xwidth - centerwidth)/2 ;
     widget_set_geometry (frame2left, leftmargin, frame2h);
     widget_set_geometry (frame2center, xwidth - leftmargin * 2, frame2h);
     widget_set_geometry (frame2right, leftmargin, frame2h);
   }

  if (button_p) {
    okbutton = widget_create ("button", frame4);
/*    quitbutton = widget_create ("button", frame4);  */
    widget_set_geometry (okbutton, BUTTON_W, BUTTON_H);
/*    widget_set_geometry (quitbutton, BUTTON_W, BUTTON_H); */
    widget_configure (okbutton, resource_text, "ok");
    widget_configure (okbutton, resource_textcolor, yellow);
    widget_configure (okbutton, resource_textfont, TIMESI);
    widget_add_callback (okbutton,
			 resource_buttonpress_callback,
			 (void *) keywait_callback, "");
/*
    widget_configure (quitbutton, resource_text, "quit");
    widget_configure (quitbutton, resource_textcolor, yellow);
    widget_configure (quitbutton, resource_textfont, TIMESI);
    widget_add_callback (quitbutton,
			 resource_buttonpress_callback,
			 (void *) quit_callback, "");*/
  }

  pmframes[0] = frame1;
  pmframes[1] = frame2left;
  pmframes[2] = frame2right;
  pmframes[3] = frame3;
  pmframes[4] = frame4;

  return frame2center;
}



void
point_init ()
{
  widget_t framepoint, frames[5];
  widget_t point_cell[30];
  integer_t i, x, y;
  integer_t n_point_idx_count; /* calculation maximam cell */

  memset (point_cell, 0, sizeof (point_cell));

  read_result_name ();

  framepoint = create_basic_info_frame ("frame", point, frames, PAI_W * 18, 0, 1);


  point_header = widget_create ("pmcontainer", framepoint);
  pmcontainer_print (point_header, pm_point_header);
  widget_set_geometry (point_header, 100, HEAD_H);

  widget_get_geometry(frames[1], &x, &y);
  
  n_point_idx_count = ((y - ((HEAD_H + 4) * 2) - (PAI_H + 4) * 3)/CELL_H);
  for (i = 0; i < n_point_idx_count && i < 24; i++)
    {
      point_cell[i] = widget_create ("frame", framepoint);
      widget_configure (point_cell[i],
			resource_packed, resource_horizontal);

      if (i == 0)
	{
	  widget_configure (point_cell[i],
			    resource_packed, resource_virtical);
	  point_results = widget_create ("pmcontainer", point_cell[i]);
	  widget_set_geometry (point_results, xwidth, HEAD_H + 4);
          hora_init(point_cell[i], xwidth-100);
	}
      else if (1 <= i && i <= 4)
	{
	  extern int yellow;
          widget_set_geometry (point_cell[i], xwidth, CELL_H);
	  point_home[i - 1] = widget_create ("pmcontainer", point_cell[i]);
	  point_home_user[i - 1] = widget_create ("text", point_cell[i]);
	  point_home_point[i - 1] = widget_create ("text", point_cell[i]);
	  widget_set_geometry (point_home[i - 1], 100, CELL_H);
	  widget_set_geometry (point_home_user[i - 1], 100, CELL_H);
	  widget_set_geometry (point_home_point[i - 1], 150, CELL_H);

	  widget_configure (point_home_user[i-1], resource_textfont, TIMESIB);
	}
      else if (i == 5)
	{
  	 /* spaceing */
	  widget_t graph;
          widget_set_geometry (point_cell[i], xwidth, CELL_H);
	  graph = widget_create ("pmcontainer", point_cell[i]);
          widget_set_geometry (graph, xwidth, CELL_H);	  
	}
      else if (i == 6)
	{
	  point_fu = widget_create ("text", point_cell[i]);
	  point_fustr = widget_create ("pmcontainer", point_cell[i]);
	  point_fan = widget_create ("text", point_cell[i]);
	  point_fanstr = widget_create ("pmcontainer", point_cell[i]);
	  widget_set_geometry (point_fu, 96, HEAD_H);
	  widget_set_geometry (point_fustr, 48, HEAD_H);
	  widget_set_geometry (point_fan, 96, HEAD_H);
	  widget_set_geometry (point_fanstr, 48, HEAD_H);
	  widget_configure (point_fu, resource_textfont, HELVB);
	  widget_configure (point_fan, resource_textfont, HELVB);
	}
      else if (i < 36)
	{
#define YB 7
	  point_yaku[i - YB] = widget_create ("pmcontainer", point_cell[i]);
	  point_yaku_point[i - YB] = widget_create ("text", point_cell[i]);
	  widget_set_geometry (point_yaku[i - YB], 200, CELL_H);
	  widget_set_geometry (point_yaku_point[i - YB], 100, CELL_H);
	  widget_configure (point_yaku_point[i - YB], resource_textfont, TIMESI);
	}
    }				/* for */

  pmcontainer_print (point_fustr, pm_point_fu_sfx);
  pmcontainer_print (point_fanstr, pm_point_fan_sfx);

  widget_pack (point);
  widget_fix (point);

  widget_set_geometry (point, xwidth, xheight);
}

static void
point_clear ()
{
  integer_t i;
  pmcontainer_clear (point_results);
  for (i = 0; i < 4; i++)
    {
      pmcontainer_clear (point_home[i]);
    }
  for (i = 0; i < 30; i++)
    {
      if (!point_yaku[i]) {
	continue;
      }
      pmcontainer_clear (point_yaku[i]);
    }

}

static int point_color(point)
integer_t point;
{
  int color;
  extern int darkorange, yellow, white;
  if (point > 0) {
    color = white;
  } else if (point == 0) {
    color = yellow;
  } else {
    color = darkorange;
  }
  return color;
}

ui_result (gp)
     global_t *gp;
{
  int p, i;
  int iy[4];
  char buf[1024];
  int n = 0;

  flag_not_needredraw = 0;
  point_clear ();

  memcpy (hora_global, gp, sizeof (global_t));

  for (p = 0; p < 4; p++)
    {
      if (result[p].flag == 0)
	{
	  continue;
	}
      n++;
    }
  for (p = 0; p < 4; p++)
    {
      if (result[p].flag == 0)
	{
	  continue;
	}
      hora_reset ();
      if (result[p].flag != RESULT_RYUKYOKU && (result[p].who != -1)) {
	hora_set(hora_global, result[p].who);
      }

      result_cvt_to_int (result + p, iy);
      pmcontainer_print (point_results, pm_result_name[result[p].flag]);

      for (i = 0; i < 4; i++) {
	int color;
	extern int yellow, darkorange, white;
	pmcontainer_print (point_home[i], pm_home_names[i]);
	print_yakupoint (point_home_point[i], result[p].points[i]);

	widget_configure (point_home_user[i], resource_text, player[pplayer[i]].name);
	color = point_color(result[p].points[i]);
	widget_configure (point_home_user[i], resource_textcolor, color);
      }

      print_yakupoint (point_fu, result[p].fu);
      print_yakupoint (point_fan, result[p].fan);

#define yaku_idx(idx)  		\
		if (!point_yaku[idx]) { goto YAKUEND; }

      {
	integer_t idx = 0;
	for (i = 0; i < Y_MAX; i++)
	  {
	    if (Y_GET (iy, i))
	      {
		gpixmap2_t yaku;
		yaku = (gpixmap2_t) yaku2pix (i);

		yaku_idx(idx);
		pmcontainer_print (point_yaku[idx], (*yaku));
		widget_configure (point_yaku_point[idx], resource_text, "");
		idx++;
	      }
	  }

	if (result[p].dora)
	  {
	    yaku_idx(idx);
	    pmcontainer_print (point_yaku[idx], pm_yaku_dora_str);
	    print_yakupoint (point_yaku_point[idx], result[p].dora);
	    idx++;
	  }
	if (result[p].uradora)
	  {
	    yaku_idx(idx);
	    pmcontainer_print (point_yaku[idx], pm_yaku_uradora_str);
	    print_yakupoint (point_yaku_point[idx], result[p].uradora);
	    idx++;
	  }
	if (result[p].akadora)
	  {
	    yaku_idx(idx);
	    pmcontainer_print (point_yaku[idx], pm_yaku_akadora_str);
	    print_yakupoint (point_yaku_point[idx], result[p].akadora);
	    idx++;
	  }
	for (; idx < 30; idx++)
	  {
	    if (!point_yaku[idx]) {
	      continue;
	    }
	    pmcontainer_clear (point_yaku[idx]);
	    widget_configure (point_yaku_point[idx], resource_text, "");
	  }
      }
    YAKUEND:
      if (result[p].flag != RESULT_RYUKYOKU && (result[p].who != -1)) {
	draw_hora();
      }
      {
	extern widget_t board;
	extern widget_t gameend;
	widget_unmap (board);
/*	widget_unmap (gameend); */
	widget_map (point);
	widget_display (point);
	widget_flush (point);
	
	wait_key ();

	hora_reset();
      }
    }
  widget_unmap (point);

  board_reset ();
  board_redraw (); 
}

















/*
   gameend window
 */

widget_t gameend;
static widget_t gameend_header;
static widget_t gameend_pos;
static widget_t gameend_pai;
static widget_t gameend_name[4];
static widget_t gameend_tpoint[4];
static widget_t gameend_rpoint[4];
static widget_t gameend_xpoint[4];

extern int white;
void
gameend_init ()
{
  widget_t framepoint, pmframes[5];
  widget_t point_cell[4];
  int i;
  framepoint = create_basic_info_frame ("frame", gameend, pmframes, 400, 0, 1);

  gameend_header = widget_create ("pmcontainer", framepoint);
  widget_set_geometry (gameend_header, xwidth - (LEFTMARGIN * 2), HEAD_H);

  gameend_pos = widget_create ("pmcontainer", framepoint);
  widget_set_geometry (gameend_pos, xwidth - (LEFTMARGIN * 2), 73);

  for (i = 0; i < 4; i++)
    {
      point_cell[i] = widget_create ("frame", framepoint);
      widget_configure (point_cell[i],
			resource_packed, resource_horizontal);
      widget_set_geometry (point_cell[i], xwidth, BDIGIT_H);

      gameend_name[i] = widget_create ("text", point_cell[i]);
      widget_set_geometry (gameend_name[i], 100, BDIGIT_H);
      widget_configure (gameend_name[i], resource_textfont, TIMESIB);
      widget_configure (gameend_name[i], resource_textcolor, white);

      gameend_tpoint[i] = widget_create ("text", point_cell[i]);
      widget_set_geometry (gameend_tpoint[i], 100, BDIGIT_H);
      widget_configure (gameend_tpoint[i], resource_textfont, TIMESIB);
      widget_configure (gameend_tpoint[i], resource_textcolor, white);

      gameend_rpoint[i] = widget_create ("text", point_cell[i]);
      widget_set_geometry (gameend_rpoint[i], 100, BDIGIT_H);
      widget_configure (gameend_rpoint[i], resource_textfont, TIMESIB);
      widget_configure (gameend_rpoint[i], resource_textcolor, white);

      gameend_xpoint[i] = widget_create ("text", point_cell[i]);
      widget_set_geometry (gameend_xpoint[i], 100, BDIGIT_H);
      widget_configure (gameend_xpoint[i], resource_textfont, HELVB);
      widget_configure (gameend_xpoint[i], resource_textcolor, white);
    }

  pmcontainer_print (gameend_header, pm_gameend_header);
  widget_pack (gameend);
  widget_fix (gameend);

  widget_set_geometry (gameend, xwidth, xheight);
}



void
gameend_clear ()
{
  int i;
  for (i = 0; i < 4; i++)
    {
      widget_configure (gameend_name[i], resource_text, "");
      pmcontainer_clear (gameend_pos);
      pmcontainer_clear (gameend_tpoint[i]);
      pmcontainer_clear (gameend_rpoint[i]);
      pmcontainer_clear (gameend_xpoint[i]);
    }
}

static void print_pos(canvas, val)
widget_t canvas; 
integer_t val;
{
  if (val <= 0 || val > 4)
    {
      return;			/* unsupport 10 ponba or 10 kyoku */
    }
  else
    {
      _print_colorpixmap (canvas, pm_posdigit[val]);
    }
}

static void print_pospai(canvas, val)
widget_t canvas;
integer_t val;
{
  gpixmap2_t pm;
  static char kindtable[] = {19, 1, 10, 19, 10, 1, 19, 10, 10, 1};
  unsigned int kind = ((unsigned int)randval() % sizeof(kindtable));

  assert(val >= 1 && val <= 4);
  pm = pai2pix((4 * (kindtable[kind % sizeof(kindtable)] + (val -1 ))), 
	       3, 0, 1);
  print_colorpixmap2_withmargin(pm, 10);
  print_colorpixmap2(pm);
  print_colorpixmap2(pm);
}



ui_message_gend (gp)
     global_t *gp;
{
  int i;
  integer_t xpoint[4];
  static int kind = 0;
  widget_t canvas;

  for (i = 0; i < 4; i++)
    {
      widget_configure (gameend_name[i], resource_text, player[i].name);
      print_yakupoint (gameend_rpoint[i], player[i].rpoint);
      print_yakupoint (gameend_tpoint[i], player[i].tpoint);
      xpoint[i] = player[i].rpoint * 100 + player[i].tpoint * 500;
      print_yakupoint (gameend_xpoint[i], xpoint[i]);
      widget_configure (gameend_name[i], resource_textcolor,
			point_color(xpoint[i]));
      widget_configure (gameend_xpoint[i], resource_textcolor, 
			point_color(xpoint[i]));
    }
  {
    int i, pos = 1;
    for (i = 0; i < 4; i++) {
      if (xpoint[i] > xpoint[self]) {
	pos++;
      }
    }
    canvas = gameend_pos;
    canvas_clear();
/*    print_pos (gameend_pos, pos); */
    print_pospai (gameend_pos, pos);
  }


  {
    extern widget_t board;
    widget_unmap (board);
    widget_unmap (point);

    widget_map (gameend);
    widget_display (gameend);
    widget_flush (gameend);


    wait_key ();


    widget_unmap (gameend);

  }
  do_disconnect (gp);

  board_reset ();
  board_redraw (); 
}

void
make_point ()
{
  extern widget_t root_widget;
  extern integer_t xwidth, xheight;

  point = widget_create ("frame", root_widget);
  gameend = widget_create ("frame", root_widget);
  widget_configure (point, resource_name, "point");
  widget_configure (gameend, resource_name, "gameend");
  widget_set_geometry (point, xwidth, xheight);
  widget_set_geometry (gameend, xwidth, xheight);

  widget_add_callback (point,
		       resource_keypress_callback,
		       (void *) keywait_callback, "");
  widget_add_callback (gameend,
		       resource_keypress_callback,
		       (void *) keywait_callback, "");
  widget_add_callback (point,
		       resource_buttonpress_callback,
		       (void *) keywait_callback, "");
  widget_add_callback (gameend,
		       resource_buttonpress_callback,
		       (void *) keywait_callback, "");


  point_init ();
  gameend_init ();

#if 0
  {
    extern widget_t board;
    widget_unmap (board);

    widget_map (point);
    widget_display (point);
    widget_flush (point);
    wait_key ();

    widget_map (gameend);
    widget_display (gameend);
    widget_flush (point);
    wait_key ();
  }
#endif
}
