/* Support for printing Modula 2 values for GDB, the GNU debugger.
   Copyright 1986, 1988, 1989, 1991 Free Software Foundation, Inc.

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "defs.h"
#include "obstack.h"
#include "symtab.h"
#include "gdbtypes.h"
#include "valprint.h"

/* Oliver: added includes */
#include "value.h"
#include "typeprint.h"

/* FIXME:  For now, just explicitly declare c_val_print and use it instead */

/* Oliver */
extern unsigned int repeat_count_threshold;

int
m2_val_print (type, valaddr, address, stream, format, deref_ref, recurse,
	      pretty)
     struct type *type;
     char *valaddr;
     CORE_ADDR address;
     GDB_FILE *stream;
     int format;
     int deref_ref;
     int recurse;
     enum val_prettyprint pretty;
     
{
  extern int
    c_val_print PARAMS ((struct type *, char *, CORE_ADDR, GDB_FILE *, int, int,
			 int, enum val_prettyprint));
  /* Oliver */
  switch (TYPE_CODE(type))
    {
    case TYPE_CODE_SET:
      {
	struct type *range = TYPE_FIELD_TYPE (type, 0);
	int low_bound = TYPE_LOW_BOUND (range);
	int high_bound = TYPE_HIGH_BOUND (range);
	int i, first;
	int need_comma = 0;
	
	fputs_filtered ("{", stream);
	for (i = low_bound; i <= high_bound; i++)
	  {
	    int element = value_bit_index (type, valaddr, i);
	    if (element)
	      {
		if (need_comma)
		  fputs_filtered (", ", stream);
		print_type_scalar (TYPE_TARGET_TYPE (range), i, stream);
		need_comma = 1;
		first = i;
		
		/* Look for a continuous range of true elements, larger than repeat_count. */
		if (i+1 <= high_bound && value_bit_index (type, valaddr, ++i))
		  {
		    int j = i; /* j is the upper bound so far of the range */
		    while (i+1 <= high_bound
			   && value_bit_index (type, valaddr, ++i))
		      j = i;
		    if (j-first >= repeat_count_threshold)
		      {
			fputs_filtered ("..", stream);
			print_type_scalar (TYPE_TARGET_TYPE (range), j, stream);
		      }
		    else
		      {
			for (j=first+1; j<i ;j++)
			  {
			    fputs_filtered(", ", stream);
			    print_type_scalar (TYPE_TARGET_TYPE(range), j, stream);
			  }
		      }
		  }
	      }
	  }
	
	fputs_filtered ("}", stream);
	
	break;
	
      }
    default:
      return (c_val_print (type, valaddr, address, stream, format, deref_ref,
			   recurse, pretty));
    }
  
}




