#ifndef OMEYER
#define OMEYER

/* Oliver
 * Diese Makro uebrprueft, ob *pp vielleicht bereits schon zu ende ist. Da der
 * Sun Modula 2 Compiler keine zwei, sondern nur ein Semikolon an das Ende
 * einer Struct (hier natuerlich RECORD) Typendefinition haengt ist der String
 * bereits komplett gelesen nachdem das letzte Symbol (incl. letztem Semikolon)
 * ausgelesen wurde.
 */
#define OM_ENDMOD2 ((**pp == '\000') && current_subfile->language==language_m2)

/*
 * Maximale Anzahl der Module pro Objektfile.
 * Da die Speicherverwaltung mir Probleme machte (warum nur?) belege ich anfangs
 * Speicher fuer OM_MAXMOD Eintraege.
 */
#ifndef OM_MAXMOD
#define OM_MAXMOD 1000
#endif

struct module_entry
{
  /* Name des Modules */
  char *name;

  /* Nummer des Modules == Index im Array */
  int number;

  /*
   * Zeiger auf das symtab struct des Modules, oder NULL,
   * wenn noch nicht zugewiesen
   */
  struct symtab *symbol_table;
};


/*
 * Wird automatisch in das symtab Strukt eingefuegt.
 */
#define EXTRA_SYMTAB_INFO /* Anzahl der Module im Array */\
                          int nmodules; \
                          \
                          /* Zeiger auf das Array */\
                          struct module_entry *modules;

/* Zugriff auf das module_array */
#define MODULES(symtab)  ((struct module_entry*)(symtab)->modules)


#endif



