*** symtab.c	Sat Apr  8 18:44:37 1995
--- ../m23gdb/symtab.c	Sat Apr 15 01:19:54 1995
***************
*** 305,310 ****
--- 306,318 ----
        if (strcmp(buf, "__") == 0)
  	buf[0] = '\0';
      }
+   else if (newname != NULL && strchr (newname, '<') != NULL)
+     {
+       /* Template methods are fully mangled.  */
+       sprintf (buf, "__%s%s", const_prefix, volatile_prefix);
+       newname = NULL;
+       len = 0;
+     }
    else
      {
        sprintf (buf, "__%s%s%d", const_prefix, volatile_prefix, len);
***************
*** 721,732 ****
  	    }
  	}
      }
- 
    if (symtab != NULL)
      *symtab = NULL;
    return 0;
  }
  
  /* Look, in partial_symtab PST, for symbol NAME.  Check the global
     symbols if GLOBAL, the static symbols if not */
  
--- 684,788 ----
  	    }
  	}
      }
    if (symtab != NULL)
      *symtab = NULL;
    return 0;
  }
  
+ /* Oliver:
+  * Sucht eine Symboltabelle zu dem Module name
+  * FIXME: Die Suche erfolgt ueber den Dateinamen!
+  */
+ struct symtab *
+ lookup_symtab_by_modulename(name)
+      const char *name;
+ {
+   char *name2;
+   struct symtab *symt;
+   
+   name2 = malloc(strlen(name)+5);
+   strcpy(name2,name);
+   strcat(name2,".mod");
+   if ((symt = lookup_symtab(name2)))
+     {
+       return symt;
+     }
+   else
+     {
+       static struct complaint no_such_module =
+ 	{
+ 	  "can't find module %s", 0, 0
+ 	};
+       
+       complain(&no_such_module, name2);
+       return NULL;
+     }
+ }
+ 
+ 
+ /* Oliver:
+  * Suche das Symbol mit dem Namen sym_name im Module namens modulename
+  */
+ 
+ struct symbol *
+ lookup_imported_symbol(sym_name, modulename)
+      const char *sym_name;
+      const char *modulename;
+      
+ {
+   struct symtab *symt;
+   struct symbol *defined_symbol;
+   struct block *block_i;
+   int i;
+ 
+ #if 0
+   if (!(symt = module->symbol_table))
+     {
+       symt = lookup_symtab_by_modulename(modulename);
+       module->symbol_table = symt;
+     }
+ #endif
+   symt = lookup_symtab_by_modulename(modulename);
+   
+   if (symt)
+     {
+       
+       /*
+        * in symt steht jetzt die Symtab, die die wirkliche
+        * Definition des Symbols mit der nummer sym_nr enthaelt.
+        * Hier muessen jetzt saemtliche im blockvector dieser symtab enthaltenen
+        * bloecke durchsucht werden. (wirklich ?)
+        */
+       for (defined_symbol = NULL,i = 0;(!defined_symbol) && (i<BLOCKVECTOR_NBLOCKS(BLOCKVECTOR(symt)));i++)
+ 	{
+ 	  block_i = BLOCKVECTOR_BLOCK(BLOCKVECTOR(symt),i);
+ 	  
+ 	  defined_symbol = lookup_block_symbol(block_i, sym_name, VAR_NAMESPACE);
+ 	  if (!defined_symbol)
+ 	    defined_symbol = lookup_block_symbol(block_i, sym_name, STRUCT_NAMESPACE);
+ 	  if (!defined_symbol)
+ 	    defined_symbol = lookup_block_symbol(block_i, sym_name, UNDEF_NAMESPACE);
+ 	}
+       if (!defined_symbol)
+ 	{
+ 	  static struct complaint msg =
+ 	    {
+ 	      "Can't find symbol %s in File %s", 0, 0
+ 	    };
+ 	  
+ 	  complain(&msg, sym_name, modulename);
+ 	}
+ 
+       
+       return defined_symbol;
+     }
+   else
+     return NULL;
+   
+   
+ }
+ 
+ 
  /* Look, in partial_symtab PST, for symbol NAME.  Check the global
     symbols if GLOBAL, the static symbols if not */
  
***************
*** 751,760 ****
  	   pst->objfile->global_psymbols.list + pst->globals_offset :
  	   pst->objfile->static_psymbols.list + pst->statics_offset  );
  
!   if (global)		/* This means we can use a binary search. */
!     {
!       do_linear_search = 0;
  
        /* Binary search.  This search is guaranteed to end with center
           pointing at the earliest partial symbol with the correct
  	 name.  At that point *all* partial symbols with that name
--- 807,817 ----
  	   pst->objfile->global_psymbols.list + pst->globals_offset :
  	   pst->objfile->static_psymbols.list + pst->statics_offset  );
  
!   do_linear_search = SYMBOL_LANGUAGE (start) == language_cplus 
!     || SYMBOL_LANGUAGE (start) == language_m3;
  
+   if (global && !do_linear_search)
+     {
        /* Binary search.  This search is guaranteed to end with center
           pointing at the earliest partial symbol with the correct
  	 name.  At that point *all* partial symbols with that name
***************
*** 852,862 ****
    register int bot, top, inc;
    register struct symbol *sym;
    register struct symbol *sym_found = NULL;
!   register int do_linear_search = 1;
  
    /* If the blocks's symbols were sorted, start with a binary search.  */
! 
!   if (BLOCK_SHOULD_SORT (block))
      {
        /* Reset the linear search flag so if the binary search fails, we
  	 won't do the linear search once unless we find some reason to
--- 905,918 ----
    register int bot, top, inc;
    register struct symbol *sym;
    register struct symbol *sym_found = NULL;
!   register int do_linear_search =
!     BLOCK_SHOULD_SORT (block) == 0
!       || (BLOCK_NSYMS (block) > 0 && 
! 	  (SYMBOL_LANGUAGE (BLOCK_SYM (block, 0)) == language_m3
! 	   || SYMBOL_LANGUAGE (BLOCK_SYM (block, 0)) == language_cplus));
  
    /* If the blocks's symbols were sorted, start with a binary search.  */
!   if (!do_linear_search)
      {
        /* Reset the linear search flag so if the binary search fails, we
  	 won't do the linear search once unless we find some reason to
***************
*** 1799,1805 ****
     FUNCTION may be an undebuggable function found in minimal symbol table.
  
     If the argument FUNFIRSTLINE is nonzero, we want the first line
!    of real code inside a function when a function is specified.
  
     DEFAULT_SYMTAB specifies the file to use if none is specified.
     It defaults to current_source_symtab.
--- 1855,1862 ----
     FUNCTION may be an undebuggable function found in minimal symbol table.
  
     If the argument FUNFIRSTLINE is nonzero, we want the first line
!    of real code inside a function when a function is specified, and it is
!    not OK to specify a variable or type to get its line number.
  
     DEFAULT_SYMTAB specifies the file to use if none is specified.
     It defaults to current_source_symtab.
***************
*** 2215,2232 ****
    /* Let's try to interpret the whole arg as an expression */
    { struct expression *expr;
      struct symbol *exports;
!     value_ptr val;
      struct type *implementers;
  
!     if ((expr = (struct expression *) catch_errors ((long (*)()) parse_expression, saved_arg, (char *) 0, RETURN_MASK_ALL)) != 0
! 	&& (val = (value_ptr) catch_errors ((long (*)()) evaluate_expression, expr, (char *) 0, RETURN_MASK_ALL)) != 0) {
!       if (TYPE_CODE (VALUE_TYPE (val)) == TYPE_CODE_M3_PROC) {
! 	pc = m3_unpack_pointer2 (val);
  
  	if (pc == 0 && expr->elts[1].opcode == STRUCTOP_M3_INTERFACE) {
  	  /* may be we found a procedure exported by an interface but
  	     implemented by a module with a different name, and the
! 	     init code did not run yet, so the pointer in the interface 
  	     record isn't set yet.  It could also be a global var so
  	     we have to be careful. saved_arg is of the form a.b, we
  	     want to isolate a. */
--- 2272,2289 ----
    /* Let's try to interpret the whole arg as an expression */
    { struct expression *expr;
      struct symbol *exports;
!     value_ptr new_val;
      struct type *implementers;
  
!     if ((expr = (struct expression *) catch_errors ((int (*)(char*))parse_expression, saved_arg, (char *) 0, RETURN_MASK_ALL)) != 0
! 	&& (new_val = (value_ptr) catch_errors ((int (*)(char *))evaluate_expression, expr, (char *) 0, RETURN_MASK_ALL)) != 0) {
!       if (TYPE_CODE (VALUE_TYPE (new_val)) == TYPE_CODE_M3_PROC) {
! 	pc = m3_unpack_pointer2 (new_val);
  
  	if (pc == 0 && expr->elts[1].opcode == STRUCTOP_M3_INTERFACE) {
  	  /* may be we found a procedure exported by an interface but
  	     implemented by a module with a different name, and the
! 	     init code did not run yet, so the interface interface
  	     record isn't set yet.  It could also be a global var so
  	     we have to be careful. saved_arg is of the form a.b, we
  	     want to isolate a. */
***************
*** 2243,2264 ****
  	      && (implementers 
  		  = lookup_struct_elt_type (SYMBOL_TYPE (exports), 
  					    interface_name, 1))
! 	      != 0) {
! 	    for (i = 0; i < TYPE_NFIELDS (implementers); i++) {
! 	      sprintf (foo, "%s%s", TYPE_FIELD_NAME (implementers, i),
! 		       *argptr);
! 	      if (expr = (struct expression *) catch_errors ((long (*)()) parse_expression,
! 							     foo, (char *) 0, RETURN_MASK_ALL)) {
! 		if ((val = (value_ptr) catch_errors ((long (*)()) evaluate_expression,
  						 expr, (char *) 0,
! 						 RETURN_MASK_ALL)) != 0) {
! 		  if (TYPE_CODE (VALUE_TYPE (val)) == TYPE_CODE_M3_PROC) {
! 		    pc = m3_unpack_pointer2 (val);
! 		    break; }}}}}}
! 	while (**argptr != '\000') {
! 	  (*argptr)++; }
  	sym = 0;
! 	goto i_have_a_pc; }}}
  
    /* Look up that token as a variable.
       If file specified, use that file's per-file block to start with.  */
--- 2300,2346 ----
  	      && (implementers 
  		  = lookup_struct_elt_type (SYMBOL_TYPE (exports), 
  					    interface_name, 1))
! 	      != 0)
! 	    {
! 	      for (i = 0; i < TYPE_NFIELDS (implementers); i++)
! 		{
! 		  sprintf (foo, "%s%s", TYPE_FIELD_NAME (implementers, i), *argptr);
! 		  if (expr = (struct expression *) catch_errors ((int (*)(char *))parse_expression,
! 								 foo, (char *) 0, RETURN_MASK_ALL))
! 		    {
! 		      if ((new_val = (value_ptr) catch_errors ((int (*)(char*))evaluate_expression,
  							   expr, (char *) 0,
! 							   RETURN_MASK_ALL)) != 0)
! 			{
! 			  if (TYPE_CODE (VALUE_TYPE (new_val)) == TYPE_CODE_M3_PROC)
! 			    {
! 			      pc = m3_unpack_pointer2 (new_val);
! 			      break;
! 			    }
! 			}
! 		    }
! 		}
! 	    }
! 	}
! 	while (**argptr != '\000')
! 	  {
! 	    (*argptr)++;
! 	  }
  	sym = 0;
! 	/* This ugly piece of code remains from the i_have_a_pc code this used to jump to */
! 	if (funfirstline)
! 	  {
! 	    pc += FUNCTION_START_OFFSET;
! 	    SKIP_PROLOGUE (pc);
! 	  }
! 	val = find_pc_line (pc, 0);
! 	val.pc = pc;
! 	values.sals = (struct symtab_and_line *)xmalloc (sizeof (struct symtab_and_line));
! 	values.sals[0] = val;
! 	goto i_have_a_value;
!       }
!     }
!   }
  
    /* Look up that token as a variable.
       If file specified, use that file's per-file block to start with.  */
***************
*** 2316,2321 ****
--- 2375,2384 ----
  	    }
  	  return values;
  	}
+       else
+ 	{
+ 	  if (funfirstline)
+ 	    error ("\"%s\" is not a function", copy);
  	  else if (SYMBOL_LINE (sym) != 0)
  	    {
  	      /* We know its line number.  */
***************
*** 2330,2339 ****
        else
  	/* This can happen if it is compiled with a compiler which doesn't
  	   put out line numbers for variables.  */
! 	/* FIXME: Shouldn't we just set .line and .symtab to zero and
! 	   return?  For example, "info line foo" could print the address.  */
  	error ("Line number not known for symbol \"%s\"", copy);
      }
  
    msymbol = lookup_minimal_symbol (copy, (struct objfile *) NULL);
    if (msymbol != NULL)
--- 2393,2404 ----
  	  else
  	    /* This can happen if it is compiled with a compiler which doesn't
  	       put out line numbers for variables.  */
! 	    /* FIXME: Shouldn't we just set .line and .symtab to zero
! 	       and return?  For example, "info line foo" could print
! 	       the address.  */
  	    error ("Line number not known for symbol \"%s\"", copy);
  	}
+     }
  
    msymbol = lookup_minimal_symbol (copy, (struct objfile *) NULL);
    if (msymbol != NULL)
