/*
    mplay   Copyright (c) 1995, By Brian E. Litzinger <brian@apt.bungi.com>
	    ALL RIGHTS RESERVED

*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "tm_ioctl.h"
#define DEV "/dev/tm0"

static unsigned short bigbuf[32256];

void
main(int argc, char *argv[]) {
    FILE *fd;
    int tm;
    int bigbufcnt;

    if (argc!=2) {
	fprintf(stderr,"Invalid usage\n");
	fprintf(stderr,"Usage: mplay mpegstream\n");
	exit(-1);
    }

    if ((fd=fopen(argv[1],"rb"))==NULL) {
	fprintf(stderr,"unable to fopen(%s,...), errno %d\n",argv[1],errno);
	exit(-1);
    }
    if ((tm=open(DEV,O_RDWR))==-1) {
        fprintf(stderr,"open of %s failed\n",DEV);
        fclose(fd);
        exit(-1);
    }

    ioctl(tm,TM_RESET,NULL);
    sleep(2);

    ioctl(tm,TM_PLAY,NULL);
    sleep(2);

    while ((bigbufcnt=fread(bigbuf,1,sizeof(bigbuf),fd))>0) {
	write(tm,bigbuf,bigbufcnt);
    }

    fclose(fd);
    close(tm);
}
