#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <string.h>

#include "tm_ioctl.h"

#define DEV "/dev/tm0"

static void bulkload(int tm, char *file);
static void bulkdump(int tm);
static void Usage(void);

static char *MyName;

void
main(int argc, char *argv[]) {
    int fd;
    char *CMD = argv[1];

    MyName = argv[0];

    if (argc<2) {
        fprintf(stderr,"Invalid # of arguments\n");
        Usage();
    }

    if ((fd=open(DEV,O_RDWR))==-1) {
        fprintf(stderr,"open of %s failed, errno %d\n",DEV,errno);
        exit(-1);
    }

    if (!strcmp(CMD,"w")) {
        if (argc==4) {
            char *IDX = argv[2];
            char *DAT = argv[3];
	    int idx;
	    int dat;
	    struct tm_regop_t ro;

            sscanf(IDX,"%x",&idx);
            sscanf(DAT,"%x",&dat);
            ro.idx = (unsigned short) idx;
            ro.dat = (unsigned short) dat;
            if (ro.idx<0x0100) 
		ioctl(fd,TM_SETBYTEREG,&ro);
	    else
		ioctl(fd,TM_SETWORDREG,&ro);
        } else {
            Usage();
        }
    } else if (!strcmp(CMD,"r")) {
        if (argc==3) {
            char *IDX = argv[2];
	    int idx;
	    struct tm_regop_t ro;

            sscanf(IDX,"%x",&idx);
            ro.idx = (unsigned short) idx;
            if (ro.idx<0x0100) {
		ioctl(fd,TM_GETBYTEREG,&ro);
		printf("%04x:   0x%02x\n",ro.idx,(unsigned char)ro.dat);
	    } else {
		ioctl(fd,TM_GETWORDREG,&ro);
		printf("%04x: 0x%04x\n",ro.idx,ro.dat);
	    }
        } else {
            Usage();
        }
    } else if (!strcmp(CMD,"init")) {
        if (argc==3) {
            char *IDX = argv[2];
	    int idx;
	    struct tm_regop_t ro;

            sscanf(IDX,"%x",&idx);
            ro.idx = (unsigned short) idx;
            ro.dat = (unsigned short) 0;  /* not necessary */
	    ioctl(fd,TM_INIT,&ro);
        } else {
            Usage();
        }
    } else if (!strcmp(CMD,"pollslice")) {
        if (argc==3) {
            char *IDX = argv[2];
	    int idx;
	    unsigned short pollslice;

            sscanf(IDX,"%x",&idx);
            pollslice = (unsigned short) idx;
	    ioctl(fd,TM_POLLSLICE,&pollslice);
        } else {
            Usage();
        }
    } else if (!strcmp(CMD,"window")) {
        if (argc==3) {
            if (!strcmp(argv[2],"on")) {
		struct tm_regop_t ro;

		ro.idx = 0x92;
		ro.dat = 0x04;
		ioctl(fd,TM_SETBYTEREG,&ro);
            } else if (!strcmp(argv[2],"off")) {
		struct tm_regop_t ro;

		ro.idx = 0x92;
		ro.dat = 0x3c;
		ioctl(fd,TM_SETBYTEREG,&ro);
            } else {
		Usage();
	    }
        } else {
            Usage();
        }
    } else if (!strcmp(CMD,"mac")) {
        if (argc==3) {
            bulkload(fd, argv[2]);
        } else {
            Usage();
        }
    } else if (!strcmp(CMD,"dump")) {
	bulkdump(fd);
    } else if (!strcmp(CMD,"loadpal")) {
	ioctl(fd,TM_LOADPAL,NULL);
    } else if (!strcmp(CMD,"resetmpeg")) {
	ioctl(fd,TM_RESETMPEG,NULL);
    } else {
	fprintf(stderr,"unrecognized command %s\n",CMD);
    }
}

static void
Usage() {
    fprintf(stderr,"Invalid arguments\n");
    fprintf(stderr,"[usage under construction, please make an error at a later time]\n");
    exit(-1);
}

static void
bulkload(int tm, char *file) {
    FILE *fd;
    char buf[80];
    int i;
    struct tm_regop_t ro;
    char cmd[80];
    int reg;
    int val;

    if ((fd=fopen(file,"r"))==NULL) {
        fprintf(stderr,"Unable to open %s, errno %d\n",file,errno);
        exit(-1);
    }

    i = 0;
    while (fgets(buf,sizeof(buf),fd)!=NULL) {
        i++;
        if (buf[0] != '#') {
            if (sscanf(buf,"%s %x %x",cmd,&reg,&val)==3) {  /* *** WARNING *** */
                if (!strcmp(cmd,"wr")) {
		    ro.idx = (unsigned short) reg;
		    ro.dat = (unsigned short) val;
		    if (ro.idx<=0x0100) {
			ioctl(tm,TM_SETBYTEREG,&ro);
		    } else {
			ioctl(tm,TM_SETWORDREG,&ro);
		    }
                } else {
                    { char *p = strchr(buf,'\n');
		      if (p!=NULL) *p='\0'; }
                    fprintf(stderr,"Unknown cmd # %d: '%s', ignored",i,buf);
                }
            } else {
                if (strlen(buf)>0 && buf[0]!='\n' && buf[0]!='\r') {
                    { char *p = strchr(buf,'\n'); if (p!=NULL) *p='\0'; }
                    fprintf(stderr,"Bad Line # %d: '%s', ignored",i,buf);
                }
            }
        }
    }
    fclose(fd);
}

static void
bulkdump(int tm) {
    struct tm_regop_t ro;
    int reg;
    int val;
    int i;

    for (i=0;i<0x100;i++) {
        ro.idx = (unsigned short) i;
        ioctl(tm,TM_GETBYTEREG,&ro);
        if (i%16==0) {
	    printf("\n%03x:",i);
	}
        printf(" %02x",(unsigned char)ro.dat);
    }
}
