(* Copyright (C) 1994, Digital Equipment Corporation *)
(* All rights reserved.                              *)
(* See the file COPYRIGHT for a full description.    *)

(* This interface exports the configuration information
   used by m3build and quake.  These constants were defined
   when Modula-3 was installed. *)

INTERFACE M3Config;

CONST  (* misc. configuration *)
  TARGET    = "FreeBSD2";
  OS_TYPE   = "POSIX";
  WORD_SIZE = "32BITS";
  BUILD_DIR = "FreeBSD2";
  PATH_SEP  = "/";
  M3        = "/usr/contrib/lib/m3/FreeBSD2/m3"; (* the compiler *)

CONST (* installation directories *)
  BIN_INSTALL   = "/usr/contrib/bin";
  LIB_INSTALL   = "/usr/contrib/lib/m3/FreeBSD2";
  DOC_INSTALL   = "/usr/contrib/lib/m3/doc";
  PKG_INSTALL   = "/usr/contrib/lib/m3/pkg";
  MAN_INSTALL   = "/usr/contrib/man";
  EMACS_INSTALL = "/usr/contrib/lib/elisp";
  HTML_INSTALL  = "/usr/contrib/lib/m3/www";

(* On some systems (e.g. AFS) you must install public files
   in a different place from where you use them.  The paths
   below specify where to find the installed files. *)

CONST
  BIN_USE   = "/usr/contrib/bin";
  LIB_USE   = "/usr/contrib/lib/m3/FreeBSD2";
  DOC_USE   = "/usr/contrib/lib/m3/doc";
  PKG_USE   = "/usr/contrib/lib/m3/pkg";
  MAN_USE   = "/usr/contrib/man";
  EMACS_USE = "/usr/contrib/lib/elisp";
  HTML_USE  = "/usr/contrib/lib/m3/www";

END M3Config.
