/*
 *	NETMAJ - network mahjongg -
 *	Copyright (C) 1994, 1995 Koji Suzuki (suz@d2.bs1.fc.nec.co.jp)
 *
 *	NETMAJ is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	NETMAJ is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *	See the GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: analize.c,v 1.4 1995/05/13 03:15:58 suz Exp $ */
#include "pai.h"
#include "ahand.h"
#include "global.h"

#define DEBUG

extern FILE *df;

int param_kyushu=100;
int param_random=50;
int param_dora=100;
int param_color=300;
int param_zone=300;
int param_suji=100;
int param_same=300;
int param_deep=500;
int param_reach = 700;
int param_kan = 0;
int param_pon = 50;
int param_tie = 200;
int param_yomi = 500;

analize_init(gp) {
	pf_param(gp,"random",&param_random);
	pf_param(gp,"dora",&param_dora);
	pf_param(gp,"color",&param_color);
	pf_param(gp,"zone",&param_zone);
	pf_param(gp,"suji",&param_suji);
	pf_param(gp,"same",&param_same);
	pf_param(gp,"deep",&param_deep);
	pf_param(gp,"reach",&param_reach);
	pf_param(gp,"pon",&param_pon);
	pf_param(gp,"kan",&param_kan);
	pf_param(gp,"tie",&param_tie);
	pf_param(gp,"kyushu",&param_kyushu);
	pf_param(gp,"yomi",&param_yomi);
}

typedef struct {
	int pai_num;
	pai_t pai[14];
	int   pnt[14];
} pnt_t;

pnt_t result_pnt;

analize(gp,p) global_t *gp; {
	int r[14];
	int i,n;
	int low,low_i = 0;
	ahand_t a;
	result_t y;

	if (result_check_kyushukyupai(gp)==1
	   && ((random()%1000) > param_kyushu) ) {
		ask_attr = T_HN_TSM;
		ask_pai = P_NULL;
		return;
	}
	low = 10000;
	n = hand[p].closed_num;

	analize_base(gp,p,1000,r);
	filter_random(gp,p,param_random,r);
	filter_dora(gp,p,param_dora,r);
	filter_color(gp,p,param_color,r);
	filter_zone(gp,p,param_zone,r);
	filter_suji(gp,p,param_suji,r);
	filter_same(gp,p,param_same,r);
	filter_yomi(gp,p,param_yomi,r);
if (df) fprintf(df,"last:");
	for (i=0; i<n; i++) {
if (df) fprintf(df,"%4d ",r[i]);
		if (r[i] < low) {
			low = r[i];
			low_i = i;
		}
	}
if (df) fprintf(df,"\n");
	ask_attr = T_RV;
	ask_pai = hand[p].closed[low_i];
	if ( (result_rest == 0) &&
	    (!hand[p].naki || result_calc_yaku(gp,vself,&y) > 0) ) {
			ask_attr = T_HN_TSM;
			ask_pai = P_NULL;
			return;
	}
	if (hand[p].reach) {
		return;
	}
	if (result_rest < 3) {
		analize_deep(gp,p,param_deep,r);
	}

	/* analize for REACH */
	if (ask_attr == T_RV) {
		for (i=0; i<n; i++) {
			if (hand[p].closed[i] == ask_pai)
			break;
		}
		ah_new(&a,&hand[p],i);
		ah_analize(&a,0);
		if (result_rest == 1
		   && ((random()%1000)*70 <= param_reach*(mt_rest(gp))))
			ask_attr = T_RV_RCH;
	}
	if (hand_can_kan(gp,vself,ask_pai)) {
		ask_attr = T_HN_KAN;
	}
}

analize_base(gp,p,max,rp) global_t *gp; int *rp; {
	ahand_t a;
	int r[14];
	int r_max;
	int i,j,x,n;

	ah_new(&a,&hand[p],-1);
	ah_analize(&a,0);
	pnt_calc(gp);

	r_max = 0;

	n = hand[p].closed_num;
	for (i=j=0; i<n; i++) {
		for (j=0; j<result_pnt.pai_num; j++) {
			if (P_KIND(hand[p].closed[i])
			     == result_pnt.pai[j])
				break;
		}
		r[i] = result_pnt.pnt[j];
		if (r_max < r[i]) r_max = r[i];
	}
if (df) fprintf(df,"devide result:%d\n",result_rest);
#ifdef DEBUG
for (i=0; i<result_cnt; i++)
	ah_print(result_ahand + i,"     ");
#endif
if (df) fprintf(df,"hand:");
for (i=0; i<n; i++) if (df) fprintf(df," %s ",pai2str(hand[p].closed[i]));
if (df) fprintf(df,"\n");
if (df) fprintf(df,"base:");
	for (i=0; i<n; i++) {
		if (r_max)
			x = (int)((double)r[i] * max / r_max);
		else
			x = 0;
		*rp++ = x;
if (df) fprintf(df,"%4d ",x);
	}
if (df) fprintf(df,"\n");
	return;
}

filter_random(gp,p,max,rp) global_t *gp; int *rp; {
	int i,x;
#if 0
if (df) fprintf(df,"\npai :");
for (i=0; i<n; i++) if (df) fprintf(df," %s ",pai2str(hand[p].closed[i]));
#endif
if (df) fprintf(df,"rand:");
	for (i=0; i<hand[p].closed_num; i++) {
		x = random() % max;
		*rp++ += x;
if (df) fprintf(df,"%4d ",x);
	}
if (df) fprintf(df,"\n");
}

filter_dora(gp,p,max,rp) global_t *gp; int *rp; {
	int i,j,x,n;
	int r[14];
	int pai,paik,dora;
	int r_max = 0;


	n = hand[p].closed_num; 
	for (i=0; i<n; i++) {
		r[i] = 0;
		pai = hand[p].closed[i];

		if (pai == (K_MAN_5 << 2)) r[i] += 8;
		else if (pai == (K_PIN_5 << 2)) r[i] += 8;
		else if (pai == (K_SOU_5 << 2)) r[i] += 8;

		paik = P_KIND(pai);

		for (j=0; j<5; j++)  {
			dora = K_NEXT(P_KIND(mt_dora(gp,j)));
			if (dora == paik) r[i] += 8;
			if (K_NEXT2(dora) == paik) r[i] += 4;
			if (K_PREV2(dora) == paik) r[i] += 4;
			if (K_NEXT2(K_NEXT2(dora)) == paik) r[i] += 2;
			if (K_PREV2(K_PREV2(dora)) == paik) r[i] += 2;
		}

		r[i] = r[i] * rp[i];
		if (r_max < r[i]) r_max = r[i];
	}

if (df) fprintf(df,"dora:");
	for (i=0; i<hand[p].closed_num; i++) {
		if (r_max)
			x = (int)((double)r[i] * max / r_max);
		else
			x = 0;

		*rp++ += x;
if (df) fprintf(df,"%4d ",x);
	}
if (df) fprintf(df,"\n");
}

filter_color(gp,p,max,rp) global_t *gp; int *rp; {
	int i,j,x,n;
	int r[14];
	int man,pin,sou,ji;
	int paik;
	int r_max;
	int b = max/200;
	int d = max/100;

	r_max = max;
	man = b;
	pin = b;
	sou = b;
	ji  = 0;

	n = hand[p].closed_num; 
	for (i=0; i<n; i++) {
		r[i] = 0;
		paik = P_KIND(hand[p].closed[i]);

		if (IS_MAN(paik)) 	man += d;
		else if (IS_PIN(paik)) 	pin += d;
		else if (IS_SOU(paik)) 	sou += d;
		else 			ji += d;

	}

	for (i=0; i<4; i++) if (hand[p].opened_kind[i]) {
		paik = P_KIND(hand[p].opened[i][0]);

		if (IS_MAN(paik)) 	pin = sou = b; 
		else if (IS_PIN(paik)) 	sou = man = b;
		else if (IS_SOU(paik)) 	man = pin = b;
	}

	if (man > pin && man > sou) {
		man += ji/2;
		ji += man/2;
	}
	else if (pin > sou && pin > man) {
		pin += ji/2;
		ji += pin/2;
	}
	else if (sou > man && sou > pin) {
		sou += ji/2;
		ji += sou/2;
	}

	man = man * man * (hand[p].naki?2:1);
	pin = pin * pin * (hand[p].naki?2:1);
	sou = sou * sou * (hand[p].naki?2:1);
	ji = ji * ji * (hand[p].naki?2:1);

	for (i=0; i<n; i++) {
		paik = P_KIND(hand[p].closed[i]);

		if (IS_MAN(paik))  	r[i] = man/3;
		else if (IS_PIN(paik)) 	r[i] = pin/3;
		else if (IS_SOU(paik)) 	r[i] = sou/3;
		else 			r[i] = ji/3;

		if (r[i] > r_max) r_max = r[i];
	}
if (df) fprintf(df,"col :");
	for (i=0; i<hand[p].closed_num; i++) {
		if (r_max)
			x = (int)((double)r[i] * max / r_max);
		else
			x = 0;

		*rp++ += x;
if (df) fprintf(df,"%4d ",x);
	}
if (df) fprintf(df,"\n");
	return (man + pin + sou);
}


filter_zone(gp,p,max,rp) global_t *gp; int *rp; {
	int i,j,x,n;
	int r[14];
	int paik;
	int r_max;
	int zone[7];
	int b = max/200;
	int d = max/100;

	r_max = max;
	for (i=0; i<7; i++) zone[i] = b;

	n = hand[p].closed_num; 
	for (i=0; i<n; i++) {
		paik = P_KIND(hand[p].closed[i]);

		if (IS_PIN(paik)) 	paik += K_MAN_1 - K_PIN_1;
		else if (IS_SOU(paik)) 	paik += K_MAN_1 - K_SOU_1;

		if (paik == K_MAN_1 || paik == K_MAN_2 || paik == K_MAN_3)
			zone[0] += d;
		if (paik == K_MAN_2 || paik == K_MAN_3 || paik == K_MAN_4)
			zone[1] += d;
		if (paik == K_MAN_3 || paik == K_MAN_4 || paik == K_MAN_5)
			zone[2] += d;
		if (paik == K_MAN_4 || paik == K_MAN_5 || paik == K_MAN_6)
			zone[3] += d;
		if (paik == K_MAN_5 || paik == K_MAN_6 || paik == K_MAN_7)
			zone[4] += d;
		if (paik == K_MAN_6 || paik == K_MAN_7 || paik == K_MAN_8)
			zone[5] += d;
		if (paik == K_MAN_7 || paik == K_MAN_8 || paik == K_MAN_9)
			zone[6] += d;
	}
	for (i=0; i<7; i++) {
		zone[i] = zone[i] * zone[i] / 3;
	}

	for (i=0; i<n; i++) {
		r[i] = 0;
		paik = P_KIND(hand[p].closed[i]);

		if (IS_PIN(paik)) 	paik += K_MAN_1 - K_PIN_1;
		else if (IS_SOU(paik)) 	paik += K_MAN_1 - K_SOU_1;

		switch(paik) {
		case K_MAN_1:
			r[i] = (zone[0]);
			break;
		case K_MAN_2:
			r[i] = (zone[0] + zone[1]);
			break;
		case K_MAN_3:
			r[i] = (zone[0] + zone[1] + zone[2]);
			break;
		case K_MAN_4:
			r[i] = (zone[1] + zone[2] + zone[3]);
			break;
		case K_MAN_5:
			r[i] = (zone[2] + zone[3] + zone[4]);
			break;
		case K_MAN_6:
			r[i] = (zone[3] + zone[4] + zone[5]);
			break;
		case K_MAN_7:
			r[i] = (zone[4] + zone[5] + zone[6]);
			break;
		case K_MAN_8:
			r[i] = (zone[5] + zone[6]);
			break;
		case K_MAN_9:
			r[i] = (zone[6]);
			break;
		default:
			r[i] = (zone[0] + zone[6]);
		}
		if (r[i] > r_max) r_max = r[i];
	}

if (df) fprintf(df,"zone:");
	for (i=0; i<hand[p].closed_num; i++) {
		if (r_max)
			x = (int)((double)r[i] * max / r_max);
		else
			x = 0;

		*rp++ += x;
if (df) fprintf(df,"%4d ",x);
	}
if (df) fprintf(df,"\n");
}

filter_suji(gp,p,max,rp) global_t *gp; int *rp; {
	int i,j,x,n;
	int r[14];
	int paik;
	int r_max;
	int suji[6];
	int b = max/200;
	int d = max/100;

	r_max = max;
	for (i=0; i<6; i++) suji[i] = b;

	n = hand[p].closed_num; 
	for (i=0; i<n; i++) {
		paik = P_KIND(hand[p].closed[i]);

		if (IS_PIN(paik)) 	paik += K_MAN_1 - K_PIN_1;
		else if (IS_SOU(paik)) 	paik += K_MAN_1 - K_SOU_1;

		if (paik == K_MAN_1 || paik == K_MAN_4)
			suji[0] += d;
		if (paik == K_MAN_2 || paik == K_MAN_5)
			suji[1] += d;
		if (paik == K_MAN_3 || paik == K_MAN_6)
			suji[2] += d;
		if (paik == K_MAN_4 || paik == K_MAN_7)
			suji[3] += d;
		if (paik == K_MAN_5 || paik == K_MAN_8)
			suji[4] += d;
		if (paik == K_MAN_6 || paik == K_MAN_9)
			suji[5] += d;
	}
	for (i=0; i<6; i++) {
		suji[i] *= suji[i];
	}

	for (i=0; i<n; i++) {
		r[i] = 0;
		paik = P_KIND(hand[p].closed[i]);

		if (IS_PIN(paik)) 	paik += K_MAN_1 - K_PIN_1;
		else if (IS_SOU(paik)) 	paik += K_MAN_1 - K_SOU_1;

		switch(paik) {
		case K_MAN_1:
			r[i] = (suji[0]);
			break;
		case K_MAN_2:
			r[i] = (suji[1]);
			break;
		case K_MAN_3:
			r[i] = (suji[2]);
			break;
		case K_MAN_4:
			r[i] = (suji[3] + suji[0]);
			break;
		case K_MAN_5:
			r[i] = (suji[4] + suji[1]);
			break;
		case K_MAN_6:
			r[i] = (suji[5] + suji[2]);
			break;
		case K_MAN_7:
			r[i] = (          suji[3]);
			break;
		case K_MAN_8:
			r[i] = (          suji[4]);
			break;
		case K_MAN_9:
			r[i] = (          suji[5]);
			break;
		default:
			r[i] = max/10;
		}
		if (r[i] > r_max) r_max = r[i];
	}

if (df) fprintf(df,"suji:");
	for (i=0; i<hand[p].closed_num; i++) {
		if (r_max)
			x = (int)((double)r[i] * max / r_max);
		else
			x = 0;

		*rp++ += x;
if (df) fprintf(df,"%4d ",x);
	}
if (df) fprintf(df,"\n");
}

filter_same(gp,p,max,rp) global_t *gp; int *rp; {
	int i,j,x,n,k;
	int r[14];
	int paik;
	int r_max;
	int same[K_MAX];
	int samek=0;
	int b = 0;
	int d = 1;

	r_max = max;
	for (i=0; i<K_MAX; i++) same[i] = b;

	n = hand[p].closed_num; 
	for (i=0; i<n; i++) {
		paik = P_KIND(hand[p].closed[i]);
		same[paik] += d;
	}
	for (i=0; i<4; i++) {
		if (k=hand[p].opened_kind[i]) 
		switch(k) {
		case H_PON:
			same[P_KIND(hand[p].opened[i][0])] += 3 * d;
			break;
		case H_KAN_OPENED:
		case H_KAN_CLOSED:
			same[P_KIND(hand[p].opened[i][0])] += 4 * d;
			break;
		}
	}

	for (i=0; i<K_MAX; i++) {
		same[i] *= same[i];
		samek += same[i];
	}
	if (hand[p].naki) {
		samek *= 2;
	}

	for (i=0; i<n; i++) {
		r[i] = 0;
		paik = P_KIND(hand[p].closed[i]);
		r[i] = same[paik] * samek;
		if (r[i] > r_max) r_max = r[i];
	}

if (df) fprintf(df,"same:");
	for (i=0; i<hand[p].closed_num; i++) {
		if (r_max)
			x = (int)((double)r[i] * max / r_max);
		else
			x = 0;

		*rp++ += x;
if (df) fprintf(df,"%4d ",x);
	}
if (df) fprintf(df,"\n");
}

analize_deep(gp,p,max,rp) global_t *gp; int *rp; {
	int rest;
	int i,j,n;
	int max_r,max_id;
	ahand_t a;
	int sel[14];

	n = hand[p].closed_num;
	rest = result_rest;

	for (i=0; i< n; i++) {
		sel[i] = 0;
		ah_new(&a,&hand[p],i);
		ah_analize(&a,0);
		if  (rest < result_rest-1)
			continue;

		pnt_calc(gp);
		for (j=0; j< result_pnt.pai_num; j++) {
			sel[i] += result_pnt.pnt[j];
		}
		if (rest < result_rest) {
			sel[i] = sel[i] * 2 / (2 + result_rest - rest);
		}
	}
	max_r = 0;
	max_id = 0;
	for (i=0; i< n; i++) {
		if (max_r < sel[i]) {
			max_r = sel[i];
			max_id = i;
		}
	}

if (df) fprintf(df,"deep:");
	for (i=0; i < n; i++) {
		if (max_r == 0) sel[i] = 0;
		else
			sel[i] = (int)((double)sel[i] * max / max_r);
if (df) fprintf(df,"%4d ",sel[i]);
	}
if (df) fprintf(df,"\n");

	max_r = -100000;
	max_id = 0;
	for (i=0; i< n; i++) {
		if (max_r < sel[i] - rp[i]) {
			max_r = sel[i] - rp[i];
			max_id = i;
		}
	}
	ask_attr = T_RV;
	ask_pai = hand[p].closed[max_id];
}

pnt_calc(gp) global_t *gp; {
	int x,i,j;
	pnt_t p;
	ahand_t *a;
	int pai_rest;
	int v2_num;

	for (i=0; i<14; i++) {
		result_pnt.pnt[i] = 0;
		result_pnt.pai[i] = 0;
	}
	for (x=0; x<result_cnt; x++) {
		a = result_ahand + x;
		p.pai_num = 0;
		v2_num = 0;
		for (i=0; i<a->part_num; i++) {
			if (a->part_kind[i] == AH_V2)
				v2_num++;
		}
		for (i=0; i<a->part_num; i++) {
			switch(a->part_kind[i]) {
			case AH_H3:
				for (j=0; j<3; j++) {
					p.pai[p.pai_num] = a->part[i][j];
					p.pnt[p.pai_num++] = 400;
				}
				break;
			case AH_V3:
				for (j=0; j<3; j++) {
					p.pai[p.pai_num] = a->part[i][j];
					p.pnt[p.pai_num++] = 400;
				}
				break;
			case AH_V2:
				pai_rest=mt_rest_kind(gp,a->part[i][0]);
				for (j=0; j<2; j++) {
					p.pai[p.pai_num] = a->part[i][j];
					p.pnt[p.pai_num++] =
						(v2_num==1?100:150)
						+ 30*pai_rest;
				}
				break;
			case AH_H2a:
				pai_rest=mt_rest_kind(gp,K_PREV2(a->part[i][0]));
				pai_rest+=mt_rest_kind(gp,K_NEXT2(a->part[i][1]));
				for (j=0; j<2; j++) {
					p.pai[p.pai_num] = a->part[i][j];
					p.pnt[p.pai_num++] = 100 + 15*pai_rest;
				}
				break;
			case AH_H2b:
				pai_rest=mt_rest_kind(gp,K_PREV2(a->part[i][0]));
				pai_rest+=mt_rest_kind(gp,K_NEXT2(a->part[i][1]));
				for (j=0; j<2; j++) {
					p.pai[p.pai_num] = a->part[i][j];
					p.pnt[p.pai_num++] = 100 + 15*pai_rest;
				}
				break;
			case AH_H2c:
				pai_rest=mt_rest_kind(gp,K_NEXT2(a->part[i][0]));
				for (j=0; j<2; j++) {
					p.pai[p.pai_num] = a->part[i][j];
					p.pnt[p.pai_num++] = 100 + 20*pai_rest;
				}
				break;
			}
		}
		for (i=0; i<a->rest_num; i++) {
			pai_rest=mt_rest_kind(gp,a->rest[i]);
			if (a->rest[i] < K_TON) {
				pai_rest+=mt_rest_kind(gp,K_NEXT2(a->rest[i]));
				pai_rest+=mt_rest_kind(gp,K_PREV(a->rest[i]));
				p.pai[p.pai_num] = a->rest[i];
				p.pnt[p.pai_num++] = 15*pai_rest;
			} else {
				p.pai[p.pai_num] = a->rest[i];
				p.pnt[p.pai_num++] = 50*pai_rest;
			}
		}
		pnt_sort(&p);
		if (x == 0) 
			bcopy(&p,&result_pnt,sizeof(pnt_t));
		else
			for (i=0; i<p.pai_num; i++)
				result_pnt.pnt[i] += p.pnt[i];
	}
	for (i=0; i<result_pnt.pai_num; i++)
		result_pnt.pnt[i] /= result_cnt;
}

pnt_sort(p) pnt_t *p; {
	int i,j;
	int t;
	for (i=0; i<p->pai_num; i++) for (j=i; j<p->pai_num; j++) {
		if (p->pai[i] > p->pai[j] || 
		    p->pai[i] == p->pai[j] && p->pnt[i] > p->pnt[j]) {
			
			t = p->pai[i]; p->pai[i] = p->pai[j]; p->pai[j] = t;
			t = p->pnt[i]; p->pnt[i] = p->pnt[j]; p->pnt[j] = t;
		}
	}
}


analize_res(gp,howp) global_t *gp; int *howp; {
	result_t y;
	int ret = R_ACK;
	*howp = 0;

	hand_insert(gp,vself,rvp->out);
	if (result_calc_yaku(gp,vself,&y) > 0) {
		ret = R_RON;
	}
	hand_delete(gp,vself,rvp->out,0);

	if (ret == R_ACK && hand_can_kan(gp,vself,rvp->out)==2) {
		ret = analize_kan(gp);
	}
	if (ret == R_ACK && hand_can_pon(gp,vself,rvp->out)) {
		ret = analize_pon(gp);
	}
	if (ret == R_ACK && (cur_player+1)%4==vself &&
		hand_can_tiex(gp,vself,rvp->out)) {
		ret = analize_tie(gp,howp);
	}

	return ret;
}



analize_kan(gp) global_t *gp; {
	int pk;
	int go;
	hand_t save;
	ahand_t a;
	int rest;

	go = param_kan;
	pk = P_KIND(rvp->out);
	if (hand[vself].naki) {
		go = 200;
	}
	else {
		if (pk == K_HAKU || pk == K_HATU || pk == K_CHUN)
			go *= 1.5;
		if ((pk == K_TON + vself) || pk == K_TON + big_turn)
			go *= 1.5;
	}
	if (random()%1000 > go) {
		return R_ACK;
	}

	save = hand[vself];
	ah_new(&a,&hand[vself],-1);
	ah_analize(&a,0);
	rest = result_rest;
	hand_kan(gp,vself,rvp->out);
	ah_new(&a,&hand[vself],-1);
	ah_analize(&a,0);
	hand[vself] = save;

	return (result_rest <= rest)?R_KAN:R_ACK;
}


analize_pon(gp) global_t *gp; {
	int pk;
	int go;
	hand_t save;
	ahand_t a;
	int rest1,rest2;
	int point1,point2;

	go = param_pon;
	pk = P_KIND(rvp->out);
	if (hand[vself].naki)
		go = 1000;
	if (pk == K_HAKU || pk == K_HATU || pk == K_CHUN)
		go = go * 1.5;
	else if ((pk == K_TON + vself) || pk == K_TON + big_turn)
		go = go * 1.5;

	if (random()%1000 > go) {
		return R_ACK;
	}

	save = hand[vself];
	ah_new(&a,&hand[vself],-1);
	ah_analize(&a,0);
	rest1 = result_rest;
	point1 = analizex(gp,vself);

	hand_pon(gp,vself,rvp->out);
	analize(gp,vself);
	hand_delete(gp,vself,ask_pai,0);
	
	ah_new(&a,&hand[vself],-1);
	ah_analize(&a,0);
	rest2 = result_rest;
	point2 = analizex(gp,vself);

	hand[vself] = save;

	if (rest2 > rest1) {
		return ((double)point2 > point1 * 2.0)?R_PON:R_ACK;
	} else if (rest2 == rest1) {
		return ((double)point2 > point1 * 1.5)?R_PON:R_ACK;
	} else {
		return ((double)point2 > point1 * 1.2)?R_PON:R_ACK;
	}
}


analize_tie(gp,howp) global_t *gp; int *howp; {
	int pk,i;
	int go;
	hand_t save;
	ahand_t a;
	int how;
	int rest1,rest2;
	int point1,point2,tmp;

	go = param_tie;
	pk = P_KIND(rvp->out);
	if (hand[vself].naki) {
		go = 1000;
	}
	if (random()%1000 > go) {
		return R_ACK;
	}

	save = hand[vself];
	ah_new(&a,&hand[vself],-1);
	ah_analize(&a,0);
	rest1 = result_rest;
	point1 = analizex(gp,vself);

	point2 = 0;
	rest2 = result_rest;

	for (i=0; i<hand[vself].closed_num; i++) {
		how = hand[vself].closed[i];
		if (!hand_can_tie(gp,vself,rvp->out,how))
			continue;
		hand_tie(gp,vself,rvp->out,how);
		analize(gp,vself);
		hand_delete(gp,vself,ask_pai,0);

		ah_new(&a,&hand[vself],-1);
		ah_analize(&a,0);
		tmp = analizex(gp,vself);
		hand[vself] = save;
		if (result_rest > rest2 ||
		    (result_rest == rest2 && tmp > point2)) {
			rest2 = result_rest;
			point2 = tmp;
			*howp = how;
		}
	}
	if (hand[vself].naki) {
		if (rest2 == rest1) {
			if ((double)point2 > point1 * 1.2) return R_TIE;
		} else {
			if ((double)point2 > point1 * 0.8) return R_TIE;
		}
	} else {
		if (rest2 == rest1) {
			if ((double)point2 > point1 * 1.4) return R_TIE;
		} else {
			if ((double)point2 > point1 * 1.2) return R_TIE;
		}
	}
	return R_ACK;
}

analizex(gp,p) global_t *gp; {
	int total=0;

	total += point_random(gp,p,param_random);
	total += point_dora(gp,p,param_dora);
	total += point_color(gp,p,param_color);
	total += point_zone(gp,p,param_zone);
	total += point_suji(gp,p,param_suji);
	total += point_same(gp,p,param_same);
	total += point_deep(gp,p,param_deep);
	return total;
}

filter_yomi(gp,p,max,rp) global_t *gp; int *rp; {
	int i,j,x,n,m,paik;
	int r[14];
	int r_max;
	int yomi_pai[K_MAX];
	int yomi_pai2[K_MAX];
	int yomi_count=0;
	int reach_count=0;
	river_t *riverp;

	n = hand[p].closed_num; 
	for (i=0; i<K_MAX; i++) yomi_pai[i] = yomi_pai2[i] = 0;
	riverp = &(rv[0][0]);

	while (riverp && riverp->out) {
		if (riverp->attr == T_RV_RCH) {
			reach_count++;
			m = rv_find_player(gp,riverp);
			i = rv_find_cur(gp,riverp);
			while (i >= 0) {
				yomi_pai[P_KIND(rv[m][i].out)] = 8;
				yomi_count++;
				i--;
			}
		} else if (reach_count) {
			yomi_pai[P_KIND(riverp->out)] = 8;
			yomi_count++;
		}
		riverp = riverp->next;
	}

	for (i=0; i<3; i++) {
		for (j=0; j<4; j++) {
			if (yomi_pai[i*9+j+1] && yomi_pai[i*9+j+6]) {
				if (!yomi_pai[i*9+j+2] && !yomi_pai[i*9+j+5]) {
					yomi_pai2[i*9+j+2] = 8;
					yomi_pai2[i*9+j+5] = 8;
				}
				else if (!yomi_pai[i*9+j+2])
					yomi_pai2[i*9+j+2] = 1;
				else if (!yomi_pai[i*9+j+5])
					yomi_pai2[i*9+j+5] = 1;
			}
			else if (yomi_pai[i*9+j+1]) {
				if (!yomi_pai[i*9+j+2] && !yomi_pai[i*9+j+5]) {
					yomi_pai2[i*9+j+2] = 4;
					yomi_pai2[i*9+j+5] = 4;
				}
				else if (!yomi_pai[i*9+j+2])
					yomi_pai2[i*9+j+2] = 1;
				else if (!yomi_pai[i*9+j+5])
					yomi_pai2[i*9+j+5] = 1;
			}
			else if (yomi_pai[i*9+j+6]) {
				if (!yomi_pai[i*9+j+2] && !yomi_pai[i*9+j+5]) {
					yomi_pai2[i*9+j+2] = 4;
					yomi_pai2[i*9+j+5] = 4;
				}
				else if (!yomi_pai[i*9+j+2])
					yomi_pai2[i*9+j+2] = 1;
				else if (!yomi_pai[i*9+j+5])
					yomi_pai2[i*9+j+5] = 1;
			}
		}
	}

	r_max = max;
	for (i=0; i<n; i++) {
		paik = P_KIND(hand[p].closed[i]);
		r[i] = (8 - yomi_pai[paik] + yomi_pai2[paik]) 
			* yomi_count * 5;
		if (r_max < r[i]) r_max = r[i];
	}

if (df) fprintf(df,"yomi:");
	for (i=0; i<hand[p].closed_num; i++) {
		if (r_max)
			x = (int)((double)r[i] * max / r_max);
		else
			x = 0;

		*rp++ += x;
if (df) fprintf(df,"%4d ",x);
	}
if (df) fprintf(df,"\n");
}

point_random(gp,p,max) global_t *gp; {
	return random()%max;
}

point_dora(gp,p,max) global_t *gp; {
	int i,j,x,n;
	int pais[18];
	int pai,paik,dora;
	double r;

	r = 1.0;
	n = 0;
	for (i=0; i<hand[p].closed_num; i++) {
		pais[n++] = hand[p].closed[i];
	}
	for (i=0; i<4; i++) {
		for (j=0; j<4; j++) {
			if (x = hand[p].opened[i][j])
				pais[n++] = hand[p].opened[i][j];
		}
	}
	for (i=0; i<n; i++) {
		pai = pais[i];

		if (pai == (K_MAN_5 << 2)) r *= 2.0;
		else if (pai == (K_PIN_5 << 2)) r *= 2.0;
		else if (pai == (K_SOU_5 << 2)) r *= 2.0;

		paik = P_KIND(pai);

		for (j=0; j<5; j++)  {
			dora = K_NEXT(P_KIND(mt_dora(gp,j)));
			if (dora == paik) r *= 1.5;
		}

	}
	return (int)(max * r / 10);
}

point_color(gp,p,max) global_t *gp; {
	int i,j,x,n;
	int pais[14];
	int man,pin,sou,ji;
	int paik;

	man = 0;
	pin = 0;
	sou = 0;
	ji  = 0;

	n = 0;
	for (i=0; i<hand[p].closed_num; i++) {
		pais[n++] = hand[p].closed[i];
	}
	for (i=0; i<4; i++) {
		for (j=0; j<3; j++) {
			if (x = hand[p].opened[i][j])
				pais[n++] = hand[p].opened[i][j];
		}
	}

	for (i=0; i<n; i++) {
		paik = P_KIND(pais[i]);

		if (IS_MAN(paik)) 	man += 1;
		else if (IS_PIN(paik)) 	pin += 1;
		else if (IS_SOU(paik)) 	sou += 1;
		else 			ji += 1;
	}

	if (man > pin && man > sou) {
		man += ji/2;
		ji += man/2;
	}
	else if (pin > sou && pin > man) {
		pin += ji/2;
		ji += pin/2;
	}
	else if (sou > man && sou > pin) {
		sou += ji/2;
		ji += sou/2;
	}
	return (man*man + pin*pin + sou*sou + ji*ji)*max/100;
}


point_zone(gp,p,max) global_t *gp; {
	int i,j,x,n;
	int pais[14];
	int paik;
	int zone[7];
	int total;

	for (i=0; i<7; i++) zone[i] = 0;

	n = 0;
	for (i=0; i<hand[p].closed_num; i++) {
		pais[n++] = hand[p].closed[i];
	}
	for (i=0; i<4; i++) {
		for (j=0; j<3; j++) {
			if (x = hand[p].opened[i][j])
				pais[n++] = hand[p].opened[i][j];
		}
	}
	for (i=0; i<n; i++) {
		paik = P_KIND(pais[i]);

		if (IS_PIN(paik)) 	paik += K_MAN_1 - K_PIN_1;
		else if (IS_SOU(paik)) 	paik += K_MAN_1 - K_SOU_1;

		if (paik == K_MAN_1 || paik == K_MAN_2 || paik == K_MAN_3)
			zone[0] += 1;
		if (paik == K_MAN_2 || paik == K_MAN_3 || paik == K_MAN_4)
			zone[1] += 1;
		if (paik == K_MAN_3 || paik == K_MAN_4 || paik == K_MAN_5)
			zone[2] += 1;
		if (paik == K_MAN_4 || paik == K_MAN_5 || paik == K_MAN_6)
			zone[3] += 1;
		if (paik == K_MAN_5 || paik == K_MAN_6 || paik == K_MAN_7)
			zone[4] += 1;
		if (paik == K_MAN_6 || paik == K_MAN_7 || paik == K_MAN_8)
			zone[5] += 1;
		if (paik == K_MAN_7 || paik == K_MAN_8 || paik == K_MAN_9)
			zone[6] += 1;
	}
	total = 0;
	for (i=0; i<7; i++) {
		total += zone[i] * zone[i];
	}
	return total * max / 50;
}

point_suji(gp,p,max) global_t *gp; {
	int i,j,x,n;
	int pais[14];
	int paik;
	int suji[6];
	int total;

	for (i=0; i<6; i++) suji[i] = 0;

	n = 0;
	for (i=0; i<hand[p].closed_num; i++) {
		pais[n++] = hand[p].closed[i];
	}
	for (i=0; i<4; i++) {
		for (j=0; j<3; j++) {
			if (x = hand[p].opened[i][j])
				pais[n++] = hand[p].opened[i][j];
		}
	}
	for (i=0; i<n; i++) {
		paik = P_KIND(pais[i]);

		if (IS_PIN(paik)) 	paik += K_MAN_1 - K_PIN_1;
		else if (IS_SOU(paik)) 	paik += K_MAN_1 - K_SOU_1;

		if (paik == K_MAN_1 || paik == K_MAN_4)
			suji[0] += 1;
		if (paik == K_MAN_2 || paik == K_MAN_5)
			suji[1] += 1;
		if (paik == K_MAN_3 || paik == K_MAN_6)
			suji[2] += 1;
		if (paik == K_MAN_4 || paik == K_MAN_7)
			suji[3] += 1;
		if (paik == K_MAN_5 || paik == K_MAN_8)
			suji[4] += 1;
		if (paik == K_MAN_6 || paik == K_MAN_9)
			suji[5] += 1;
	}
	total = 0;
	for (i=0; i<6; i++) {
		total += suji[i] * suji[i];
	}
	return total * max / 50;
}

point_same(gp,p,max) global_t *gp; {
	int i,j,x,n,k;
	int pais[14];
	int paik;
	int same[K_MAX];
	int total;

	for (i=0; i<K_MAX; i++) same[i] = 0;

	n = 0;
	for (i=0; i<hand[p].closed_num; i++) {
		pais[n++] = hand[p].closed[i];
	}
	for (i=0; i<4; i++) {
		for (j=0; j<3; j++) {
			if (x = hand[p].opened[i][j])
				pais[n++] = hand[p].opened[i][j];
		}
	}

	for (i=0; i<n; i++) {
		paik = P_KIND(pais[i]);
		same[paik] += 1;
	}

	total = 0;
	for (i=0; i<K_MAX; i++) {
		total += same[i] * same[i] * same[i];
	}
	return total * max / 50;
}

point_deep(gp,p,max) global_t *gp; {
	result_t y;
	ahand_t a;
	hand_t save;
	int i,j,pai,ret;
	int point=0;
	int point_cnt=0;
	int rest;

	ah_new(&a,&hand[p],-1);
	ah_analize(&a,0);
	if ((rest = result_rest) > 2) return 0;

	if (rest == 1) {
		for (j=1; j< K_MAX; j++) {
			pai = (j<<2) + 1;
			hand_insert(gp,p,pai);
			if ((ret = result_calc_yaku(gp,p,&y)) > 0) {
				point += ret;
				point_cnt++;
			}
			hand_delete(gp,p,pai,0);
		}
	}
#if 0 /* very slow !! */
	else if (rest == 2) {
	    save = hand[p];
	    for (i=1; i<K_MAX; i++) {
		pai = (i<<2) + 1;

		hand_insert(gp,p,pai);
		analize(gp,p);
		hand_delete(gp,p,ask_pai,0);

		for (j=1; j< K_MAX; j++) {
			pai = (j<<2) + 1;
			hand_insert(gp,p,pai);
			if ((ret = result_calc_yaku(gp,p,&y)) > 0) {
				point += ret;
				point_cnt++;
			}
			hand_delete(gp,p,pai,0);
		}
		hand[p] = save;
	    }
	}
#endif
	if (point_cnt == 0) return 0;
	return (int)((double)point * max / (8000 * point_cnt));
}
