/*
 *	NETMAJ - network mahjongg -
 *	Copyright (C) 1994, 1995 Koji Suzuki (suz@d2.bs1.fc.nec.co.jp)
 *
 *	NETMAJ is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	NETMAJ is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *	See the GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ident "$Id: auto.c,v 1.4 1995/05/13 03:16:00 suz Exp $"

#define USAGE "\
usage:\n\
    auto [-h host-name] [-p port-number] [-n player-name]\n"

#include "pai.h"
#include "global.h"

char *host="localhost";
char *name="auto";
FILE *df;

int port = PORT_NUMBER;

global_t *gp_auto;

char *msgGets();

void term() {
if (df) fprintf(df,"connection closed\n");
	fclose(stdin);
	if (plog) fclose(plog);
	if (df) fclose(df);
	pf_term(gp_auto);
	exit(0);
}

main(argc,argv) int argc; char *argv[];
{
	result_t y;
	char buf[MSG_MAX];
	SOCKET *ssp;
	int st,c;
	char *p;
	int res,how;
	global_t *gp;

	gp = gp_auto = global_alloc();
	signal(SIGTERM,term);
	signal(SIGINT,term);

	srandom(time(0));
	while ((c=getopt(argc,argv,"p:h:l:L:n:"))!=EOF) {
		switch(c) {
		case 'n':
			name = optarg;
			break;
		case 'p':
			port = atoi(optarg);
			break;
		case 'h':
			host = optarg;
			break;
		case 'l':
			df = fopen(optarg,"w");
			break;
		case 'L':
			plog = fopen(optarg,"w");
			break;
		default:
			fprintf(stderr,USAGE);
			exit(1);
		}
	}

	pf_init(gp,name,argv[0]);
	analize_init(gp);

	ssp = ConnectSock(host, port );
	if (!ssp) {
		sleep(5);
		ssp = ConnectSock(host, port );
	}
	if (!ssp) {
		exit(0);
	}
	player[0].sp = ssp;
	sprintf(buf,MSG_CONNECT,name,0);
	msgWrites(gp,buf,4);
	if (!msgGets(gp,buf,sizeof(buf)-1,4)
	   || sscanf(buf,MSG_CONNECT_DONE,&self)<1) {
		SockClose(ssp);
		exit(0);
	}
if (df) fprintf(df,"connectied %d\n",self);

	while (msgGets(gp,buf,sizeof(buf)-1,4)) {
		st = recv_message(gp,buf);
		switch(st) {
		case ACT_RES:
			res = analize_res(gp,&how);
			sprintf(buf,MSG_REPL,res,how);
			msgWrites(gp,buf,4);
			break;
		case ACT_SEL:
			analize(gp,vself);
			sprintf(buf,MSG_ASK,ask_attr,ask_pai);
			msgWrites(gp,buf,4);
			break;
		case ACT_PEND:
			pf_pend(gp);
			if (df) log_play(gp,df);
			break;
		case ACT_GEND:
			pf_gend(gp);
			break;
		case ACT_COMMENT:
			break;
		}
	}
	term();
}

int msgWrites(gp,buf,p) global_t *gp; char *buf; int p; {
	if (p == 4) p = 0;
	if (plog) fprintf(plog,"%d>%s",p,buf);
	return SockWrites(buf,player[p].sp);
}

char *msgGets(gp,buf,len,p) global_t *gp; char *buf; int len; int p; {
	char *ret;

	if (p == 4) p = 0;
	ret = SockGets(buf,len,player[p].sp);
	if (plog) fprintf(plog,"%d<%s",p,buf);
	return ret;
}

msgSelect(gp,time_out) global_t *gp; int time_out; {
	return SockSelect((10.0) * time_out, "r");
}

msgIsRead(gp,p) global_t *gp; {
	return SockIsRead(player[p].sp);
}
