/*
 *	NETMAJ - network mahjongg -
 *	Copyright (C) 1994, 1995 Koji Suzuki (suz@d2.bs1.fc.nec.co.jp)
 *
 *	NETMAJ is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	NETMAJ is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *	See the GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: client.c,v 1.12 1995/06/06 21:11:37 suz Exp $ */

#define USAGE "\
usage:\n\
    client [-h host-name] [-p port-number] [-n player-name] [-l logfile] \n"

#include <setjmp.h>
#include <signal.h>
#ifndef SIGCHLD
#define SIGCHLD SIGCLD
#endif

#include "pai.h"
#include "global.h"
#include "result.h"

#define index	strchr
extern char *index();

global_t *gp_client;
FILE *df;
FILE *log;
char *host;
int port = PORT_NUMBER;
int play_speed = 10;
int auto_stop = 1;
int auto_play = 0;
int auto_after_reach = 1;
void term();
char *msgGets();

int readable_socket;
int readable_key;
int rv_fixed=0;
pai_t *cur_hand;
int view_river_all;

jmp_buf reconnect;

char *program;

init(gp) global_t *gp; {

	pf_param(gp,"play-speed",&play_speed);
	pf_param(gp,"auto-stop",&auto_stop);
	global_init(gp);
	ui_init(gp,PROG_NETMAJ);
	signal(SIGTERM,term);
	signal(SIGINT,term);
	signal(SIGCHLD,SIG_IGN);
	fclose(stderr);
	ui_draw(gp,1);
}

void term() {
	ui_term();
	if (plog) fclose(plog);
	if (df) fclose(df);
	pf_term(gp_client);
	exit(0);
}

main(argc,argv) int argc; char *argv[];
{
	char buf[MSG_MAX];
	SOCKET *ssp;
	int c,st,which,i,j;
	char *name,*p;
	int flag;
	int res,how;
	global_t *gp;

	gp = gp_client = global_alloc();

	host = "localhost";
	name = getenv("LOGNAME");
	flag = 0;
	program = argv[0];

	while((c = getopt(argc,argv,"p:h:sd:L:n:l:"))!=EOF) {
		switch(c) {
		case 'p':
			port = atoi(optarg);
			break;
		case 'n':
			name = optarg;
			break;
		case 'h':
			host = optarg;
			break;
		case 's':
			flag = 1;
			break;
		case 'd':
			df = fopen(optarg,"w");
			break;
		case 'L':
			plog = fopen(optarg,"w");
			break;
		case 'l':
			log = fopen(optarg,"w");
			break;
		default:
			fprintf(stderr,USAGE);
			exit(1);
			break;
		}
	}

	pf_init(gp,name,argv[0]);
	analize_init(gp);

	srandom(time(0));
	init(gp);


	setjmp(reconnect);
retry:
	while (!(ssp = ConnectSock(host, port ))) {
		ui_message_connecting();
	}
	player[0].sp = ssp;
	ui_message_connect();

	sprintf(buf,MSG_CONNECT,name,flag|M_TALK);
	msgWrites(gp,buf,4);

	if (!msgGets(gp,buf,sizeof(buf)-1,4)
	   || sscanf(buf,MSG_CONNECT_DONE,&self)<1) {
		SockClose(ssp);
		ui_message_disconnect();
		goto retry;
		term();
	}

	for (;;) {
	    ui_event_wait(gp,-1);
	    if (readable_socket) {
		readable_socket = 0;
		if (!msgGets(gp,buf,sizeof(buf)-1,4)) {
			ui_message_disconnect();
			goto retry;
			term();
		}
		st = recv_message(gp,buf);
		switch(st) {
		case ACT_RES:
			ui_draw(gp,0);
			if (T_GET(rvp->attr) == T_RV_RCH)
				ui_message_reach(pplayer[cur_player]);
			if (auto_play) {
				res = analize_res(gp,&how);
				xsleep(play_speed);
			}
			else {
				res = ui_res(gp,&how);
			}
			sprintf(buf,MSG_REPL,res,how);
			msgWrites(gp,buf,4);
			break;
		case ACT_SEL:
			if (auto_play) {
				analize(gp,vself);
				xsleep(play_speed);
			}
			else {
				ui_choice(gp);
			}
			sprintf(buf,MSG_ASK,ask_attr,ask_pai);
			msgWrites(gp,buf,4);
			break;
		case ACT_RESULT:
			for (i=4; i>=0; i--)
			    if (result[i].flag) break;
			switch(result[i].flag) {
			case RESULT_AGARI_TUMO:
				ui_message_tumo(pplayer[result[i].who]);
				break;
			case RESULT_AGARI_RON:
				ui_message_ron(pplayer[result[i].who]);
				break;
			case RESULT_CYONBO:
			case RESULT_CYONBO_CONT:
				if (cur_player == result[i].who) {
				    ui_message_tumo(pplayer[result[i].who]);
				} else {
				    ui_message_ron(pplayer[result[i].who]);
				}
				break;
			}
			break;
		case ACT_PEND:
			if (auto_after_reach && auto_play>=2)
				auto_play -=2;

			pf_pend(gp);
			ui_draw(gp,1);
			ui_result(gp);
			if (auto_play)
				xsleep(play_speed*5);
			else
				ui_key();
			break;
		case ACT_CONNECT:
			ui_message_player(gp);
			ui_draw(gp,1);
			break;
		case ACT_GEND:
			pf_gend(gp);
			ui_draw(gp,1);
			ui_message_gend(gp);
			break;
		case ACT_PLAY:
			ui_draw(gp,1);
			ui_message_play(gp);
			break;
		case ACT_COMMENT:
			if ((0 <= comment_from) && (comment_from < 4)) {
				/* from player */
				msgConvertOut(comment_body);
				comment(comment_from,1,comment_body);
			} else {
				/* from server */
				popup(comment_body,-1);
			}
			break;
		case ACT_FIX:
			rv_fixed = 1;
			ui_draw(gp,0);
			rv_fixed = 0;
			break;
		case ACT_REACH:
			if (auto_after_reach)
				auto_play += 2;
			ui_draw(gp,0);
			break;
		default:
			ui_draw(gp,0);
			break;
		}
	    }
	    if (readable_key) {
		readable_key = 0;
		ui_menu(gp,ui_key());
	    }
	}
}

xsleep(time_out) {
	fd_set fds;
	struct timeval to,*top;
	int ret = 0;

	top = 0;
	FD_ZERO( &fds );
	if (time_out >= 0) {
		to.tv_sec = time_out/10;
		to.tv_usec = (time_out % 10)*100000;
		top = &to;
	}
	select( 1, &fds, (fd_set *)0, (fd_set *)0, top);
}

int msgWrites(gp,buf,p) global_t *gp; char *buf; int p; {
	if (p==4) p=0;

	if (plog) fprintf(plog,"%d>%s",p,buf);
	return SockWrites(buf,player[p].sp);
}

char *msgGets(gp,buf,len,p) global_t *gp; char *buf; int len; int p; {
	char *ret;

	if (p==4) p=0;
	ret = SockGets(buf,len,player[p].sp);
	if (plog) fprintf(plog,"%d<%s",p,buf);
	return ret;
}


msgConvertIn(buf) char *buf; {
	while (*buf) {
		if (*buf == ' ') *buf = '@';
		buf++;
	}
}

msgConvertOut(buf) char *buf; {
	while (*buf) {
		if (*buf == '@') *buf = '_';
		buf++;
	}
}

msgTalk(gp,buf) global_t *gp; char *buf; {
	char msg[256];
	msgConvertIn(buf);
	sprintf(msg,MSG_COMMENT,buf);
	msgWrites(gp,msg,4);
}

callback_fd(gp) global_t *gp; {
	int fd=0;
	if (player[0].sp) {
		if (SockIsRead(player[0].sp)) {
			readable_socket = 1;
			return -1;
		}
		fd = player[0].sp->sd;
	}
	return fd;
}


callback(gp) global_t *gp; {
	char buf[256];

	readable_socket = 0;

	if (!msgGets(gp,buf,sizeof(buf)-1,4)) {
		ui_message_disconnect();
		longjmp(reconnect,1);
		term();
	}
	if (recv_message(gp,buf) == ACT_COMMENT
	    && (0 <= comment_from) && (comment_from < 4)) {
			/* from player */
			msgConvertOut(comment_body);
			comment(comment_from,1,comment_body);
	}
}

execute_auto(com) char *com; {
	char buf[256];

	if (com[0] == 0) 
		sprintf(buf,"%s -h %s -p %d &","auto",host,port);
	else if (com[0] == '-') 
		sprintf(buf,"%s %s -h %s -p %d &","auto",com,host,port);
	else
		sprintf(buf,"%s -h %s -p %d &",com,host,port);
	system(buf);
}

do_disconnect(gp) global_t *gp; {
	SockWrites(MSG_KILL, player[0].sp);
}
