/*
 *	NETMAJ - network mahjongg -
 *	Copyright (C) 1994, 1995 Koji Suzuki (suz@d2.bs1.fc.nec.co.jp)
 *
 *	NETMAJ is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	NETMAJ is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *	See the GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ident "$Id: mt.c,v 1.5 1995/05/13 03:16:08 suz Exp $"

#include "pai.h"
#include "global.h"

/* common functions */

mt_dora(gp,n) global_t *gp; {
	return (n > mt_top_cnt)?0:mt[n+122];
}

mt_uradora(gp,n) global_t *gp; {
	return (n > mt_top_cnt)?0:mt[n+127];
}

mt_rest(gp) global_t *gp; {
	if (mt_next_cnt2 == 0) { /* server */
		return 122 - mt_top_cnt - mt_normal_cnt;
	} else { /* client */
		return 122 - mt_next_cnt2;
	}
}

/* client functions */

mt_new(gp) global_t *gp; {
	int i;

	for (i=0; i<136; i++) {
		mt[i] = P_NULL;
	}
	mt_top_cnt=0;
	mt_normal_cnt=0;
}

mt_next_new(gp) global_t *gp; {
	int i;

	mt_next_cnt = 0;
	mt_next_cnt2 = 13*4;
	for (i=0; i<256; i++)
		mt_next[i] = 0;
}

mt_setdora(gp,n,v) global_t *gp; {
	if (v)	{
		if (n > mt_top_cnt) mt_top_cnt = n;
		mt[n+122] = v;
	}
}

mt_seturadora(gp,n,v) global_t *gp; {
	if (v)	{
		if (n > mt_top_cnt) mt_top_cnt = n;
		mt[n+127] = v;
	}
}

/* server functions */

mt_get(gp) global_t *gp; {
	if(mt_normal_cnt + mt_top_cnt>=122) return 0;
	return mt[mt_normal_cnt++];
}

mt_gettop(gp) global_t *gp; {
	int n;

	n = mt_top_cnt;
	if(n>=4) return 0;
	mt_top_cnt++;
	return mt[n+132];
}

mt_make(gp) global_t *gp; {
	int i,j,k;
	int tmp;

	for (i=0; i<256; i++) mt_push(gp,i,0);

if (mt_next_cnt != 136) {
printf("error in mt_make\n");
fclose(stdin);
exit(1);
}
	for (i=0; i<136; i++) {
		mt[i] = mt_next[i+4]+3;
	}
	for (i=0; i<10000; i++) {
		j = random()%136;
		k = random()%136;
		tmp = mt[j];
		mt[j] = mt[k];
		mt[k] = tmp;
	}
	mt_top_cnt=0;
	mt_normal_cnt=0;
	mt_next_new(gp);
	mt_next_cnt2 = 0;
}

mt_haipai(gp,buf) global_t *gp; pai_t *buf; {
	int x;

	for (x=0; x<13; x++) {
		buf[x] = mt_get(gp);
	}
}

mt_push(gp,p,mode) global_t *gp; pai_t p; {
	if (mode) mt_next_cnt2++;
	if (K_MAN_1 <= P_KIND(p) && P_KIND(p) < K_MAX && !mt_next[p]) {
		mt_next[p] = ++mt_next_cnt;
		return mt_next_cnt;
	}
	return 0;
}

mt_rest_kind(gp,p) global_t *gp; pai_t p; {
	int i;
	int ret=4;

	for (i=0; i<4; i++) {
		if (mt_next[p*4+i]) ret--;
	}
	return ret;
}
