/*
 *	NETMAJ - network mahjongg -
 *	Copyright (C) 1994, 1995 Koji Suzuki (suz@d2.bs1.fc.nec.co.jp)
 *
 *	NETMAJ is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	NETMAJ is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *	See the GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: netmaj1.c,v 1.10 1995/06/06 21:11:38 suz Exp $ */
#include <signal.h>
#include "pai.h"
#include "global.h"

#define USAGE "\
usage:\n\
    netmaj1 [-l logfile] [-H|-Q]\n"

int readable_key;
int readable_socket;
int rv_fixed=0;
pai_t *cur_hand;
int view_river_all;

int auto_after_reach=1;
int auto_play=0;
int auto_stop=1;
int play_speed=1;
extern int tonpu;

FILE *log;
FILE *log_server;
FILE *plog = 0;
callback() {}
callback_fd() { return -2;}

char *msgGets();

void term() {
	ui_term();
	exit(0);
}

execute_auto(){}
do_disconnect(gp) global_t *gp; {
	term();
}
talk(gp,from,msg) global_t *gp; char *msg; {
}
msgTalk(gp,buf) global_t *gp; {
}


init(gp) global_t *gp; {
	pf_param(gp,"play-speed",&play_speed);
	ui_init(gp,PROG_NETMAJ1);
	signal(SIGTERM,term);
	signal(SIGINT,term);
	signal(SIGCHLD,SIG_IGN);
	fclose(stderr);
	ui_draw(gp,1);
}


user_prog(gp,buf) global_t *gp; char *buf;
{
	char msg[256];
	int st,c;
	int i,j;
	int res,how;

	st = recv_message(gp,buf);
	switch(st) {
	case ACT_RES:
		ui_draw(gp,0);
		if (T_GET(rvp->attr) == T_RV_RCH)
			ui_message_reach(pplayer[cur_player]);
		if (auto_play>=2) {
			res = analize_res(gp,&how);
			xsleep(play_speed);
		}
		else {
			res = ui_res(gp,&how);
		}
		sprintf(msg,MSG_REPL,res,how);
		msgWrites(gp,msg,4);
		break;
	case ACT_SEL:
		if (auto_play>=2) {
			analize(gp,vself);
			xsleep(play_speed);
		}
		else {
			ui_choice(gp);
		}
		sprintf(msg,MSG_ASK,ask_attr,ask_pai);
		msgWrites(gp,msg,4);
		break;
	case ACT_RESULT:
		for (i=4; i>=0; i--)
		    if (result[i].flag) break;
		switch(result[i].flag) {
		case RESULT_AGARI_TUMO:
			ui_message_tumo(pplayer[result[i].who]);
			break;
		case RESULT_AGARI_RON:
			ui_message_ron(pplayer[result[i].who]);
			break;
		case RESULT_CYONBO:
		case RESULT_CYONBO_CONT:
			if (cur_player == result[i].who) {
			    ui_message_tumo(pplayer[result[i].who]);
			} else {
			    ui_message_ron(pplayer[result[i].who]);
			}
			break;
		}
		break;
	case ACT_PEND:
		if (auto_after_reach && auto_play>=2)
			auto_play -=2;

		pf_pend(gp);
		ui_draw(gp,1);
		ui_result(gp);
		if (auto_play>=2)
			xsleep(play_speed*5);
		else
			ui_key();
		break;
	case ACT_CONNECT:
		ui_message_player(gp);
		ui_draw(gp,1);
		break;
	case ACT_GEND:
		pf_gend(gp);
		ui_draw(gp,1);
		ui_message_gend(gp);
		break;
	case ACT_PLAY:
		ui_draw(gp,1);
		ui_message_play(gp);
		break;
	case ACT_COMMENT:
		break;
	case ACT_FIX:
		rv_fixed = 1;
		ui_draw(gp,0);
		rv_fixed = 0;
		break;
	case ACT_REACH:
		if (auto_after_reach)
			auto_play += 2;
		ui_draw(gp,0);
		break;
	default:
		ui_draw(gp,0);
		break;
	}
}

auto_prog(gp,buf) global_t *gp; char *buf;
{
	char msg[256];
	int st,c;
	int res,how;

	st = recv_message(gp,buf);
	switch(st) {
	case ACT_RES:
		res = analize_res(gp,&how);
		sprintf(msg,MSG_REPL,res,how);
		msgWrites(gp,msg,4);
		break;
	case ACT_SEL:
		analize(gp,vself);
		sprintf(msg,MSG_ASK,ask_attr,ask_pai);
		msgWrites(gp,msg,4);
		break;
	case ACT_PLAY:
		pf_pend(gp);
		break;
	case ACT_PEND:
		pf_pend(gp);
		break;
	case ACT_GEND:
		pf_gend(gp);
		break;
	case ACT_COMMENT:
		break;
	}
}


global_t *globals[5];

FILE *df;

main(argc,argv) int argc; char *argv[]; {
	int i,c,j;
	int dmy;
	char *names[4];

	while((c = getopt(argc,argv,"d:l:HQ"))!=EOF) {
		switch(c) {
		case 'd':
			df = fopen(optarg,"w");
			break;
		case 'l':
			log = fopen(optarg,"w");
			break;
		case 'H':
			tonpu = 0;
			break;
		case 'Q': 
			tonpu = 1;
			break;
		default:
			fprintf(stderr,USAGE);
			exit(1);
			break;
		}
	}
	srandom(time(0));

	names[0] = getenv("LOGNAME");
	for (i=1; i<4; i++) {
		names[i] = "auto";
	}

	for (i=0; i<5; i++) {
		globals[i] = global_alloc();
	}
	for (i=0; i<4; i++) {
		globals[i]->_self = i;
		for (j=0; j<5; j++) {
			strcpy(globals[j]->_player[i].name,names[i]);
			globals[j]->_player[i].flags = 0;
		}
		analize_init(globals[i]);
		pf_init(globals[i],globals[i]->_player[i].name,argv[0]);
	}
	init(globals[0]);
	for (;;) {
		game(globals[4]);
	}
	term();
}

char msgs[4][256];

int msgWrites(gp,buf,p) global_t *gp; char *buf; int p; {
	int i,q = 0;

	if (p==4) {
		for (i = 0; i<4; i++)
			if (gp == globals[i])
				q = i;
		strcpy(msgs[q],buf);
	}
	else if (p == 0) {
		user_prog(globals[p],buf);
	}
	else {
		auto_prog(globals[p],buf);
	}
}

msgSelect(gp,time_out) global_t *gp; int time_out; {
	return 1;
}

msgIsRead(gp,p) global_t *gp; {
	return (msgs[p][0] != 0);
}

char *msgGets(gp,buf,len,p) global_t *gp; char *buf; int len; int p; {
	if (msgs[p][0]) {
		strcpy(buf,msgs[p]);
		msgs[p][0] = 0;
	}
	return buf;
}

xsleep(time_out) {
	fd_set fds;
	struct timeval to,*top;
	int ret = 0;

	top = 0;
	FD_ZERO( &fds );
	if (time_out >= 0) {
		to.tv_sec = time_out/10;
		to.tv_usec = (time_out % 10)*100000;
		top = &to;
	}
	select( 1, &fds, (fd_set *)0, (fd_set *)0, top);
}

