/*
 *	NETMAJ - network mahjongg -
 *	Copyright (C) 1994, 1995 Koji Suzuki (suz@d2.bs1.fc.nec.co.jp)
 *
 *	NETMAJ is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	NETMAJ is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *	See the GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* $Id: rv.c,v 1.2 1995/05/13 03:16:16 suz Exp $ */

#include "pai.h"
#include "global.h"

rv_new(gp) global_t *gp; {
	int i,j;

	rvp = 0;
	cur_player = 0;
	for (i=0; i<4; i++) {
		rv_cur[i] =0;
		for (j=0; j<RIVER_MAX; j++) {
			rv[i][j].next = 0;
			rv[i][j].prev = 0;
			rv[i][j].attr = 0;
			rv[i][j].in = P_NULL;
			rv[i][j].out = P_NULL;
		}
	}
}

rv_push(gp,to) global_t *gp; {
	if (rvp) {
		if (cur_player != to) 
			rvp->next = rv[to] + rv_cur[to];
		else 
			rvp->next = rv[to] + rv_cur[to] + 1;
		rvp->next->prev = rvp;
		rvp = rvp->next;
	  	rv_cur[cur_player]++;
	} else {
		rvp = rv[to] + rv_cur[to];
	}
	cur_player = to;
if (plog) fprintf(plog,"rv_push: rvp = rv[%d][%d]\n",to,rv_cur[to]);
}


rv_find_player(gp,p) global_t *gp; river_t *p; {
	return (p - &rv[0][0])/RIVER_MAX;
}

rv_find_cur(gp,p) global_t *gp; river_t *p; {
	return (p - &rv[0][0])%RIVER_MAX;
}

