/*
 *	NETMAJ - network mahjongg -
 *	Copyright (C) 1994, 1995 Koji Suzuki (suz@d2.bs1.fc.nec.co.jp)
 *
 *	NETMAJ is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	NETMAJ is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *	See the GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* $Id: server.c,v 1.9 1995/05/13 03:16:17 suz Exp $ */

#include <signal.h>
#ifndef SIGCHLD
#define SIGCHLD SIGCLD
#endif
#include "pai.h"
#include "global.h"

#define USAGE "\
usage:\n\
    server [-p port-number] [-l logfile] [-n game-limit] [-s seed] [-H|-Q]\n"

int server_id;
int port = PORT_NUMBER;
char *plogfile;
char *logfile;
int limit= -1;
void term();

FILE *df;
FILE *log_server;

global_t *gp_server;
char *msgGets();

extern int tonpu;

main(argc,argv)
int argc;
char *argv[];
{
	SOCKET *ssp,*csp;
	char buf[MSG_MAX];
	char name[MSG_MAX];
	int flags;
	int i,j,k,c,new;
	int seed = 0,s;
	global_t *gp;

	gp = gp_server = global_alloc();
	signal(SIGINT,term);
	signal(SIGTERM,term);
	signal(SIGCHLD,SIG_IGN);

	while ((c=getopt(argc,argv,"p:l:L:s:n:HQ"))!=EOF) {
		switch(c) {
		case 'p':
			port = atoi(optarg);
			break;
		case 'l':
			logfile = optarg;
			break;
		case 'L':
			plogfile = optarg;
			break;
		case 's':
			seed = atoi(optarg);
			break;
		case 'n':
			limit = atoi(optarg);
			break;
		case 'H':
			tonpu = 0;
			break;
		case 'Q': 
			tonpu = 1;
			break;
		default:
			fprintf(stderr,USAGE);
			exit(1);
		}
	}

	if (!(ssp = ServerSock( port ))) {
		fprintf(stderr,"cannot open server socket:%d\n",port);
		exit(1);
	}

	if (!fork(0)) {
		fclose(stdin);
		fclose(stdout);
		fclose(stderr);
		if (plogfile) plog = fopen(plogfile,"w");
	} else {
		exit(0);
	}

	while(1) {
		for (i=0; i<4; i++) 
			strcpy(player[i].name,"---------");
		i = 0;
		while (i<4) {
			SockSelect((double)(-1.0), "r" );
			if( SockIsRead( ssp ) > 0 ) {
				csp = AcceptSock( ssp );
				for (new=0; new<4; new++) {
					if (!player[new].sp) break;
				}
				player[new].sp = csp;
				if (!msgGets(gp,buf,sizeof(buf)-1,new)) {
					player[new].sp = 0;
					SockClose(csp);
					continue;
				}
		
				if(sscanf(buf,MSG_CONNECT,name,&flags)>=2) {
					player[new].flags = flags;
					strncpy(player[new].name,name,PNAME_MAX);
					player[new].name[PNAME_MAX-1] = 0;
					sprintf(buf,MSG_CONNECT_DONE,new);
					msgWrites(gp,buf,new);
					i++;
					sprintf(buf,MSG_CONNECT_PLAYER
						,player[0].name
						,player[1].name
						,player[2].name
						,player[3].name);
					for (j=0; j<4; j++) {
					    if (player[j].sp)
						msgWrites(gp,buf,j);
					}
				} else if (!strcmp(buf,MSG_KILL)) {
					term();
				}
			}
			for (j=0; j<4; j++) {
			   if (player[j].sp
				&& (SockIsRead(player[j].sp) > 0) ) {
				if (talk_pg(gp,j)) {
					SockClose(player[j].sp);
					player[j].sp = NULL;
					strcpy(player[j].name,"---------");
					i--;
					sprintf(buf,MSG_CONNECT_PLAYER
						,player[0].name
						,player[1].name
						,player[2].name
						,player[3].name);
					for (k=0; k<4; k++) {
					    if (player[k].sp)
						msgWrites(gp,buf,k);
					}
				}
			    }
			}
		}

		if (plog) {
			fclose(plog);
			plog = 0;
		}
		server_id++;
		if (fork()!=0) {
			if (logfile) {
				sprintf(buf,"%s.%03d",logfile,server_id);
				log_server = fopen(buf,"a");
			}
			if (plogfile) {
				sprintf(buf,"%s.%03d",plogfile,server_id);
				plog = fopen(buf,"w");
			}
			SockClose(ssp);
			s = seed;
			if (!s) s = time(0);
			srandom(s);
			if (log_server) fprintf(log_server,"seed: %d\n",s);
			game(gp);
			after_game(gp);
			term();
		} 
		if (plogfile)
			plog = fopen(plogfile,"a");
		for (i=0; i<4; i++) {
			SockClose(player[i].sp);
			player[i].sp = 0;
		}
		if (server_id == limit)
			term();
	}
}

talk_pg(gp,from) global_t *gp; {
	char buf[MSG_MAX];
	char msg[MSG_MAX];

	if (!msgGets(gp,buf,sizeof(buf)-1,from)) return -1;
	if (sscanf(buf,MSG_COMMENT,msg)>=1) 
		talk(gp,from,msg);
	return 0;
}

talk(gp,from,msg) global_t *gp; char *msg; {
	int i;
	char buf[MSG_MAX];

	sprintf(buf,MSG_COMMENT2 ,from ,msg);
	for (i=0; i<4; i++)
		if (i != from && player[i].sp && (player[i].flags & M_TALK))
			msgWrites(gp,buf,i);
}

void term() {
	int i;
	global_t *gp;

	gp = gp_server;

	for (i=0; i<4; i++) if (player[i].sp)
		SockClose(player[i].sp);
	if (plog) fclose(plog);
	fclose(stdout);
	exit(1);
}

/* comm wrapper */

int msgWrites(gp,buf,p) global_t *gp; char *buf; int p; {
	if (plog) fprintf(plog,"%d>%s",p,buf);
	return SockWrites(buf,player[p].sp);
}

char *msgGets(gp,buf,len,p) global_t *gp; char *buf; int len; int p; {
	char *ret;
	ret = SockGets(buf,len,player[p].sp);
	if (plog) fprintf(plog,"%d<%s",p,buf);
	return ret;
}

msgSelect(gp,time_out) global_t *gp; int time_out; {
	return SockSelect((10.0) * time_out, "r");
}

msgIsRead(gp,p) global_t *gp; {
	return SockIsRead(player[p].sp);
}
