/*
 *	NETMAJ - network mahjongg -
 *	Copyright (C) 1994, 1995 Koji Suzuki (suz@d2.bs1.fc.nec.co.jp)
 *
 *	NETMAJ is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	NETMAJ is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *	See the GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* $Id: server_kill.c,v 1.4 1995/05/13 03:16:18 suz Exp $ */

#include "pai.h"
#include "global.h"

int port = PORT_NUMBER;

#define USAGE "\
usage:\n\
    server_kill [-p port-number]\n"

main(argc,argv) char *argv[]; {
	SOCKET *ssp;
	int c;

	while ((c=getopt(argc,argv,"p:"))!=EOF) {
		switch(c) {
		case 'p':
			port = atoi(optarg);
			break;
		default:
			fprintf(stderr,USAGE);
			exit(1);
		}
	}

	ssp = ConnectSock( "localhost", port );
	if (ssp) {
		SockWrites(MSG_KILL, ssp);
		SockClose(ssp);
		sleep(1);
	}

	return 0;
}
