/*
 *	NETMAJ - network mahjongg -
 *	Copyright (C) 1994, 1995 Koji Suzuki (suz@d2.bs1.fc.nec.co.jp)
 *
 *	NETMAJ is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	NETMAJ is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *	See the GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* $Id: stand.c,v 1.7 1995/05/13 03:16:19 suz Exp $ */

#include <signal.h>
#include "pai.h"
#include "global.h"

char *msgGets();

talk(gp,from,msg) global_t *gp; char *msg; {
}

term() {
fprintf(stderr,"term\n");
exit(1);
}

auto_prog(gp,buf) global_t *gp; char *buf;
{
	char msg[256];
	int st,c;
	int res,how;

	st = recv_message(gp,buf);
	switch(st) {
	case ACT_RES:
		res = analize_res(gp,&how);
		sprintf(msg,MSG_REPL,res,how);
		msgWrites(gp,msg,4);
		break;
	case ACT_SEL:
		analize(gp,vself);
		sprintf(msg,MSG_ASK,ask_attr,ask_pai);
		msgWrites(gp,msg,4);
		break;
	case ACT_PLAY:
		pf_pend(gp);
		break;
	case ACT_PEND:
		pf_pend(gp);
		break;
	case ACT_GEND:
		pf_gend(gp);
		pf_term(gp);
		break;
	case ACT_COMMENT:
		break;
	}
}


global_t *globals[5];

FILE *df;
FILE *log_server;

main(argc,argv) int argc; char *argv[]; {
	int i,c,j;
	int dmy;
	char *names[4];

	log_server = stdout;
	srandom(time(0));
#if 0
	df = stderr;
#endif
	for (i=1; i<argc && i<=4; i++) {
		names[i-1] = argv[i];
	}
	for (; i<=4; i++) {
		names[i-1] = "auto";
	}

	for (i=0; i<5; i++) {
		globals[i] = global_alloc();
	}
	for (i=0; i<4; i++) {
		globals[i]->_self = i;
		for (j=0; j<5; j++) {
			strcpy(globals[j]->_player[i].name,names[i]);
			globals[j]->_player[i].flags = 0;
		}
		analize_init(globals[i]);
		pf_init(globals[i],globals[i]->_player[i].name,argv[0]);
	}
	game(globals[4]);
}

char msgs[4][256];

int msgWrites(gp,buf,p) global_t *gp; char *buf; int p; {
	int i,q = 0;
	if (p==4) {
		for (i = 0; i<4; i++)
			if (gp == globals[i])
				q = i;
		strcpy(msgs[q],buf);
	}
	else {
		auto_prog(globals[p],buf);
	}
}

msgSelect(gp,time_out) global_t *gp; int time_out; {
	return 1;
}

msgIsRead(gp,p) global_t *gp; {
	return (msgs[p][0] != 0);
}

char *msgGets(gp,buf,len,p) global_t *gp; char *buf; int len; int p; {
	if (msgs[p][0]) {
		strcpy(buf,msgs[p]);
		msgs[p][0] = 0;
	}
}
