#!/bin/csh
#############################################################################
##
#A  packit.csh                  GAP Tools                    Martin Schoenert
##
##  'packit.csh <version> <release> <patchlevel> <source-directory>'
##
##  'packit.csh' packs the sources in the <source-directory>  into  the  form
##  that is used on the 'ftp' server.  <version>, <release> and  <patchlevel>
##  are used to construct the names,  i.e., the entire distribution is in the
##  archive 'gap<version>r<release>p<patchlevel>.zoo', e.g., 'gap3r4p1.zoo'.
##
##  It will also create a distribution that,  at least for GAP 3R4P2,  fitted
##  excately on 7 3.5" floppies in 1.44 MByte DOS format.  For future version
##  this will probably need to be adapted.
##
set name = ${1}r${2}p${3}
ln -s ${4} gap${name}

#############################################################################
# make the complete distribution ############################################
zoo   ah  gap${name}.zoo  gap${name}/bin/gap.sh
zoo   ah  gap${name}.zoo  gap${name}/src/{Makefile,*.h,*.c}
zoo   ah  gap${name}.zoo  gap${name}/lib/*.g
zoo   ah  gap${name}.zoo  gap${name}/grp/*.grp
zoo   ah  gap${name}.zoo  gap${name}/doc/{*.tex,manual.{bbl,bib,idx,ind,toc}}
zoo   ah  gap${name}.zoo  gap${name}/etc/*
zoo   D   gap${name}.zoo  gap${name}/etc/ctweyl.dvi
zoo   ah  gap${name}.zoo  gap${name}/thr/*.grp
zoo   ah  gap${name}.zoo  gap${name}/two/*.grp
zoo   ah  gap${name}.zoo  gap${name}/tom/*.tom
zoo   ah  gap${name}.zoo  gap${name}/tbl/*.tbl
make -f gap${name}/pkg/Makefile GAP_PATH=gap${name} SRCDISTFILE=gap${name} src_dist
zoo   cA  gap${name}.zoo  << 'EOI'
!TEXT!
/END
'EOI'
zoo   PE  gap${name}.zoo
chmod 444 gap${name}.zoo
cp gap${name}/etc/README ./README
chmod 444                ./README
mkdir util
cp gap${name}/utl/patch2_1.zoo util/patch2_1.zoo
chmod 444                      util/patch2_1.zoo
cp gap${name}/utl/unzoo.c      util/unzoo.c
chmod 444                      util/unzoo.c
cp gap${name}/utl/zoo2_1.zoo   util/zoo2_1.zoo
chmod 444                      util/zoo2_1.zoo
chmod 555 util
ln util/unzoo.c ./unzoo.c


#############################################################################
# make the splitted distribution ############################################
mkdir split

# make the src distribution #################################################
zoo   ah  split/src${name}.zoo  gap${name}/bin/gap.sh
zoo   ah  split/src${name}.zoo  gap${name}/src/{Makefile,*.h,*.c}
zoo   cA  split/src${name}.zoo  << 'EOI'
!TEXT!
/END
'EOI'
zoo   PE  split/src${name}.zoo
chmod 444 split/src${name}.zoo

# make the lib distribution #################################################
zoo   ah  split/lib${name}.zoo  gap${name}/lib/*.g
zoo   cA  split/lib${name}.zoo  << 'EOI'
!TEXT!
/END
'EOI'
zoo   PE  split/lib${name}.zoo
chmod 444 split/lib${name}.zoo

# make the grp distribution #################################################
zoo   ah  split/grp${name}.zoo  gap${name}/grp/*.grp
zoo   cA  split/grp${name}.zoo  << 'EOI'
!TEXT!
/END
'EOI'
zoo   PE  split/grp${name}.zoo
chmod 444 split/grp${name}.zoo

# make the doc distribution #################################################
zoo   ah  split/doc${name}.zoo  gap${name}/doc/{*.tex,manual.{bbl,bib,idx,ind,toc}}
zoo   cA  split/doc${name}.zoo  << 'EOI'
!TEXT!
/END
'EOI'
zoo   PE  split/doc${name}.zoo
chmod 444 split/doc${name}.zoo

# make the dvi distribution #################################################
zoo   ah  split/dvi${name}.zoo  gap${name}/doc/manual.dvi gap${name}/etc/ctweyl.dvi
chmod 444 split/dvi${name}.zoo

# make the etc distribution #################################################
zoo   ah  split/etc${name}.zoo  gap${name}/etc/*
zoo   D   split/etc${name}.zoo  gap${name}/etc/ctweyl.dvi
zoo   cA  split/etc${name}.zoo  << 'EOI'
!TEXT!
/END
'EOI'
zoo   PE  split/etc${name}.zoo
chmod 444 split/etc${name}.zoo

# make the thr distribution #################################################
zoo   ah  split/thr${name}.zoo  gap${name}/thr/*.grp
zoo   cA  split/thr${name}.zoo  << 'EOI'
!TEXT!
/END
'EOI'
zoo   PE  split/thr${name}.zoo
chmod 444 split/thr${name}.zoo

# make the two distribution #################################################
zoo   ah  split/two${name}.zoo  gap${name}/two/*.grp
zoo   cA  split/two${name}.zoo  << 'EOI'
!TEXT!
/END
'EOI'
zoo   PE  split/two${name}.zoo
chmod 444 split/two${name}.zoo

# make the tom distribution #################################################
zoo   ah  split/tom${name}.zoo  gap${name}/tom/*.tom
zoo   cA  split/tom${name}.zoo  << 'EOI'
!TEXT!
/END
'EOI'
zoo   PE  split/tom${name}.zoo
chmod 444 split/tom${name}.zoo

# make the tbl distribution #################################################
zoo   ah  split/tbl${name}.zoo  gap${name}/tbl/*.tbl
zoo   cA  split/tbl${name}.zoo  << 'EOI'
!TEXT!
/END
'EOI'
zoo   PE  split/tbl${name}.zoo
chmod 444 split/tbl${name}.zoo

# make the pkg distribution #################################################
make -f gap${name}/pkg/Makefile GAP_PATH=gap${name} SRCDISTFILE=split/pkg${name} src_dist
zoo   cA  split/pkg${name}.zoo  << 'EOI'
!TEXT!
/END
'EOI'
zoo   PE  split/pkg${name}.zoo
chmod 444 split/pkg${name}.zoo

# that's it for the splitted distribution ###################################
chmod 555 split


#############################################################################
# make the binary distributions #############################################
mkdir bin

# make the IBM PC binary distribution #######################################
zoo   ah  bin/bin${name}-ibm-i386-dos.zoo  gap${name}/bin/{README.DOS,gap.bat,gapdjg.exe}
zoo   c   bin/bin${name}-ibm-i386-dos.zoo  << 'EOI'
!TEXT!
/END
!TEXT!
/END
/END
'EOI'
zoo   PE  bin/bin${name}-ibm-i386-dos.zoo
chmod 444 bin/bin${name}-ibm-i386-dos.zoo
cp gap${name}/bin/unzoo-ibm-i386-dos.exe bin/unzoo-ibm-i386-dos.exe
chmod 555 bin/unzoo-ibm-i386-dos.exe

# make the Atari binary distribution ########################################
# zoo ah bin/bin${name}-atari-m68k-tos.zoo gap${name}/bin/{README.TOS,gap.ttp}
# zoo c  bin/bin${name}-atari-m68k-tos.zoo << 'EOI'
# !TEXT!
# /END
# /END
# 'EOI'
# zoo PE bin/bin${name}-atari-m68k-tos.zoo
# chmod 444 bin/bin${name}-atari-m68k-tos.zoo
# cp gap${name}/bin/unzoo-atari-m68k-tos.ttp bin/unzoo-atari-m68k-tos.ttp
# chmod 555 bin/unzoo-atari-m68k-tos.ttp

# make the DEC AXP OSF binary distribution ##################################
# zoo   ah  bin/bin${name}-dec-alpha-osf1.zoo gap${name}/bin/gap-dec-alpha-osf1
# chmod 444 bin/bin${name}-dec-alpha-osf1.zoo
# cp gap${name}/bin/unzoo-dec-alpha-osf1 bin/unzoo-dec-alpha-osf1
# chmod 555 bin/unzoo-dec-alpha-osf1

# make the HP HPPA1.1 binary distribution ###################################
# zoo   ah  bin/bin${name}-hp-hppa1.1-hpux.zoo gap${name}/bin/gap-hp-hppa1.1-hpux
# chmod 444 bin/bin${name}-hp-hppa1.1-hpux.zoo
# cp gap${name}/bin/unzoo-hp-hppa1.1-hpux bin/unzoo-hp-hppa1.1-hpux
# chmod 555 bin/unzoo-hp-hppa1.1-hpux

# that's it for the binary distribution #####################################
chmod 555 bin


#############################################################################
# make the IBM PC disks distribution ########################################
mkdir disk1440

# first disk ################################################################
mkdir disk1440/1
sed 's/$/
/' < gap${name}/etc/README     > disk1440/1/README
chmod 444 disk1440/1/README
sed 's/$/
/' < gap${name}/bin/README.DOS > disk1440/1/README.DOS
chmod 444 disk1440/1/README.DOS
ln bin/unzoo-ibm-i386-dos.exe      disk1440/1/unzoo.exe
ln bin/bin${name}-ibm-i386-dos.zoo disk1440/1/bin${name}.zoo
ln split/lib${name}.zoo            disk1440/1/lib${name}.zoo
chmod 555 disk1440/1

# second disk ###############################################################
mkdir disk1440/2
ln split/doc${name}.zoo disk1440/2/doc${name}.zoo
ln split/src${name}.zoo disk1440/2/src${name}.zoo
chmod 555 disk1440/2

# third disk ################################################################
mkdir disk1440/3
ln split/etc${name}.zoo disk1440/3/etc${name}.zoo
ln split/grp${name}.zoo disk1440/3/grp${name}.zoo
ln split/thr${name}.zoo disk1440/3/thr${name}.zoo
ln split/two${name}.zoo disk1440/3/two${name}.zoo
chmod 555 disk1440/3

# fourth disk ###############################################################
mkdir disk1440/4
cp split/tbl${name}.zoo disk1440/4/tba${name}.zoo
chmod 644 disk1440/4/tba${name}.zoo
zoo   D   disk1440/4/tba${name}.zoo  gap${name}/tbl/ctomax* gap${name}/tbl/ctomis* gap${name}/tbl/ctomon*
zoo   PE  disk1440/4/tba${name}.zoo
chmod 444 disk1440/4/tba${name}.zoo
chmod 555 disk1440/4

# fifth disk ################################################################
mkdir disk1440/5
zoo   ah  disk1440/5/tbb${name}.zoo  gap${name}/tbl/ctomax* gap${name}/tbl/ctomis* gap${name}/tbl/ctomon*
zoo cA disk1440/5/tbb${name}.zoo  << 'EOI'
!TEXT!
/END
'EOI'
zoo   PE  disk1440/5/tbb${name}.zoo
chmod 444 disk1440/5/tbb${name}.zoo
ln split/tom${name}.zoo disk1440/5/tom${name}.zoo
ln util/unzoo.c disk1440/5/unzoo.c
cp split/pkg${name}.zoo disk1440/5/xgp${name}.zoo
chmod 644 disk1440/5/xgp${name}.zoo
zoo   D   disk1440/5/xgp${name}.zoo  gap${name}/pkg/cohomolo/{'*','*/*','*/*/*'}
zoo   D   disk1440/5/xgp${name}.zoo  gap${name}/pkg/grape/{'*','*/*','*/*/*'}
zoo   D   disk1440/5/xgp${name}.zoo  gap${name}/pkg/guava/{'*','*/*','*/*/*'}
zoo   D   disk1440/5/xgp${name}.zoo  gap${name}/pkg/smash/{'*','*/*','*/*/*'}
zoo   D   disk1440/5/xgp${name}.zoo  gap${name}/pkg/weyl/{'*','*/*','*/*/*'}
zoo   D   disk1440/5/xgp${name}.zoo  gap${name}/pkg/anupq/{'*','*/*','*/*/*'}
zoo   D   disk1440/5/xgp${name}.zoo  gap${name}/pkg/anusq/{'*','*/*','*/*/*'}
zoo   D   disk1440/5/xgp${name}.zoo  gap${name}/pkg/meataxe/{'*','*/*','*/*/*'}
zoo   D   disk1440/5/xgp${name}.zoo  gap${name}/pkg/nq/{'*','*/*','*/*/*'}
zoo   D   disk1440/5/xgp${name}.zoo  gap${name}/pkg/sisyphos/{'*','*/*','*/*/*'}
zoo   D   disk1440/5/xgp${name}.zoo  gap${name}/pkg/ve/{'*','*/*','*/*/*'}
zoo   PE  disk1440/5/xgp${name}.zoo
chmod 444 disk1440/5/xgp${name}.zoo
chmod 555 disk1440/5

# sixth disk ################################################################
mkdir disk1440/6
cp split/pkg${name}.zoo disk1440/6/pka${name}.zoo
chmod 644 disk1440/6/pka${name}.zoo
zoo   D   disk1440/6/pka${name}.zoo  gap${name}/pkg/anupq/{'*','*/*','*/*/*'}
zoo   D   disk1440/6/pka${name}.zoo  gap${name}/pkg/anusq/{'*','*/*','*/*/*'}
zoo   D   disk1440/6/pka${name}.zoo  gap${name}/pkg/meataxe/{'*','*/*','*/*/*'}
zoo   D   disk1440/6/pka${name}.zoo  gap${name}/pkg/nq/{'*','*/*','*/*/*'}
zoo   D   disk1440/6/pka${name}.zoo  gap${name}/pkg/sisyphos/{'*','*/*','*/*/*'}
zoo   D   disk1440/6/pka${name}.zoo  gap${name}/pkg/ve/{'*','*/*','*/*/*'}
zoo   D   disk1440/6/pka${name}.zoo  gap${name}/pkg/xgap/{'*','*/*','*/*/*'}
zoo   PE  disk1440/6/pka${name}.zoo
chmod 444 disk1440/6/pka${name}.zoo
chmod 555 disk1440/6

# seventh disk ##############################################################
mkdir disk1440/7
cp split/pkg${name}.zoo disk1440/7/pkb${name}.zoo
chmod 644 disk1440/7/pkb${name}.zoo
zoo   D   disk1440/7/pkb${name}.zoo  gap${name}/pkg/cohomolo/{'*','*/*','*/*/*'}
zoo   D   disk1440/7/pkb${name}.zoo  gap${name}/pkg/grape/{'*','*/*','*/*/*'}
zoo   D   disk1440/7/pkb${name}.zoo  gap${name}/pkg/guava/{'*','*/*','*/*/*'}
zoo   D   disk1440/7/pkb${name}.zoo  gap${name}/pkg/smash/{'*','*/*','*/*/*'}
zoo   D   disk1440/7/pkb${name}.zoo  gap${name}/pkg/weyl/{'*','*/*','*/*/*'}
zoo   D   disk1440/7/pkb${name}.zoo  gap${name}/pkg/xgap/{'*','*/*','*/*/*'}
zoo   PE  disk1440/7/pkb${name}.zoo
chmod 444 disk1440/7/pkb${name}.zoo
chmod 555 disk1440/7

# that's it for the IBM PC disks distribution ###############################
chmod 555 disk1440


# that's it for packing #####################################################
rm gap${name}

