#include "pq_defs.h"
#include "pcp_vars.h"
#include "constants.h"
#include "pq_functions.h"
#include "exp_vars.h"

/* determine whether trial value is upper bound on exponent of the 
   group; do this by checking that all test words are trivial */

Logical check_exponent (trial_exponent, exp_flag, pcp)
int trial_exponent;
struct exp_vars *exp_flag;
struct pcp_vars *pcp;
{
   initialise_exponent (exp_flag, pcp);
   exp_flag->check_exponent = TRUE;
   exp_flag->all_trivial = TRUE;

   pcp->extra_relations = trial_exponent;

   /* now generate and power all test words */
   extra_relations (exp_flag, pcp);

   /* if trivial flag is true, we have (upper bound on) exponent */
   return exp_flag->all_trivial; 
}
