/* ========================== C MeatAxe =============================
   examples.c - Sample program. Demonstrates the use of various
		MeatAxe library functions.

   (C) Copyright 1993 Michael Ringe, Lehrstuhl D fuer Mathematik,
   RWTH Aachen, Germany  <mringe@tiffy.math.rwth-aachen.de>
   This program is free software; see the file COPYING for details.
   ================================================================== */


/* $Id: examples.c,v 1.3 1994/02/13 18:26:56 mringe Exp $
 *
 * $Log: examples.c,v $
 * Revision 1.3  1994/02/13  18:26:56  mringe
 * Neu: os.c, os.h.
 *
 * Revision 1.2  1993/11/25  14:12:34  mringe
 * VOn skeleton.c in examples.c umbenannt.
 *
 * Revision 1.1  1993/10/20  18:17:07  mringe
 * Initial revision
 *
 */


#include <string.h>
#include "meataxe.h"



/* ------------------------------------------------------------------
   Variables
   ------------------------------------------------------------------ */

static char *helptext[] = {
"SYNTAX",
"    skeleton [<Options>] <File> <Result>",
"",
"OPTIONS",
"    -Q        Quiet, no messages",
"    -V        Verbose, more messages (repeat -V to get",
"              even more messages).",
"    -I <IQ>   Set user IQ. <IQ> must be a positive integer.",
"",
"FILES",
"    <File>    i  The input file",
"    <Result>  o  The result",
NULL};

static proginfo_t pinfo =
   { "skeleton", "MeatAxe sample program",
     "$Revision: 1.3 $", helptext };


char *inpfilename, *outfilename:
long irq = 70;

/* ------------------------------------------------------------------
   Function prototypes
   ------------------------------------------------------------------ */

/* ------------------------------------------------------------------
   file_demo() - demonstrates use of file i/o functions
   ------------------------------------------------------------------ */

static void file_demo()

{
    FILE *f;
    long lbuf[3];
    PTR p;


    /* I/O functions operating on streams
       ---------------------------------- */
    if (NULL = (f = os_fopen("filename",FM_READ)))	/* Open file */
	errexit(ERR_FILEOPEN,"filename");

    zreadlong(f,lbuf,3);	/* Read 3 long integers */

    p = zalloc(10);		/* Read 10 packed rows */
    zreadvec(f,p,10);


}


/* ------------------------------------------------------------------
   main()
   ------------------------------------------------------------------ */

int main(argc, argv)
int argc;
char *argv[];

{
    /* Initialize the MeatAxe library
       ------------------------------ */
    mtxinit();

    /* Parse command line
       ------------------ */
    initargs(argc, argv, &pinfo);
    while ((i = zgetopt("GI:")) != OPT_END)
    {
	switch (i)
	{
	    case 'I':
		if ((iq = getint()) == GETINT_ERR ||
		    iq <= 0 || *opt_text_ptr != 0)
		    errexit(ERR_OPTION,"-I");
		break;
	}
    }
    if (opt_ind != argc-2) errexit(ERR_BADUSAGE,"skeleton");
    inpfilename = argc[opt_ind];
    outfilename = argc[opt_ind+1];
    if (MSG1)
    {
	printf("Input file = %s\n",inpfilename);
	printf("Output file = %s\n",outpfilename);
	printf("User IQ = %d\n",iq);
    }
    return 0;
}


