/* ========================== C MeatAxe =============================
   gcd.c - Greatest common divisor

   (C) Copyright 1993 Michael Ringe, Lehrstuhl D fuer Mathematik,
   RWTH Aachen, Germany  <mringe@tiffy.math.rwth-aachen.de>
   This program is free software; see the file COPYING for details.
   ================================================================== */


/* $Id: gcd.c,v 1.1 1993/12/14 22:27:11 mringe Exp $
 *
 * $Log: gcd.c,v $
 * Revision 1.1  1993/12/14  22:27:11  mringe
 * Initial revision
 *
 */

#include "meataxe.h"


/* ------------------------------------------------------------------
   gcd() - Greatest common divisor.
   ------------------------------------------------------------------ */

long gcd(a,b)
long a,b;

{
    if (a == 0) return b;
    if (b == 0) return a;
    while (1)
    {
	if ((a %= b) == 0) return b;
	if ((b %= a) == 0) return a;
    }
}


