/* ========================== C MeatAxe =============================
   message.c - Messages.

   (C) Copyright 1993 Michael Ringe, Lehrstuhl D fuer Mathematik,
   RWTH Aachen, Germany  <mringe@tiffy.math.rwth-aachen.de>
   This program is free software; see the file COPYING for details.
   ================================================================== */


/* $Id: message.c,v 2.1 1993/10/20 18:17:07 mringe Exp $
 *
 * $Log: message.c,v $
 * Revision 2.1  1993/10/20  18:17:07  mringe
 * MeatAxe-2.0, Phase II.
 *
 * Revision 2.0  1993/10/14  18:54:18  mringe
 * MeatAxe-2.0, Phase I
 *
 * Revision 1.14  1993/10/11  19:05:28  mringe
 * Neue Library-Struktur.
 *
 * Revision 1.13  1993/10/06  04:41:05  mringe
 * utils Library eliminiert.
 *
 * Revision 1.12  1993/10/05  19:05:02  mringe
 * Neue Fehlermeldungen. yerrno eliminiert.
 *
 * Revision 1.11  1993/10/02  15:26:39  mringe
 * Fehlermeldungen fuer Schrieb-/Lesefehler.
 *
 * Revision 1.10  1993/08/06  14:01:59  mringe
 * Neuer File-header.
 *
 * Revision 1.9  1993/08/05  15:48:54  mringe
 * Neues message.c
 *
 */


#include "meataxe.h"


/* ------------------------------------------------------------------
   Global data
   ------------------------------------------------------------------ */

int msg_level = 0;
int mtxerrno = 0;
int mtxerraction = 0;

static char *mtxerrfile;
static int mtxerrline;

static struct msg_struct { int errno; char *smsg, *lmsg; } msgs[] =
  {
    { ERR_NOMEM, "Not enough memory", NULL },
    { ERR_GAMEOVER, "Time limit exceeded", NULL },
    { ERR_DIV0, "Division by zero", NULL },

    { ERR_FILEOPEN, "Could not open file", NULL },
    { ERR_FILEREAD, "File read error", NULL },
    { ERR_FILEWRITE, "File write error", NULL },
    { ERR_FILEFMT, "Bad file format", NULL },
    { ERR_NFILES, "Too many files", NULL },

    { ERR_BADARG, "Bad argument", NULL },
    { ERR_BADTYPE, "Bad type", NULL },
    { ERR_RANGE, "Argument out of range", NULL },
    { ERR_BADARG, "Bad argument", NULL },
    { ERR_NOTECH, "Matrix not in echelon form", NULL },
    { ERR_NOTSQUARE, "Matrix not square", NULL },
    { ERR_INCOMPAT, "Incompatible objects", NULL },

    { ERR_BADUSAGE, "Bad syntax, try `-help'", NULL},
    { ERR_OPTION, "Bad usage of option, try `-help'", NULL},
    { ERR_NARGS, "Bad number of arguments, try `-help'", NULL},

    { ERR_NOTMATRIX, "Not a matrix", NULL},
    { ERR_NOTPERM, "Not a permutation", NULL},
    { ERR_NOTPOLY, "Not a polynomial", NULL},
    { -1, NULL, NULL }
  };


/* ------------------------------------------------------------------
   errmsg()
   ------------------------------------------------------------------ */

static char *errmsg(en)
int en;
{
    static char buf[30];
    struct msg_struct *x;

    for (x = msgs; x->errno >= 0; ++x)
        if (x->errno == en)
	    return x->smsg;

    sprintf(buf,"Unknown error %d",en);
    return buf;
}



/* ------------------------------------------------------------------
   errhandler() - MeatAxe error handler
   ------------------------------------------------------------------ */

int errhandler(errno,errfile,errline)
int errno;
char *errfile;
int errline;

{
    mtxerrno = errno;
    mtxerrfile = errfile;
    mtxerrline = errline;
    if (mtxerraction < 1) return 0;
    fprintf(stderr,"%s(%d): %s.\n",mtxerrfile,mtxerrline,
	errmsg(errno));
    if (mtxerraction < 2) return 1;
    fprintf(stderr,"Program halted\n");
    exit(1);
}


/* ------------------------------------------------------------------
   mtxerror() - Print error message with prefix.
   ------------------------------------------------------------------ */

void mtxerror(text)
char *text;

{
    fprintf(stderr,"%s: %s.\n",text,errmsg(mtxerrno));
}


/* ------------------------------------------------------------------
   errexit() - Terminate program with error message
   ------------------------------------------------------------------ */

void errexit(code,text)
int code;
char *text;

{
    if (code >= 0)
	mtxerrno = code;
    mtxerror(text);
    exit(EXIT_ERR);
}


