/* ========================== C MeatAxe =============================
   mtxobj.c - MeatAxe object methods.

   (C) Copyright 1993 Michael Ringe, Lehrstuhl D fuer Mathematik,
   RWTH Aachen, Germany  <mringe@tiffy.math.rwth-aachen.de>
   This program is free software; see the file COPYING for details.
   ================================================================== */


/* $Id: mtxobj.c,v 1.1 1994/02/12 04:10:13 mringe Exp $
 *
 * $Log: mtxobj.c,v $
 * Revision 1.1  1994/02/12  04:10:13  mringe
 * Initial revision
 *
 */

#include <stdlib.h>
#include "meataxe.h"

#define NMTXTYPES 21


/* ------------------------------------------------------------------
   mtx_free() - Destructor
   ------------------------------------------------------------------ */

typedef void dt _PL((void *obj));
static dt *freetbl[NMTXTYPES] =
{
    (dt *) matfree, (dt *) permfree, (dt *) polfree, (dt *) set_free,
    (dt *) bs_free,
    NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL,
    (dt *) seq_free
};

void mtx_free(s)
void *s;

{
    Ushort id = *(Ushort *)s;
    if (id < NMTXTYPES && freetbl[id] != NULL)
	freetbl[id](s);
}



/* ------------------------------------------------------------------
   mtx_getdesc() - Returns description of the object.
   ------------------------------------------------------------------ */

typedef char *ds _PL((void *obj));
static ds *desctbl[NMTXTYPES] =
{
    (ds *) matdesc, (ds *) permdesc, (ds *) poldesc, (ds *) set_desc,
    (ds *) bs_desc,
    NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL,
    (ds *) seq_desc
};

char *mtx_getdesc(s)
void *s;

{
    Ushort id = *(Ushort *)s;
    if (id < NMTXTYPES && desctbl[id] != NULL)
	return desctbl[id](s);
    return "?UNKNOWN?";
}



/* ------------------------------------------------------------------
   mtx_getname() - Returns the objects type name.
   ------------------------------------------------------------------ */

static char *nametbl[NMTXTYPES] =
{
    "T_MATRIX", "T_PERM", "T_POLY", "T_SET",
    "T_BITS",
    NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL,
    "T_SEQ"
};

char *mtx_getname(s)
void *s;

{
    Ushort id = *(Ushort *)s;
    if (id < NMTXTYPES && nametbl[id] != NULL)
	return nametbl[id];
    return "?UNKNOWN?";
}



/* ------------------------------------------------------------------
   mtx_read() - Reads an object.
   ------------------------------------------------------------------ */

typedef void *rf _PL((FILE *f));
static rf *readtbl[NMTXTYPES] =
{
    (rf *) matread, (rf *) permread, (rf *) polread, (rf *) set_read,
    (rf *) bs_read,
    NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL,
    (rf *) seq_read
};

void *mtx_read(f)
FILE *f;

{
    long l;
    Ushort id;

    if (zreadlong(f,&l,1) != 1) MTXFAIL(ERR_FILEREAD,NULL);
    id = (Ushort) l;

    if (id < NMTXTYPES && readtbl[id] != NULL)
	return readtbl[id](f);
    MTXFAIL(ERR_FILEFMT,NULL);
}



/* ------------------------------------------------------------------
   mtx_write() - Write an object.
   ------------------------------------------------------------------ */

typedef int wf _PL((FILE *f, void *x));
static wf *writetbl[NMTXTYPES] =
{
    (wf *) matwrite, (wf *) permwrite, (wf *) polwrite,
    (wf *) set_write, (wf *) bs_write,
    NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL,
    (wf *) seq_write
};

int mtx_write(f,x)
FILE *f;
void *x;

{
    Ushort id = *(Ushort *)x;
    long l = (long) id;

    if (id < NMTXTYPES && writetbl[id] != NULL)
    {
        if (zwritelong(f,&l,1) != 1) MTXFAIL(ERR_FILEWRITE,NULL);
	return writetbl[id](f,x);
    }
    MTXFAIL(ERR_FILEWRITE,NULL);
}


