/* ========================== C MeatAxe =============================
   zspin.c - Spin-up of vectors and related functions.

   (C) Copyright 1993 Michael Ringe, Lehrstuhl D fuer Mathematik,
   RWTH Aachen, Germany  <mringe@tiffy.math.rwth-aachen.de>
   This program is free software; see the file COPYING for details.
   ================================================================== */


/* $Id: zspin.c,v 2.1 1993/10/20 18:17:07 mringe Exp $
 *
 * $Log: zspin.c,v $
 * Revision 2.1  1993/10/20  18:17:07  mringe
 * MeatAxe-2.0, Phase II.
 *
 * Revision 2.1  1993/10/20  18:17:07  mringe
 * MeatAxe-2.0, Phase II.
 *
 * Revision 2.0  1993/10/14  18:54:18  mringe
 * MeatAxe-2.0, Phase I
 *
 * Revision 1.4  1993/10/11  19:05:28  mringe
 * Neue Library-Struktur.
 *
 * Revision 1.3  1993/08/06  14:01:59  mringe
 * Neuer File-header.
 *
 * Revision 1.2  1993/05/12  10:31:47  mringe
 * Prototypes korrigiert.
 *
 * Revision 1.1  1993/02/10  19:40:54  mringe
 * Initial revision
 *
 * Revision 1.1  1993/01/28  07:35:51  mringe
 * Initial revision
 *
 */


#include "meataxe.h"


/* ------------------------------------------------------------------
   zspinup() - Spin up one or more vectors using a set of matrices
	or permutations.

   Return value: Returns the subspace dimension or -1 on error.
   ------------------------------------------------------------------ */

long zspinup(space, nseed, piv, gen, ngen, gentype)

PTR space;	/* The seed space */
long nseed;	/* Dimension of seed space */
long *piv;	/* Pivot table for seed space */
PTR gen[];	/* Set of generators */
int ngen;	/* Number of generators */
int gentype;	/* Generator type (T_MATRIX or T_PERM) */

{
    PTR xget, xput;
    long iget;
    long dim;
    int igen;

    if (zmkechelon(space,nseed,piv) == -1) return -1;
    dim = piv[0];
    iget = 1; xget = space;
    xput = space; zadvance(&xput,dim);    
    igen = 0;

    if (dim > 0 && ngen > 0)
    {
        while (iget <= dim && dim < znoc)
        {
	    FEL f;

	    if (gentype == T_MATRIX)
	        zmaprow(xget,gen[igen],znoc,xput);
	    else
	        zpermrow(xget,gen[igen],xput);
	    if (++igen >= ngen)
	    {
	        igen = 0;
	        ++iget;
	        zadvance(&xget,(long)1);
	    }
	    zcleanrow(xput,space,dim,piv);
	    if ((piv[dim+1] = zfindpiv(xput,&f)) != 0)
	    {
	        ++dim;
	        zadvance(&xput,1);
	    }
        }
    }
    piv[0] = dim;
    return dim;
}


