/* ========================== C MeatAxe =============================
   ztr.c - Transpose a matrix.

   (C) Copyright 1993 Michael Ringe, Lehrstuhl D fuer Mathematik,
   RWTH Aachen, Germany  <mringe@tiffy.math.rwth-aachen.de>
   This program is free software; see the file COPYING for details.
   ================================================================== */


/* $Id: ztr.c,v 2.2 1994/02/13 18:26:56 mringe Exp $
 *
 * $Log: ztr.c,v $
 * Revision 2.2  1994/02/13  18:26:56  mringe
 * Neu: os.c, os.h.
 *
 * Revision 2.1  1993/10/20  18:17:07  mringe
 * MeatAxe-2.0, Phase II.
 *
 * Revision 2.0  1993/10/14  18:54:18  mringe
 * MeatAxe-2.0, Phase I
 *
 * Revision 1.8  1993/10/11  19:05:28  mringe
 * Neue Library-Struktur.
 *
 * Revision 1.7  1993/10/06  04:41:05  mringe
 * utils Library eliminiert.
 *
 * Revision 1.6  1993/10/05  23:44:33  mringe
 * err() eliminiert.
 *
 * Revision 1.5  1993/08/06  15:11:49  mringe
 * Bug behoben.
 *
 * Revision 1.4  1993/08/06  14:01:59  mringe
 * Neuer File-header.
 *
 * Revision 1.3  1993/08/05  15:52:49  mringe
 * File header
 *
 * Revision 1.2  1993/07/13  20:30:59  mringe
 * Neue File i/o library.
 *
 * Revision 1.1  1992/05/26  18:17:58  mringe
 * Initial revision
 *
 */


#include "meataxe.h"

/* ------------------------------------------------------------------
   Global Data
   ------------------------------------------------------------------ */

static char *iname, *oname;

static char *helptext[] = {
"SYNTAX",
"    ztr [-QV] <Mat> <Result>",
"",
"OPTIONS",
"    -Q    Quiet, no messages",
"    -V    Verbatim, more messages",
"",
"FILES",
"    <Mat>      i  Any matrix",
"    <Result>   o  The transposed matrix",
NULL};

static proginfo_t pinfo =
   { "ztr", "Transpose", "$Revision: 2.2 $", helptext };



/* ------------------------------------------------------------------
   main()
   ------------------------------------------------------------------ */

int main(argc, argv)
int argc;
char *argv[];

{
    long fl;
    PTR m1, m2, x1;
    long nor, noc, j, k;
    FEL f1;
    FILE *f;


    /* Parse command line
       ------------------ */
    mtxinit();
    initargs(argc, argv, &pinfo);
    while (zgetopt("") != OPT_END);
    if (opt_ind != argc-2) errexit(ERR_NARGS,"ztr");
    iname = argv[opt_ind];
    oname = argv[opt_ind+1];

    /* Read matrix
       ----------- */
    if ((f = zreadhdr(iname,&fl,&nor,&noc)) == NULL)
	errexit(-1,iname);
    if (fl < 2) errexit(ERR_NOTMATRIX,argv[opt_ind]);
    zsetlen(fl,noc);
    m1 = zalloc(nor);
    zreadvec(f,m1,nor);
    fclose(f);

    /* Transpose
       --------- */
    zsetlen(fl,nor);
    m2 = zalloc((long)1);
    if ((f = zwritehdr(oname,fl,noc,nor)) == NULL)
	errexit(-1,oname);
    for (j = 1; j <= noc; ++j)
    {
	zsetlen(fl,nor);
	zmulrow(m2,F_ZERO);
	zsetlen(fl,noc);
	x1 = m1;
	for (k = 1; k <= nor; ++k)
	{
	    f1 = zextract(x1,j);
	    zinsert(m2,k,f1);
	    zadvance(&x1,(long)1);
	}
	zsetlen(fl,nor);
	zwritevec(f,m2,(long)1);
    }
    fclose(f);
    return (EXIT_OK);
}


