/********************************************************************/
/*                                                                  */
/*  Module        : Error                                           */
/*                                                                  */
/*  Version       : 4.8                                             */
/*  Last revision : 10/13/93 15:42:46                               */
/*                                                                  */
/*  Description :                                                   */
/*     Handles errors                                               */
/*                                                                  */
/*  Functions supplied :                                            */
/*     void proc_error ( char *err_msg );                           */
/*                                                                  */
/********************************************************************/
#include "aglobals.h"
#define ALLOC
# include	"error.h"

extern DSTYLE displaystyle;

static char *error_msg[] = {
	"no error",
	"undefined expression",
	"expression is not of type 'group'",
	"expression is not of type 'pcgroup'",
	"expression is not of type 'groupring'",
	"expression is not of type 'group element'",
	"expression is not of type 'integer'",
	"expression is not of type 'element of groupring'",
	"expression is not of type 'vectorspace'",
	"expression is not of type 'list'",
	"expression is not of type 'group homomorphisms'",
	"incompatible types",
	"incompatible spaces",
	"invalid relation - wrong generator",
	"invalid relation - unexpected character",
	"no generator declaration",
	"no relation declaration",
	"mising '('",
	"invalid generator",
	"invalid separator",
	"invalid relation",
	"invalid pc relation",
	"memory exhausted",
	"temporary memory exhausted",
	"no automorphisms for group",
	"string expected",
	"wrong type",
	"couldn't open file",
	"syntax error",
	"generator may not be reassigned",
	"element is not a unit",
	"division by zero",
	"no jennings weights for group",
	"no inner automorphisms available"
};
	
void proc_error ( void )
{
	char *error_prefix;
	char *warning_prefix;
	
	error_prefix = displaystyle == GAP ? "#E " : "";
	warning_prefix = displaystyle == GAP ? "#W " : "";
	
	if ( error_no != NO_ERROR ) {
		fprintf ( stderr, "%sERROR: %s\n", error_prefix, error_msg[error_no] );
		error_no = NO_ERROR;
	}
	else {
		if ( warning_no != NO_ERROR ) {
			fprintf ( stderr, "%sWARNING: %s\n", warning_prefix, error_msg[warning_no] );
			warning_no = NO_ERROR;
		}
	}
}

void set_error ( ERR_MSG error_num )
{
	if ( error_no == NO_ERROR )
		error_no = error_num;
}

void set_warning ( ERR_MSG error_num )
{
	if ( warning_no == NO_ERROR )
		warning_no = error_num;
}

/* end of module error */
