#!/bin/sh
#############################################################################
##
#A  xgap                       XGAP source                       Frank Celler
##
#H  @(#)$Id: xgap.sh,v 1.9 1994/06/06 09:04:08 fceller Exp $
##
#Y  Copyright (C) 1993,  Lehrstuhl D fuer Mathematik,  RWTH, Aachen,  Germany
##
#H  $Log: xgap.sh,v $
#H  Revision 1.9  1994/06/06  09:04:08  fceller
#H  added '-tiny', etc and '-nopred'
#H
#H  Revision 1.8  1993/12/22  10:07:12  fceller
#H  GAP 3.4 version
#H
#H  Revision 1.7  1993/12/15  10:23:00  fceller
#H  changed XFree86-1.3 entries to XFree86-2.0
#H
#H  Revision 1.6  1993/10/28  15:02:57  fceller
#H  change paths
#H
#H  Revision 1.5  1993/10/21  18:19:05  fceller
#H  added hp support
#H
#H  Revision 1.4  1993/10/20  10:39:05  fceller
#H  changed exe names
#H
#H  Revision 1.3  1993/10/18  11:26:13  fceller
#H  avoid shell scripts for gap
#H
#H  Revision 1.2  1993/10/18  10:59:37  fceller
#H  added '-G' option
#H
#H  Revision 1.1  1993/08/18  11:09:48  fceller
#H  Initial revision
##


## $DISPLAY variable must be set ############################################
if [ "x$DISPLAY" = "x" ];  then
  echo 'FATAL: you must set $DISPLAY'
  exit 1;
fi;

## determinate type of server ###############################################
if [ "x$DISPLAY" = "x:0.0" ];  then
  server=`hostname | sed 's/\\..*//'`
else
  server=`basename $DISPLAY :0.0`
fi;

## detrmine host and name of the shell script ###############################
host=`hostname | sed 's/\\..*//'`
script=`basename $0`
spath=`echo $0 | sed "s/\/$script\$//"`

## force spath in case the script live somewhere else #######################
spath=/usd/gap/3.4/pkg/xgap/bin
#spath=/home/gap/pkg/xgap/bin

## construct various fonts ##################################################
case $server  in

  # DecStation running DecWindows
  dang01|dang02)
    FONT="  -font   -*-courier-bold-r-*-*-14-*-*-*-*-*-*-*"
    TINY="  -tiny   -*-*-*-*-*-*-8-*-*-*-*-*-*-*"
    SMALL=" -small  -*-courier-medium-r-*-*-12-*-*-*-*-*-*-*"
    NORMAL="-normal -*-courier-medium-r-*-*-14-*-*-*-*-*-*-*"
    LARGE=" -large  -*-courier-medium-r-*-*-18-*-*-*-*-*-*-*"
    HUGE="  -huge   -*-courier-medium-r-*-*-24-*-*-*-*-*-*-*"
    GEOMETRY="-geometry 750x800"
    ;;

  # NetBSD running XFree 2.0 on a color screen
  astoria|waldorf|stadler|fozzy|gonzo|rowlf)
    FONT="  -font   -misc-fixed-medium-r-se*-*-13-100-100-100-c-60-iso8859-1"
    TINY="  -tiny   -misc-fixed-medium-r-*-*-7-*-*-*-*-*-*-* "
    SMALL=" -small  -misc-fixed-medium-r-*-*-12-*-*-*-*-*-*-*"
    NORMAL="-normal -misc-fixed-medium-r-*-*-14-*-*-*-*-*-*-* "
    LARGE=" -large  -misc-fixed-medium-r-*-*-18-*-*-*-*-*-*-* "
    HUGE="  -huge   -misc-fixed-medium-r-*-*-24-*-*-*-*-*-*-*"
    BG="-bg linen"
    GEOMETRY="-geometry 502x680"
    ;;

  # FreeBSD running XFree 2.1 on a mono screen
  victor)
    FONT="  -font   -misc-fixed-medium-r-*-*-13-*-*-*-*-*-*-*"
    TINY="  -tiny   -misc-fixed-medium-r-*-*-7-*-*-*-*-*-*-* "
    SMALL=" -small  -misc-fixed-medium-r-*-*-12-*-*-*-*-*-*-*"
    NORMAL="-normal -misc-fixed-medium-r-*-*-14-*-*-*-*-*-*-* "
    LARGE=" -large  -misc-fixed-medium-r-*-*-18-*-*-*-*-*-*-* "
    HUGE="  -huge   -misc-fixed-medium-r-*-*-24-*-*-*-*-*-*-*"
    GEOMETRY="-geometry 600x450"
    ;;

  # NeXT running MouseX
  bjerun)
    FONT="-font -*-clean-medium-*-*-*-13-*-*-*-*-*-*-*"
    GEOMETRY="-geometry 502x720"
    ;;
  *)

esac

## get executable ###########################################################
case $host in
  groover)
    EXEC="$spath/xgap-hp-hppa1.1-hpux"
    LIB="$spath/../lib/;/usd/gap/3.4/lib/"
    DOC="/usd/gap/3.4/doc/"
    GAP="/usd/gap/3.4/bin/gap-hp-hppa1.1-hpux"
    ;;
  dang01|dang02|dangan)
    EXEC="$spath/xgap-dec-mips-ultrix"
    LIB="$spath/../lib/;/tpsoftw/gap/3.4/lib/"
    DOC="/tpsoftw/gap/3.4/doc/"
    GAP="/tpsoftw/gap/3.4/bin/gap-dec-mips-ultrix"
    ;;
  astoria|waldorf|stadler|gonzo|fozzy|rowlf)
    EXEC="$spath/xgap-ibm-i386-netbsd"
    LIB="$spath/../lib/;/usd/gap/3.4/lib/"
    DOC="/usd/gap/3.4/doc"
    GAP="/usd/gap/3.4/bin/gap-ibm-i386-386bsd"
    ;;
  victor)
    EXEC="$spath/xgap-ibm-i386-freebsd"
    LIB="$spath/../lib/;/home/gap/lib/"
    DOC="/home/gap/doc"
    GAP="/home/gap/bin/gap-ibm-i386-386bsd"
    ;;
  ernie|tiffy|samson|bert)
    EXEC="$spath/xgap-dec-mips-ultrix"
    LIB="$spath/../lib/;/usd/gap/3.4/lib/"
    DOC="/usd/gap/3.4/doc"
    GAP="/usd/gap/3.4/bin/gap-dec-mips-ultrix"
    ;;
  bjerun)
    EXEC="$spath/xgap-next-m68k-mach"
    LIB="$spath/..lib/;/home/gap/3.4/lib/"
    DOC="/home/gap/3.4/doc"
    GAP="/usr/local/bin/gap"
    ;;
  *)
    echo "FATAL: no executable for your machine"
    exit 1
    ;;
esac

## parse arguments ##########################################################
FILES=""
MEM="4m"
while [ $# -gt 0 ];  do
  case $1 in
    -G)        shift;  GAP="$1"             ;;
    -m)        shift;  MEM="$1"             ;;
    -l)        shift;  LIB="$1"             ;;
    -h)        shift;  DOC="$1"             ;;
    -geometry) shift;  GEOMETRY="$1"        ;;
    -font)     shift;  FONT="-font $1"      ;;
    -tiny)     shift;  TINY="-tiny $1"      ;;
    -small)    shift;  SMALL="-small $1"    ;;
    -normal)   shift;  NORMAL="-normal $1"  ;;
    -large)    shift;  LARGE="-large $1"    ;;
    -huge)     shift;  HUGE="-huge $1"      ;;
    -nopred)   GEOMETRY=""; FONT=""; TINY=""; SMALL=""; LARGE=""; HUGE="" ;;
    *) FILES="${FILES} $1"            ;;
  esac
  shift
done

## start xgap ###############################################################
$EXEC \
    $FONT $TINY $SMALL $NORMAL $LARGE $HUGE \
    $BG $GEOMETRY \
    -G $GAP -l $LIB -h $DOC -m $MEM $FILES &

## and return ###############################################################
exit 0
