#############################################################################
##
#A  init.g                      XGAP library                     Frank Celler
##
#H  @(#)$Id: init.g,v 1.5 1994/06/11 09:27:57 fceller Exp $
##
#Y  Copyright (C) 1993,  Lehrstuhl D fuer Mathematik,  RWTH, Aachen,  Germany
##
#H  $Log: init.g,v $
#H  Revision 1.5  1994/06/11  09:27:57  fceller
#H  updated release number
#H
#H  Revision 1.4  1993/10/18  11:06:14  fceller
#H  added fast updated
#H
#H  Revision 1.3  1993/10/06  16:19:23  fceller
#H  added 'GraphicLatticeOps'
#H
#H  Revision 1.2  1993/10/05  12:33:26  fceller
#H  added '.isAlive'
#H
#H  Revision 1.1  1993/08/18  10:59:09  fceller
#H  Initial revision
##


## set version ##############################################################
XGAPVERSION := "Version 1 Release 2";

## read in original init file ###############################################
ReadPath := function ( path, name, ext )
    local   i, k, file, found;
    i := 1;
    found := false;
    while not found  and i <= Length(path)+1 do
        k := Position( path, ';', i-1 );
        if k = false  then k := Length(path)+1;  fi;
        file := path{[i..k-1]};  Append( file, name );  Append( file, ext );
        found := READ( file );
        i := k + 1;
    od;
    return found;
end;

GAPLIBNAME := LIBNAME{[ Position(LIBNAME,';')+1 .. Length(LIBNAME) ]};
ReadPath( GAPLIBNAME, "init", ".g" );

## print banner #############################################################
if BANNER  then
    Print( "\n     X-Window ", XGAPVERSION, " by\n",
             "     Frank Celler and Susanne Keitemeier\n\n" );
fi;

## set editor ###############################################################
if not IsBound(EDITOR)  then 
    EDITOR := "xterm -e vi";
fi;

## initialize window/selectors lists ########################################
WINDOWS   := [];
SELECTORS := [];

## auto read library ########################################################
AUTO( ReadLib("window"),
      TINY_FONT, SMALL_FONT, NORMAL_FONT, LARGE_FONT,
      HUGE_FONT, FONTS, LP_BUTTON, RP_BUTTON, 
      PointerButtonDown, MenuSelected, TextSelected, ButtonSelected,
      Drag,
      WcAddMenu, WcCheckMenu, WcCloseWindow, WcDestroy, WcDialog,
      WcDrawBox, WcDrawCircle, WcDrawDisc, WcDrawLine,
      WcDrawText, WcEnableMenu, WcOpenWindow, WcPopupMenu,
      WcQueryPointer, WcQueryPopup, WcResizeWindow, WcSetLineWidth,
      WcSetTitle, WcTextSelector, WcTsChangeText, WcTsClose,
      WcTsEnable, WcTsUnhighlight, WcFastUpdate );

AUTO( ReadLib("sheet"),
      Close, Delete, SetTitle, GraphicSheet, Highlight, Move, Relabel,
      Reshape, Unhighlight, Line, Box, Circle, Disc, Diamond,
      Text, Vertex, Connection, Disconnect, GraphicSheetOps );

AUTO( ReadLib("menu"),
      FILENAME_DIALOG, Enable, Disable, Check, Query, Uncheck, Menu,
      TextSelector, Dialog, PopupMenu );

AUTO( ReadLib("graphlat"),
      GraphicLattice, GraphicLatticeList, GraphicLatticeOps );
