/****************************************************************************
**
*A  gapgraph.h                  XGAP source                      Frank Celler
**
*H  @(#)$Id: gapgraph.h,v 1.3 1994/06/06 08:57:24 fceller Exp $
**
*Y  Copyright 1992-1994,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
**
*H  $Log: gapgraph.h,v $
*H  Revision 1.3  1994/06/06  08:57:24  fceller
*H  added database
*H
*H  Revision 1.2  1993/10/20  12:52:02  fceller
*H  fixed prototype for non stdc
*H
*H  Revision 1.1  1993/10/18  11:04:47  fceller
*H  added fast updated,  fixed timing problem
*H
*H  Revision 1.0  1993/04/05  11:42:18  fceller
*H  Initial revision
*/
#ifndef _gapgraph_h
#define _gapgraph_h

#include    <X11/IntrinsicP.h>
#include    <X11/CoreP.h>

#include    "utils.h"


/****************************************************************************
**
*D  T_LINE  . . . . . . . . . . . . . . . . . . . . . . . . . a straight line
*D  T_CIRCLE  . . . . . . . . . . . . . . . . . . . . . . . . a hollow circle
*D  T_DISC  . . . . . . . . . . . . . . . . . . . . . . . . . . a filled disc
*D  T_TEXT  . . . . . . . . . . . . . . . . . . . . . . . . . . . . some text
*D  T_RECT  . . . . . . . . . . . . . . . . . . . . . . . . . . . a rectangle
*/
#define T_LINE          1
#define T_CIRCLE        2
#define T_DISC          3
#define T_TEXT          4
#define T_RECT          5
#define T_BOX           6


/****************************************************************************
**
*T  TypeGapGraphicObject  . . . . . . . . . . . . .  graphic object of widget
*/
typedef struct _gap_graphic_obj
{
    short   type;
    long    x, y, w, h;
    union
    {
        struct { long x1, x2, y1, y2, w;               }   line;
        struct { long x, y, r, w;                      }   circle;
        struct { long x, y, r;                         }   disc;
        struct { long x, y, len; char *str; Font font; }   text;
	struct { long x1, x2, y1, y2, w;               }   rect;
	struct { long x1, x2, y1, y2;                  }   box;
    } desc;
}
TypeGapGraphicObject;


/****************************************************************************
**

*T  GapGrahpicClassRec	. . . . . . . . . . . . . .  gap graphic class record
*/
typedef struct {int empty;} GapGraphicClassPart;

typedef struct _GapGraphicClassRec
{
    CoreClassPart       core_class;
    GapGraphicClassPart gap_graphic_class;
}
GapGraphicClassRec;

extern GapGraphicClassRec gapGraphicClassRec;


/****************************************************************************
**
*T  GapGarphicRec . . . . . . . . . . . . . . . . . gap graphic widget record
*/
typedef struct {

    /* dimension of window */
    unsigned long       width;
    unsigned long       height;

    /* reference number */
    int                 number;

    /* list of graphic objects */
    TypeList            objs;

    /* display information */
    Display           * display;
    Pixel               black;
    Pixel               white;
    GC                  gc;

    /* bounding box to update */
    Boolean             update;
    Boolean             fast_update;
    long                lx,  hx;
    long                ly,  hy;
}
GapGraphicPart;

typedef struct _GapGraphicRec
{
    CorePart            core;
    GapGraphicPart      gap_graphic;
}
GapGraphicRec;


/****************************************************************************
**
*T  GapGraphicWidgetClass . . . . . . . . . . . . . . . . . .  class datatype
*/
typedef struct _GapGraphicClassRec    * GapGraphicWidgetClass;


/****************************************************************************
**
*T  GapGraphicWidget  . . . . . . . . . . . . . . . . . . . instance datatype
*/
typedef struct _GapGraphicRec * GapGraphicWidget;


/****************************************************************************
**
*V  gapGrpahicWidgetClass . . . . . . . . . . . . . . . . .  class definition
*/
extern WidgetClass gapGraphicWidgetClass;


/****************************************************************************
**

*P  Prototypes  . . . . . . . . . . . prototypes of public gap text functions
*/
#ifdef __STDC__
extern void GGDrawObject( Widget, TypeGapGraphicObject*, Boolean );
extern long GGAddObject( Widget, TypeGapGraphicObject* );
extern void GGFreeObject( TypeGapGraphicObject* );
extern int  GGRemoveObject( Widget, long );
extern void GGStartRemove( Widget );
extern void GGStopRemove( Widget );
extern void GGFreeAllObjects( Widget );
extern void GGFreeGapGraphicObjects( Widget );
extern void GGResize( Widget, long, long );
extern void GGFastUpdate( Widget, Boolean );
#else
extern void GGDrawObject();
extern long GGAddObject();
extern void GGFreeObject();
extern int  GGRemoveObject();
extern void GGStartRemove();
extern void GGStopRemove();
extern void GGFreeAllObjects();
extern void GGFreeGapGraphicObjects();
extern void GGResize();
extern void GGFastUpdate();
#endif

#endif

