/****************************************************************************
**
*A  gaptext.h                   XGAP source                      Frank Celler
**
*H  @(#)$Id: gaptext.h,v 1.3 1994/06/06 08:56:35 fceller Exp $
**
*Y  Copyright 1992-1994,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
**
**  The GapTextWidget is  intended to be used as  a  simple front end  to the
**  text widget with  a gap text source and an ascii sink attached to  it. It
**  is a subclass of the standard text widget supplied with X11R4.
**
*H  $Log: gaptext.h,v $
*H  Revision 1.3  1994/06/06  08:56:35  fceller
*H  updated database
*H
*H  Revision 1.2  1993/12/23  08:44:58  fceller
*H  added "gap drop prompt"
*H
*H  Revision 1.1  1993/10/18  11:04:47  fceller
*H  added fast updated,  fixed timing problem
*H
*H  Revision 1.0  1993/04/05  11:42:18  fceller
*H  Initial revision
*/
#ifndef _gaptext_h
#define _gaptext_h

#include    <X11/IntrinsicP.h>
#include    <X11/Xaw/TextP.h>
#include    <X11/Xaw/Text.h>
#include    <X11/Xaw/TextSrcP.h>
#include    <X11/Xaw/TextSrc.h>


/*****************************************************************************
**
*D  XtNinputCallback  . . . . . . . function to call in case of keyboard input
*D  XtNcheckCaretPos  . . . . . . . .  function to validate new caret position
*D  XtNtinyFont . . . . . . . . . . . . . .  tiny font for all graphic windows
*D  XtNsmallFont  . . . . . . . . . . . . . small font for all graphic windows
*D  XtNnormalFont . . . . . . . . . . . .  normal font for all graphic windows
*D  XtNlargeFont  . . . . . . . . . . . . . large font for all graphic windows
*D  XtNhugeFont . . . . . . . . . . . . . .  huge font for all graphic windows
*D  XtNtitlePosition  . . . . . . . . position of title in all graphic windows
*D  XtNquitGapCtrD  . . . . . . . . . . . . . . . . . . . .  quit gap on ctr-D
*D  XtNpasteGapPrompt . . . . . . . . paste 'gap>' prompt into gap talk window
**
**  All other resources are defined in <X11/Xaw/Text.h>
*/
#define XtNinputCallback        "inputCallback"
#define XtCInputCallback        "InputCallback"

#define XtNcheckCaretPos        "checkCaretPos"
#define XtCCheckCaretPos        "CheckCaretPos"

#define XtNtinyFont		"tinyFont"
#define XtCTinyFont             "TinyFont"

#define XtNsmallFont		"smallFont"
#define XtCSmallFont            "SmallFont"

#define XtNnormalFont		"normalFont"
#define XtCNormalFont           "NormalFont"

#define XtNlargeFont		"largeFont"
#define XtCLargeFont            "LargeFont"

#define XtNhugeFont		"hugeFont"
#define XtCHugeFont          	"HugeFont"

#define XtNtitlePosition        "titlePosition"
#define XtCTitlePosition        "TitlePosition"

#define XtNquitGapCtrD		"quitGapCtrD"
#define XtCQuitGapCtrD		"QuitGapCtrD"

#define XtNpasteGapPrompt       "pasteGapPrompt"
#define XtCPasteGapPrompt       "PasteGapPrompt"


/****************************************************************************
**

*T  GapTextClassRec . . . . . . . . . . . . . . . . . . gap text class record
*/
typedef struct {int empty;} GapClassPart;

typedef struct _GapTextClassRec
{
    CoreClassPart       core_class;
    SimpleClassPart     simple_class;
    TextClassPart       text_class;
    GapClassPart        gap_class;
}
GapTextClassRec;

extern GapTextClassRec gapTextClassRec;


/****************************************************************************
**
*T  GapRec  . . . . . . . . . . . . . . . . . . . . . . . . gap widget record
*/
typedef struct
{
    /* function to call when receiving input */
    void 		(*input_callback)();

    /* function to position caret */
    int 		(*check_caret_pos)();

    /* input buffer for unprocessed input */
    char              * buffer;
    unsigned long       size;
    unsigned long       length;

    /* flags for paste options */
    Boolean		drop_gap_prompt;

    /* other resources */
    XFontStruct	      * tiny_font;
    XFontStruct	      * small_font;
    XFontStruct	      * normal_font;
    XFontStruct	      * large_font;
    XFontStruct	      * huge_font;
    String              title_position;
    Boolean		quit_gap_ctrd;
    Boolean		paste_gap_prompt;
}
GapPart;

typedef struct _GapRec
{
    CorePart            core;
    SimplePart          simple;
    TextPart            text;
    GapPart             gap;
}
GapRec;


/****************************************************************************
**
*T  GapTextWidgetClass	. . . . . . . . . . . . . . . . . . .  class datatype
*/
typedef struct _GapTextClassRec	*GapTextWidgetClass;


/****************************************************************************
**
*T  GapTextWidget . . . . . . . . . . . . . . . . . . . . . instance datatype
*/
typedef struct _GapRec	        *GapTextWidget;


/****************************************************************************
**
*V  gapTextWidgetClass	. . . . . . . . . . . . . . . . . .  class definition
*/
extern WidgetClass gapTextWidgetClass;


/****************************************************************************
**

*T  GapSrcClassRec  . . . . . . . . . . . . . . . . . gap source class record
*/

typedef struct _GapSrcClassPart {char * empty;} GapSrcClassPart;

typedef struct _GapSrcClassRec
{
    ObjectClassPart     object_class;
    TextSrcClassPart    text_src_class;
    GapSrcClassPart     gap_src_class;
}
GapSrcClassRec;

extern GapSrcClassRec gapSrcClassRec;


/****************************************************************************
**
*T  GapSrcRec . . . . . . . . . . . . . . . . . . .  gap source object record
*/
typedef struct _GapSrcPart
{
    char              * buffer;     /* buffer holding the text             */
    unsigned long       size;       /* size of buffer                      */
    unsigned long     * lines;      /* start of lines in <buffer>          */
    unsigned long       length;     /* size of text in <buffer>            */
}
GapSrcPart;

typedef struct _GapSrcRec
{
    ObjectPart          object;
    TextSrcPart         text_src;
    GapSrcPart          gap_src;
}
GapSrcRec;


/****************************************************************************
**
*T  GapSrcObjectClass . . . . . . . . . . . . . . . . . . . .  class datatype
*/
typedef struct _GapSrcClassRec *GapSrcObjectClass;


/****************************************************************************
**
*T  GapSrcObject  . . . . . . . . . . . . . . . . . . . . . instance datatype
*/
typedef struct _GapSrcRec      *GapSrcObject;


/****************************************************************************
**
*V  gapSrcObjectClass . . . . . . . . . . . . . . . . . . .  class definition
*/
extern WidgetClass gapSrcObjectClass;


/****************************************************************************
**

*P  Prototypes  . . . . . . . . . . . prototypes of public gap text functions
*/
#ifdef __STDC__
extern void GTInsertText( Widget, char*, int );
extern void GTReplaceText( Widget, char*, int );
extern void GTMoveCaret( Widget, int );
extern void GTDeleteLeft( Widget );
extern void GTDeleteRight( Widget );
extern void GTBell( Widget );
extern long GTPosition( Widget );
extern void GTSetPosition( Widget, long );
extern void GTDropGapPrompt( Widget, Boolean );
#else
extern void GTInsertText();
extern void GTReplaceText();
extern void GTMoveCaret();
extern void GTDeleteLeft();
extern void GTDeleteRight();
extern void GTBell();
extern long GTPosition();
extern void GTSetPosition();
extern void GTDropGapPrompt();
#endif

#endif
