/****************************************************************************
**
*A  popdial.h			XGAP source	                 Frank Celler
**
*H  @(#)$Id: popdial.h,v 1.2 1994/06/06 08:57:24 fceller Exp $
**
*Y  Copyright 1992-1994,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
**
**  This file contains functions for popping up dialogs.
**
*H  $Log: popdial.h,v $
*H  Revision 1.2  1994/06/06  08:57:24  fceller
*H  added database
*H
*H  Revision 1.1  1993/10/18  11:04:47  fceller
*H  added fast updated,  fixed timing problem
*H
*H  Revision 1.0  1993/04/05  11:42:18  fceller
*H  Initial revision
*/
#ifndef _popdial_h
#define _popdial_h

#include    <X11/X.h>
#include    <X11/IntrinsicP.h>


/****************************************************************************
**
*D  YES	. . . . . . . . . . . . . . . . . . . . . . . . . . exit button "yes"
*D  NO  . . . . . . . . . . . . . . . . . . . . . . . . . .  exit button "no"
*D  OK  . . . . . . . . . . . . . . . . . . . . . . . . . .  exit button "OK"
*D  CANCEL  . . . . . . . . . . . . . . . . . . . . . .  exit button "cancel"
*D  ABORT . . . . . . . . . . . . . . . . . . . . . . . . exit button "abort"
*D  RETRY . . . . . . . . . . . . . . . . . . . . . . . . exit button "retry"
*D  APPEND  . . . . . . . . . . . . . . . . . . . . . .  exit button "append"
*D  OVERWRITE . . . . . . . . . . . . . . . . . . . . exit button "overwrite"
*/
#define	YES	        0x0001
#define NO              0x0002
#define OK              0x0004
#define CANCEL          0x0008
#define ABORT           0x0010
#define RETRY           0x0020
#define APPEND  	0x0040
#define OVERWRITE	0x0080


/****************************************************************************
**
*T  TypePopupDialog . . . . . . . . . . . . . . . pointer to dialog structure
*/
typedef struct _popup_dialog
{
    Widget	    topLevel;
    Widget          popupShell;
    Widget          dialog;
    XtAppContext    context;
    int             result;
    int             button;
    int             defaultButton;
}
* TypePopupDialog;


/****************************************************************************
**
*P  Prototypes  . . . . . . . . . . . prototypes of public gap text functions
*/
#ifdef __STDC__
extern TypePopupDialog CreatePopupDialog( XtAppContext, Widget, String,
					  int, int, Pixmap );
extern int PopupDialog( TypePopupDialog, String, String, String * );
#else
extern TypePopupDialog CreatePopupDialog();
extern int PopupDialog();
#endif

#endif
