/****************************************************************************
**
*A  pty.h                       XGAP source                      Frank Celler
**
*H  @(#)$Id: pty.h,v 1.2 1994/06/06 08:57:24 fceller Exp $
**
*Y  Copyright 1992-1994,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
**
*H  $Log: pty.h,v $
*H  Revision 1.2  1994/06/06  08:57:24  fceller
*H  added database
*H
*H  Revision 1.1  1994/06/03  10:50:09  fceller
*H  fixed exec problem (again)
*H
*H  Revision 1.0  1993/04/05  11:42:18  fceller
*H  Initial revision
*/
#ifndef _pty_h
#define _pty.h


/****************************************************************************
**
*V  FromGap . . . . . . . . . . . . . . . . . . . . . . for messages from gap
*V  ToGap . . . . . . . . . . . . . . . . . . . . . . . . for messages to gap
*/
extern int      FromGap;
extern int      ToGap;


/****************************************************************************
**
*P  Prototype	. . . . . . . . . . . . . . . . . . . . . function prototypes
*/
#ifdef __STDC__
extern void   KillGap( void );
extern void   InterruptGap( void );
extern void   StartGapProcess ( char*, char *argv[] );
#else
extern void   KillGap();
extern void   InterruptGap();
extern void   StartGapProcess();
#endif


/****************************************************************************
**
*F  ReadGap( <buf>, <len> ) . . . . . . . . . . . . . . . read bytes from gap
*F  WriteGap( <buf>, <len> )  . . . . . . . . . . . . . .  write bytes to gap
*/
#ifdef DEBUG_ON
#   ifdef __STDC__
        extern int    READ_GAP( char*, int, char*, int );
        extern void   WRITE_GAP( char*, int, char*, int );
#   else
        extern int    READ_GAP();
        extern void   WRITE_GAP();
#   endif
#   define ReadGap(a,b)	    READ_GAP( __FILE__, __LINE__, a, b )
#   define WriteGap(a,b)    WRITE_GAP( __FILE__, __LINE__, a, b )
#else
#   ifdef __STDC__
        extern int    ReadGap( char*, int );
        extern void   WriteGap( char*, int );
#   else
        extern int    ReadGap();
        extern void   WriteGap();
#   endif
#endif

#endif
