/****************************************************************************
**
*A  utils.c                     XGAP Source                      Frank Celler
**
*H  @(#)$Id: utils.c,v 1.4 1994/06/06 08:57:24 fceller Exp $
**
*Y  Copyright 1993-1995,   Frank Celler,   Lehrstuhl D fuer Mathematik,  RWTH
**
*H  $Log: utils.c,v $
*H  Revision 1.4  1994/06/06  08:57:24  fceller
*H  added database
*H
*H  Revision 1.3  1993/12/23  08:47:41  fceller
*H  removed malloc debug functions
*H
*H  Revision 1.2  1993/10/18  11:04:47  fceller
*H  added fast updated,  fixed timing problem
*H
*H  Revision 1.1  1993/04/13  07:16:39  fceller
*H  added 'SYS_HAS_STDARG
*H
*H  Revision 1.0  1993/04/05  11:42:18  fceller
*H  Initial revision
*/
#include    <stdlib.h>
#include    <stdio.h>
#include    <stdlib.h>
#ifdef      SYS_HAS_STDARG
#include    <stdarg.h>
#endif
#include    <X11/Intrinsic.h>

#define     _utils_c
#include    "utils.h"


/****************************************************************************
**
*V  Debug . . . . . . . . . . . . . . . . . . . . . . . . . . .  debug on/off
*/
int Debug = 0;


/****************************************************************************
**
*F  List( <len> )   . . . . . . . . . . . . . . . . . . .   create a new list
*/
TypeList List ( len )
    int         len;
{
    TypeList    list;

    /* <len> must not be negative */
    if ( len < 0 )
	len = 0;

    /* get memory for new list */
    list = (TypeList) XtMalloc( sizeof( struct _list ) );
    list->len  = len;
    list->size = len+10;
    list->ptr  = (void*) XtMalloc( list->size * sizeof(void*) );

    /* return the new list */
    DEBUG(( "List(%d)=%p\n", len, (void*)list ))
    return list;
}


/****************************************************************************
**
*F  AddList( <lst>, <elm> ) . . . . . . . .  add list element <elm> to <list>
*/
void AddList ( lst, elm )
    TypeList  	lst;
    void      * elm;
{
    /* resize <lst> if necessary */
    DEBUG(( "AddList( %p, %p )\n", (void*) lst, (void*) elm ))
    if ( lst->len == lst->size )
    {
        lst->size = lst->size*4/3 + 5;
        lst->ptr  = (void*) XtRealloc( (char*) lst->ptr,
				       lst->size * sizeof(void*) );
    }

    /* and add list element */
    lst->ptr[lst->len++] = elm;
}
