/****************************************************************************
**
*A  utils.h                     XGAP Source                      Frank Celler
**
*H  @(#)$Id: utils.h,v 1.3 1994/06/06 08:57:24 fceller Exp $
**
*Y  Copyright 1993-1995,   Frank Celler,   Lehrstuhl D fuer Mathematik,  RWTH
**
*H  $Log: utils.h,v $
*H  Revision 1.3  1994/06/06  08:57:24  fceller
*H  added database
*H
*H  Revision 1.2  1993/12/23  08:47:41  fceller
*H  removed malloc debug functions
*H
*H  Revision 1.1  1993/10/18  11:04:47  fceller
*H  added fast updated,  fixed timing problem
*H
*H  Revision 1.0  1993/04/05  11:42:18  fceller
*H  Initial revision
*/
#ifndef _utils_h
#define _utils_h

#ifdef MALLOC_DEBUG
#include "dbmalloc.h"
#endif


/****************************************************************************
**
*M  P(( <arg> ))  . . . . . . . . . . . . . . . . . . . . . . . .  prototypes
*/
#ifndef P
#  ifdef  __STDC__
#    define P(ARGS) ARGS
#  else
#    define P(ARGS) ()
#  endif
#endif


/****************************************************************************
**

*T  TypeList  . . . . . . . . . . . . . . . . . . . . . . . .  list structure
*/
typedef struct _list
{
    long        size;
    long        len;
    void     ** ptr;
}
* TypeList;


/****************************************************************************
**
*F  List( <len> )   . . . . . . . . . . . . . . . . . . .   create a new list
*/
extern TypeList List P(( int ));


/****************************************************************************
**
*F  AddList( <lst>, <elm> ) . . . . . . . .  add list element <elm> to <list>
*/
extern void AddList P(( TypeList, void * ));


/****************************************************************************
**

*M  DEBUG(( <str> ))  . . . . . . . . . . . . . . . print <str> as debug info
*/
#ifdef  DEBUG_ON
extern int Debug;
#define	DEBUG(a) {if(Debug){printf("%04d:%s: ",__LINE__,__FILE__);printf a;}}
#else
#define DEBUG(a) /* no debug */
#endif


/****************************************************************************
**

*M  MAX( <a>, <b> ) . . . . . . . . . . . . . . . . .  maximum of <a> and <b>
*/
#undef  MAX
#define	MAX(a,b)	(((a) < (b)) ? (b) : (a))


/****************************************************************************
**
*M  MIN( <a>, <b> ) . . . . . . . . . . . . . . . . .  minimum of <a> and <b>
*/
#undef  MIN
#define	MIN(a,b)	(((a) < (b)) ? (a) : (b))

#endif
