/****************************************************************************
**
*A  xcmds.h                     XGAP Source                      Frank Celler
**
*H  @(#)$Id: xcmds.h,v 1.4 1993/12/23 08:49:29 fceller Exp $
**
*Y  Copyright 1993-1995,   Frank Celler,   Lehrstuhl D fuer Mathematik,  RWTH
**
*H  $Log: xcmds.h,v $
*H  Revision 1.4  1993/12/23  08:49:29  fceller
*H  changed comment
*H
*H  Revision 1.3  1993/10/18  11:04:47  fceller
*H  added fast updated,  fixed timing problem
*H
*H  Revision 1.2  1993/04/13  07:30:44  fceller
*H  added text selectors
*H
*H  Revision 1.1  1993/04/13  07:16:39  fceller
*H  added missing __STDC__ define
*H
*H  Revision 1.0  1993/04/05  11:42:18  fceller
*H  Initial revision
*H
*/
#ifndef _xcmds_h
#define _xcmds_h


/****************************************************************************
**
*T  TypeGapWindow . . . . . . . . . . . . . . . . description of a gap window
*/
typedef struct _gap_window
{
    Widget              top;
    Widget              box;
    Widget              viewport;
    Widget              draw;
    Widget              text;
    Boolean             used;
    TypeList            menus;
    long                height;
    long                width;
    long                line_width;
    Boolean             fast_update;
}
TypeGapWindow;


/****************************************************************************
**
*T  TypeTextSelector  . . . . . . . . . . . .  description of a text selector
*/
typedef struct _text_selector
{
    Widget              top;
    Widget              list;
    String            * text;
    TypeList            buttons;
}
TypeTextSelector;


/****************************************************************************
**
*T  TypeArg . . . . . . . . . . . . . . . . . . . . . . . . . . . . arguments
*/
typedef struct _arg
{
    TypeGapWindow     * win;
    TypeTextSelector  * sel;
    XFontStruct       * font;
    long                iargs[10];
    char              * sargs[10];
    char              * opts;
}
TypeArg;


/****************************************************************************
**
*T  TypeWindowCommand . . . . . . . . . . . . . . . . description of commands
*/
typedef struct _window_command
{
    char  * name;
    char  * args;
#ifdef __STDC__
    int     (*func) ( TypeArg* );
#else
    int     (*func) ();
#endif
}
TypeWindowCommand;


/****************************************************************************
**
*T  TypeMenu  . . . . . . . . . . . . . . . . . . . . . . description of menu
*/
typedef struct _menu
{
    Widget      shell;
    TypeList	entries;
    char      * name;
    char      * string;
}
TypeMenu;


/****************************************************************************
**
*T  TypeMenuData  . . . . . . . . . . . . . . . . . . . . . . . .  menu entry
*/
typedef struct _menu_data
{
    Widget      shell;
    int         window;
    int         popup;
    int         pane;
}
TypeMenuData;


/****************************************************************************
**
*T  TypePaneData  . . . . . . . . . . . . . . . . . . . . .  popup menu entry
*/
typedef struct _pane_data
{
    Widget      shell;
    int         popup;
    int         pane;
}
TypePaneData;


/****************************************************************************
**
*V  MenuSymbol	. . . . . . . . . . . . . . . . .  symbol for drop down menus
*V  CheckMarkSymbol . . . . . . . . . . . . . symbol for checked menu entries
*V  EmptyMarkSymbol . . . . . . . . . . . . symbol for unchecked menu entries
*/
extern Pixmap MenuSymbol;
extern Pixmap CheckMarkSymbol;
extern Pixmap EmptyMarkSymbol;


/****************************************************************************
**
*P  Prototypes	. . . . . . . . . . . . . . . . . . . . . function prototypes
*/
#ifdef __STDC__
extern void InitXCMDS( void );
extern void ExitXMCDS( void );
extern int GapWindowCmd( char*, int );
#else
extern void InitXCMDS();
extern void ExitXCMDS();
extern int GapWindowCmd();
#endif

#endif
