'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) file.n 1.3 94/12/17 16:17:53
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.1 94/08/09 13:07:19
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tk    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.HS file tcl
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
file \- Manipulate file names and attributes
.SH SYNOPSIS
\fBfile \fIoption\fR \fIname\fR ?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
This command provides several operations on a file's name or attributes.
\fIName\fR is the name of a file;
if it starts with a tilde, then tilde substitution is done before
executing the command (see the manual entry for \fBTcl_TildeSubst\fR
for details).
\fIOption\fR indicates what to do with the file name.  Any unique
abbreviation for \fIoption\fR is acceptable.  The valid options are:
.TP
\fBfile \fBatime \fIname\fR
Returns a decimal string giving the time at which file \fIname\fR
was last accessed.  The time is measured in the standard POSIX
fashion as seconds from a fixed starting time (often January 1, 1970).
If the file doesn't exist or its access time cannot be queried then an
error is generated.
.TP
\fBfile \fBdirname \fIname\fR
Returns all of the characters in \fIname\fR up to but not including
the last slash character.  If there are no slashes in \fIname\fR
then returns ``.''.  If the last slash in \fIname\fR is its first
character, then return ``/''.
.TP
\fBfile \fBexecutable \fIname\fR
Returns \fB1\fR if file \fIname\fR is executable by
the current user, \fB0\fR otherwise.
.TP
\fBfile \fBexists \fIname\fR
Returns \fB1\fR if file \fIname\fR exists and the current user has
search privileges for the directories leading to it, \fB0\fR otherwise.
.TP
\fBfile \fBextension \fIname\fR
Returns all of the characters in \fIname\fR after and including the
last dot in the last element of \fIname\fR.  If there is no dot in
the last element of \fIname\fR then returns
the empty string.
.TP
\fBfile \fBisdirectory \fIname\fR
Returns \fB1\fR if file \fIname\fR is a directory,
\fB0\fR otherwise.
.TP
\fBfile \fBisfile \fIname\fR
Returns \fB1\fR if file \fIname\fR is a regular file,
\fB0\fR otherwise.
.TP
\fBfile lstat \fIname varName\fR
Same as \fBstat\fR option (see below) except uses the \fIlstat\fR
kernel call instead of \fIstat\fR.  This means that if \fIname\fR
refers to a symbolic link the information returned in \fIvarName\fR
is for the link rather than the file it refers to.  On systems that
don't support symbolic links this option behaves exactly the same
as the \fBstat\fR option.
.TP
\fBfile \fBmtime \fIname\fR
Returns a decimal string giving the time at which file \fIname\fR
was last modified.  The time is measured in the standard POSIX
fashion as seconds from a fixed starting time (often January 1, 1970).
If the file doesn't exist or its modified time cannot be queried then an
error is generated.
.TP
\fBfile \fBowned \fIname\fR
Returns \fB1\fR if file \fIname\fR is owned by the current user,
\fB0\fR otherwise.
.TP
\fBfile \fBreadable \fIname\fR
Returns \fB1\fR if file \fIname\fR is readable by
the current user, \fB0\fR otherwise.
.TP
\fBfile readlink \fIname\fR
Returns the value of the symbolic link given by \fIname\fR (i.e. the
name of the file it points to).  If
\fIname\fR isn't a symbolic link or its value cannot be read, then
an error is returned.  On systems that don't support symbolic links
this option is undefined.
.TP
\fBfile \fBrootname \fIname\fR
Returns all of the characters in \fIname\fR up to but not including
the last ``.'' character in the name.  If \fIname\fR doesn't contain
a dot, then returns \fIname\fR.
.TP
\fBfile \fBsize \fIname\fR
Returns a decimal string giving the size of file \fIname\fR in bytes.
If the file doesn't exist or its size cannot be queried then an
error is generated.
.TP
\fBfile \fBstat  \fIname varName\fR
Invokes the \fBstat\fR kernel call on \fIname\fR, and uses the
variable given by \fIvarName\fR to hold information returned from
the kernel call.
\fIVarName\fR is treated as an array variable,
and the following elements of that variable are set: \fBatime\fR,
\fBctime\fR, \fBdev\fR, \fBgid\fR, \fBino\fR, \fBmode\fR, \fBmtime\fR,
\fBnlink\fR, \fBsize\fR, \fBtype\fR, \fBuid\fR.
Each element except \fBtype\fR is a decimal string with the value of
the corresponding field from the \fBstat\fR return structure; see the
manual entry for \fBstat\fR for details on the meanings of the values.
The \fBtype\fR element gives the type of the file in the same form
returned by the command \fBfile type\fR.
This command returns an empty string.
.TP
\fBfile \fBtail \fIname\fR
Returns all of the characters in \fIname\fR after the last slash.
If \fIname\fR contains no slashes then returns \fIname\fR.
.TP
\fBfile \fBtype \fIname\fR
Returns a string giving the type of file \fIname\fR, which will be
one of \fBfile\fR, \fBdirectory\fR, \fBcharacterSpecial\fR,
\fBblockSpecial\fR, \fBfifo\fR, \fBlink\fR, or \fBsocket\fR.
.TP
\fBfile \fBwritable \fIname\fR
Returns \fB1\fR if file \fIname\fR is writable by
the current user, \fB0\fR otherwise.

.SH KEYWORDS
attributes, directory, file, name, stat
