package Tk::Image;

use Carp;

# This module does for images what Tk::Widget does for widgets:
# provides a base class for them to inherit from.

@ISA = qw(Tk); # but are they ?

sub new
{
 my $package = shift;
 my $leaf = "\L$package";
 $leaf =~ s/^tk:://;
 my $obj = eval { Tk::image('create',$leaf,@_) };
 croak "$package: $@" if ($@);
 $obj = \"$obj" unless (ref $obj);
 return bless $obj,$package;
}

foreach (qw(delete width height type))
 {
  eval "sub $_ { Tk::image('$_',\@_) }";
 }

sub ImageClass
{
 my $name  = shift;
 my $class = ref $name;
 $name  = $$name;
 eval "sub Tk::$name 
        {
         shift;  # discard 
         $class->new(\@_) 
        }
       sub ${class}::Is${name}    { 1 } 
       sub Tk::Widget::Is${name} { 0 } 
      ";
 croak($@) if ($@);
 $classes{$name} = $class;
}

sub ClassFor
{
 my $class = shift;
 return $classes{$class};
}

# This is here to prevent AUTOLOAD trying to find it.
sub DESTROY
{
 my $i = shift;
 # maybe do image delete ???
}

require Tk::Bitmap;
require Tk::Photo;
require Tk::Pixmap;

1; 
