# simply split out of Tk-a5's Tk.pm
package Tk::Toplevel; 
@ISA = qw(Tk::Widget);
(bless \qw(Toplevel))->WidgetClass;

foreach $fn (qw(aspect client colormapwindows command deiconify focusmodel
		frame geometry grid group iconbitmap iconify iconmask
		iconname iconposition iconwindow maxsize minsize
		overrideredirect positionfrom protocol saveunder
		sizefrom state title transient withdraw))
 {
  eval "sub $fn { my \$w = shift; \$w->wm('$fn',\@_) }";
 }

sub Post
{
 my ($w,$X,$Y) = @_;
 $w->geometry("+$X+$Y");
 $w->deiconify;
}

sub TopRight
{
 my ($w,$base) = @_;
 my $X = $base->rootx + $base->Width;
 my $Y = $base->rooty;
 $w->Post($X,$Y);
}

sub Icon
{
 Tk->update;    # Let attributes propogate
 my $top   = shift;
 my $state = $top->state;
 $top->withdraw if ($state ne 'withdrawn');
 my $icon  = $top->Toplevel('-borderwidth' => 0,'-class'=>'Icon');
 $icon->withdraw;
 my $lab  = $icon->Label(@_);
 $lab->pack('-expand'=>1,'-fill' => 'both');
 $lab->DisableButtonEvents;
 $icon->DisableButtonEvents;
 Tk->idletasks; # Let size request propogate
 $icon->geometry($icon->ReqWidth . "x" . $icon->ReqHeight); 
 $top->iconwindow($icon);
 Tk->update;    # Let attributes propogate
 $top->deiconify if ($state eq 'normal');
 $top->iconify   if ($state eq 'iconic');
}


1;
