#include <X11/Xlib.h>
#include <stdio.h>
#include "scale.h"

static char *skipBlanks (s)
char *s; {

	for (; *s == ' '; s++) ;
	return s;
}

void doScale (dpy, win, gc, s, value, fth, ftw)
Display		*dpy;
Window		win;
GC		gc;
scaleControl	*s;
double		value;
int		fth;
int		ftw; {

	XPoint		p;
	XSegment	seg[32];
	int		is = 0;
	double		vStart;
	int		top = s->yorg - s->length;
	int		y, w, v, n;
	int		ytick = (double) s->minorInterval / s->scale + 0.5;
	int		doMajor;
	char		str[16], *q;

	vStart = value - (double) (s->length / 2) * s->scale;
	n = (int) vStart % s->minorInterval;
	if (n > 0)
		n = n - s->minorInterval;
	y = s->yorg + (int) (n / s->scale);
	if (vStart > 0.0)
		v = (int) (vStart + s->minorInterval - 1.0);
	else
		v = (int) vStart;
	v = v / s->minorInterval * s->minorInterval;

/*
 *  Draw the index mark
 */

	seg[is].y1 = seg[is].y2 = s->yorg - ((double) s->length / 2.0);
	if (s->orientation & orientRight) {
		seg[is].x1 = s->xorg - 2;
		seg[is].x2 = seg[is].x1 - s->indexSize;
	}
	else {
		seg[is].x1 = s->xorg + 2;
		seg[is].x2 = seg[is].x1 + s->indexSize;
	}
	++ is;

/*
 *  step through the doMajor and minor ticks
 */

	for (; y > top; (y -= ytick, v += s->minorInterval)) {

/*  we don't mark negative ticks */

		if (v < 0)
			continue;

		seg[is].x1 = s->xorg;
		seg[is].y1 = seg[is].y2 = p.y = y;

		if ((v % s->majorInterval) == 0) {
			doMajor = 1;
			w = s->majorSize;
			if (s->orientation & orientRight)
				seg[is].x2 = s->xorg + w;
			else
				seg[is].x2 = s->xorg - w;
			sprintf (str, s->format, (double) v / s->divisor);
			q = skipBlanks (str);
			p.y += 0.30 * (double) fth;
			if (s->orientation & orientRight) {
				p.x = seg[is].x2 + 3;
			}
			else {
				p.x = seg[is].x2 - 3 - ftw * strlen(q);
			}
		}
		else {
			doMajor = 0;
			w = s->minorSize;
			if (s->orientation & orientRight)
				seg[is].x2 = s->xorg + w;
			else
				seg[is].x2 = s->xorg - w;
		}

		if (doMajor)
			XDrawString (dpy, win, gc, p.x, p.y, q,
				strlen (q));
		++ is;	 
	}

	XDrawSegments (dpy, win, gc, seg, is);

}

void doCompassScale (dpy, win, gc, s, value, fth, ftw)
Display		*dpy;
Window		win;
GC		gc;
scaleControl	*s;
double		value;
int		fth;
int		ftw; {

	XPoint		p;
	XSegment	seg[32];
	int		is = 0;
	double		vStart;
	int		top = s->xorg + s->length;
	int		x, w, v, n;
	int		xtick = (double) s->minorInterval / s->scale + 0.5;
	int		doMajor;
	char		str[16], *q;

	vStart = value - (double) (s->length / 2) * s->scale;
	if (vStart <= 0.0)
		vStart += 36000.0;
	n = (int) vStart % s->minorInterval;
	if (n > 0)
		n = n - s->minorInterval;
	x = s->xorg - (int) (n / s->scale);
	if (vStart > 0.0)
		v = (int) (vStart + s->minorInterval - 1.0);
	else
		v = (int) vStart;
	v = v / s->minorInterval * s->minorInterval;

/*
 *  Draw the index mark
 */

	seg[is].x1 = seg[is].x2 = s->xorg + (int) ((double) s->length / 2.0 + 0.5);
	if (s->orientation & orientRight) {
		seg[is].y1 = s->yorg - 2;
		seg[is].y2 = seg[is].y1 - s->indexSize;
	}
	else {
		seg[is].y1 = s->yorg + 2;
		seg[is].y2 = seg[is].y1 + s->indexSize;
	}
	++ is;

/*
 *  step through the doMajor and minor ticks
 */

	for (; x < top; (x += xtick, v += s->minorInterval)) {

		if (v > 36000)
			v -= 36000;

		seg[is].y1 = s->yorg;
		seg[is].x1 = seg[is].x2 = p.x = x;

		if ((v % s->majorInterval) == 0) {
			doMajor = 1;
			w = s->majorSize;
			if (s->orientation & orientRight)
				seg[is].y2 = s->yorg + w;
			else
				seg[is].y2 = s->yorg - w;
			sprintf (str, s->format, (double) v / s->divisor);
			q = skipBlanks (str);
			p.x -= (strlen(q) * ftw) / 2;
			if (s->orientation & orientRight) {
				p.y = seg[is].y2 + 3 + fth;
			}
			else {
				p.y = seg[is].y2 - 3;
			}
		}
		else {
			doMajor = 0;
			w = s->minorSize;
			if (s->orientation & orientRight)
				seg[is].y2 = s->yorg + w;
			else
				seg[is].y2 = s->yorg - w;
		}

		if (doMajor)
			XDrawString (dpy, win, gc, p.x, p.y, q,
				strlen (q));
		++ is;	 
	}

	XDrawSegments (dpy, win, gc, seg, is);

}
