/*
 *	xflight : an aerial combat simulator for X
 *
 *	Written by Riley Rainey,  riley@mips.com
 *
 *	Permission to use, copy, modify and distribute (without charge) this
 *	software, documentation, images, etc. is granted, provided that this 
 *	comment and the author's name is retained.
 *
 */

#include "pm.h"

static struct {
	long	mask;
	char	*name;
	}	*pptr, panelVec[] = {
	SYS_ENGINE1,	"OIL PRES",
	SYS_HYD1,	"HYD1 PRES",
	SYS_HYD2,	"HYD2 PRES",
	SYS_GEN1,	"GEN1 FAIL",
	SYS_GEN2,	"GEN2 FAIL",
	SYS_FLAPS,	"FLAP FAIL",
	SYS_SPEEDBRAKE, "SPBRK FAIL",
	SYS_RADAR,	"RADAR FAIL",
	SYS_TEWS,	"TEWS FAIL",
	SYS_HUD,	" HUD FAIL",
	FLAG_LOWFUEL,	" LOW FUEL",
	FLAG_SPEEDBRAKE, "SPD BRAKE",
	FLAG_WHEELBRAKE, "  BRAKES",
	0,		(char *) 0 };

#define panelRows	7
#define panelChars	10
#define lightMargin	((u->rftw + 1) / 3)	
#define panelWMargin	(u->rftw * 2)
#define panelHMargin	(u->rfth / 2)

long	lastBits[MAXPLAYERS];

void	initPanel (c)
craft	*c; {

	lastBits [c->index] = SYS_NODAMAGE;

}

void doPanel (c, u)
craft	*c;
viewer	*u; {

	int	cellH, cellW;
	int	xi, yi, x, y, i;
	long	changeBits;

	cellH = u->rfth + 2 * lightMargin + panelHMargin;
	cellW = u->rftw * panelChars + 2 * lightMargin + panelWMargin;

	XSetForeground (u->dpy, u->gc, WhitePixel(u->v->dpy, u->v->screen));

	changeBits = lastBits[c->index] ^ c->damageBits;

	for (pptr = &panelVec[0], i=0; pptr->mask != 0; ++pptr, ++i) {
		if (changeBits & pptr->mask) {
			xi = i / panelRows;
			yi = i % panelRows;
			x = u->scaleFactor * PANEL_X + 0.5;
			x += xi * cellW + lightMargin;
			y = u->scaleFactor * PANEL_Y + 0.5;
			y += yi * cellH + lightMargin;
			if ((c->damageBits & pptr->mask) == 0) 
				XDrawImageString (u->dpy, u->win, u->gc,
					x, y, pptr->name, strlen(pptr->name));
			else {
				y -= u->rfth;
				XClearArea (u->dpy, u->win, x, y,
					u->rftw * panelChars,
					u->rfth + lightMargin, False);
			}
		}
	}

	lastBits[c->index] = c->damageBits;
}
