/* _vms.c  94.07.31
 * Copyright 1994 Thomas Gellekum
 * Non-portable functions for VMS
 */
#include "error.h"
#include <signal.h>
#include <time.h>
#include <unixlib.h>
#include <stdio.h>
/*--------------------------------------------------------------------------*/
	void    initialize_io(void);
	void    setup_traps(void);
static	void	sig_int(int);
	void	shell(void);
/*--------------------------------------------------------------------------*/
extern struct ioctrl io;
extern FILE *stream[];	    /* reverse of fileno() */
/*--------------------------------------------------------------------------*/
void initialize_io(void)
{
 stream[(int)fileno(stdin )] = stdin;
 stream[(int)fileno(stdout)] = stdout;
 stream[(int)fileno(stderr)] = stderr;
 io.mstdout = io.mstderr = 1<<fileno(stdout);
 io.mprint = 0;
}
/*--------------------------------------------------------------------------*/
void setup_traps(void)
{
 (void)signal(SIGINT,sig_int);
}
/*--------------------------------------------------------------------------*/
/* sig_int: what to do on receipt of interrupt signal (SIGINT)
 * cancel batch files, then back to command mode.
 * (actually, control-c trap)
 */
/*ARGSUSED*/
static void sig_int(int sig)
{
 (void)signal(SIGINT,sig_int);
 error(bERROR, "\n");
}
/*--------------------------------------------------------------------------*/
void shell(void)
{
 (void)system("spawn");
}
/*--------------------------------------------------------------------------*/
void getrusage(int who, struct rusage *rusage)
{
 double ticks = (double)clock();
 rusage->ru_stime.tv_sec = rusage->ru_stime.tv_usec = 0;
 rusage->ru_utime.tv_usec =
 	(long)fmod(ticks, (double)CLK_TCK) * (1000000./(double)CLK_TCK);
 rusage->ru_utime.tv_sec = (long)(ticks/(double)CLK_TCK);
}
/*--------------------------------------------------------------------------*/
int unlink(char *fname)
{
 strcat(fname, ";1");
 return(remove(fname));
}
/*--------------------------------------------------------------------------*/
