/* cmath.c  93.12.19
 * Copyright 1983-1992   Albert Davis
 * complex math
 */
#include "ecah.h"
#include "declare.h"
/*LINTLIBRARY*/
/*--------------------------------------------------------------------------*/
	complex_t cxadd(double,double,double,double);
	complex_t cxsub(double,double,double,double);
	complex_t cxmul(double,double,double,double);
	complex_t cxdiv(double,double,double,double);
	complex_t cxflip(double,double);
	complex_t cadd(complex_t,complex_t);
	complex_t csub(complex_t,complex_t);
	complex_t cmul(complex_t,complex_t);
	complex_t ccmul(complex_t,complex_t);
	complex_t cdiv(complex_t,complex_t);
	complex_t cflip(complex_t);
/*--------------------------------------------------------------------------*/
complex_t cxadd(double x1, double y1, double x2, double y2)
{
 complex_t z;
 z.x = x1 + x2;
 z.y = y1 + y2;
 return z;
}
/*--------------------------------------------------------------------------*/
complex_t cxsub(double x1, double y1, double x2, double y2)
{
 complex_t z;
 z.x = x1 - x2;
 z.y = y1 - y2;
 return z;
}
/*--------------------------------------------------------------------------*/
complex_t cxmul(double x1, double y1, double x2, double y2)
{
 complex_t z;
 z.x = x1*x2 - y1*y2 ;
 z.y = x1*y2 + y1*x2 ;
 return z;
}
/*--------------------------------------------------------------------------*/
complex_t cxdiv(double x1, double y1, double x2, double y2)
{
 complex_t z;
 double  d;
 d   =  x2*x2 + y2*y2;
 z.x = (x1*x2 + y1*y2) / d;
 z.y = (y1*x2 - x1*y2) / d;
 return z;
}
/*--------------------------------------------------------------------------*/
complex_t cxflip(double x2, double y2)
{
 complex_t z;
 double  d;
 d = x2*x2 + y2*y2;
 z.x =  x2 / d;
 z.y = -y2 / d;
 return z;
}
/*--------------------------------------------------------------------------*/
complex_t cadd(complex_t a, complex_t b)
{
 complex_t z;
 z.x = a.x + b.x;
 z.y = a.y + b.y;
 return z;
}
/*--------------------------------------------------------------------------*/
complex_t csub(complex_t a, complex_t b)
{
 complex_t z;
 z.x = a.x - b.x;
 z.y = a.y - b.y;
 return z;
}
/*--------------------------------------------------------------------------*/
complex_t cmul(complex_t a, complex_t b)
{
 complex_t z;
 z.x = a.x*b.x - a.y*b.y ;
 z.y = a.x*b.y + a.y*b.x ;
 return z;
}
/*--------------------------------------------------------------------------*/
complex_t ccmul(complex_t a, complex_t b)	/* conjugate multiply */
{
 complex_t z;
 z.x = a.x*b.x + a.y*b.y ;
 z.y = a.y*b.x - a.x*b.y ;
 return z;
}
/*--------------------------------------------------------------------------*/
complex_t cdiv(complex_t a, complex_t b)
{
 complex_t z;
 double  d;
 d   =  b.x*b.x + b.y*b.y;
 z.x = (a.x*b.x + a.y*b.y) / d;
 z.y = (a.y*b.x - a.x*b.y) / d;
 return z;
}
/*--------------------------------------------------------------------------*/
complex_t cflip(complex_t b)
{
 complex_t z;
 double  d;
 d = b.x*b.x + b.y*b.y;
 z.x =  b.x / d;
 z.y = -b.y / d;
 return z;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
