/* ctof.c  93.12.19
 * Copyright 1983-1992   Albert Davis
 * get double from string
 * update string pointer
 * return double number if got, else 0
 * supports letter multipliers (spice style)
 * skips trailing letters (10uhenries == 10u)
 * skips trailing spaces and one comma
 * pointer points to char following comma
 * or first non-space following number just got
 * or first non-space (if non-number)
 */
#include "ecah.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	double	ctof(const char*,int*);
	double	x10(int);
/*--------------------------------------------------------------------------*/
double ctof(const char *cmd, int  *cnt)
{
 double val, power;
 int    sign;
 char   pc;

 skipbl(cmd,cnt);
 if (!isfloat(cmd[*cnt])){
    skipcom(cmd,cnt);
    return 0.;
 }

 sign = 1;					/* sign */
 if (cmd[*cnt]=='+'){
    (*cnt)++;
 }else if (cmd[*cnt]=='-'){
    sign = -1;
    (*cnt)++;
 }

 for (val=0.0;  isdigit(cmd[*cnt]);  (*cnt)++)	/* up to dec pt */
    val = 10.0 * val + (cmd[*cnt]-'0');

 if (cmd[*cnt] == '.')				/* dec pt */
    (*cnt)++;

 for (power=1.; isdigit(cmd[*cnt]); (*cnt)++){	/* after dec pt */
    val = 10.0 * val + (cmd[*cnt]-'0');
    power *= .1;
 }

 pc = to_upper(cmd[*cnt]);
 (*cnt)++;
 if (pc == 'E'){				/* exponent: E form */
    int es, expo;
    es = 1;
    if (cmd[*cnt]=='+'){
       (*cnt)++;
    }else if (cmd[*cnt]=='-'){
       (*cnt)++;
       es = -1;
    }
    for (expo=0;  isdigit(cmd[*cnt]);  (*cnt)++)
	expo = 10 * expo + (cmd[*cnt]-'0');
    expo *= es;
    power *= x10(expo);
 }else if (pc == 'M'){				/* M is special */
    int pc2;
    pc2 = to_upper(cmd[*cnt]);
    (*cnt)++;
    if (pc2 == 'E'){				/* meg */
        power *= 1e6;
    }else if (pc2 == 'I'){			/* mil */
        power *= 25.4e-6;
    }else{					/* plain m (milli) */
       power *= 1e-3;
       (*cnt)--;
    }
 }else if (pc == 'U'){				/* other letters */
    power *= 1e-6;
 }else if (pc == 'N'){
    power *= 1e-9;
 }else if (pc == 'P'){
    power *= 1e-12;
 }else if (pc == 'F'){
    power *= 1e-15;
 }else if (pc == 'K'){
    power *= 1e3;
 }else if (pc == 'G'){
    power *= 1e9;
 }else if (pc == 'T'){
    power *= 1e12;
 }else{
    (*cnt)--;
 }
 while (isalpha(cmd[*cnt]))			/* skip letters */
    (*cnt)++;

 skipcom(cmd,cnt);
 return (sign*val*power);
}
/*--------------------------------------------------------------------------*/
double x10(int ex)
{
double r;
r = 1.;
for (; ex>0; ex-- )
    r *= 10.0;
for (; ex<0; ex++ )
    r *= .1;
return r;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
