/* delete.c  94.11.20
 * Copyright 1983-1992   Albert Davis
 * delete and clear commands
 */
#include "ecah.h"
#include "branch.h"
#include "error.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	cmd_clear(void);
	void	cmd_delete(const char*,int*);
static	void	bylabel(const char*,int*);
static	void	all(void);
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/* cmd_clear: clear the whole circuit, including faults, etc
 *   equivalent to unfault; unkeep; delete all; title = (blank)
 */
void cmd_clear(void)
{
 int dummy = 0;

 cmd_unfault();
 cmd_unmark();
 dummy = 0;
 cmd_ic("clear",&dummy);
 dummy = 0;
 cmd_nodeset("clear",&dummy);
 dummy = 0;
 cmd_print("clear",&dummy);
 dummy = 0;
 cmd_delete("all",&dummy);
 dummy = 0;
 cmd_title("'",&dummy);
}
/*--------------------------------------------------------------------------*/
/* cmd_delete:  delete command
 */
void cmd_delete(const char *cmd, int *cnt)
{
 dealloc(YES);
 if (pmatch(cmd,cnt,"ALL")){
    all();
 }else{
    while (isalpha(cmd[*cnt]))
       bylabel(cmd,cnt);
 }
}
/*--------------------------------------------------------------------------*/
/* bylabel: delete circuit element by label
 * 	all lines with matching label (with wild cards * and ?) deleted.
 *	syntax warning if no match
 */
static void bylabel(const char *cmd, int *cnt)
{
 branch_t *brh;		/* scanning branch				    */
 branch_t *next;	/* look ahead because delete loses the link	    */
 int idx;		/* temporary string index			    */
 int count = 0;		/* deleted line counter				    */
 int x = 0;		/* fudge: place to stash new index		    */

 for (brh = firstbranch_all();
	idx= *cnt, brh =findbranch(cmd,&idx,brh,lastbranch_all()), exists(brh);
 	brh=next){
    x = idx;
    next = nextbranch_all(brh);
    count += deletebranch(&brh);
 }

 if (count != 0){
    *cnt = x;
 }else{
    syntax_check(cmd,cnt,bWARNING);
    skiparg(cmd,cnt);
 }
}
/*--------------------------------------------------------------------------*/
/* all: delete all parts of a circuit, line by line
 */
static void all(void)			    /* the whole circuit	    */
{
 branch_t *brh;
 branch_t *next;
 for (brh=firstbranch_all();  exists(brh);  brh=next){
    next = nextbranch_all(brh);
    (void)deletebranch(&brh);
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
