/* nodes.c  94.07.23
 * Copyright 1983-1992   Albert Davis
 * functions to handle node mapping
 */
#include "ecah.h"
#include "branch.h"
#include "status.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	int	newnode_subckt(void);
	int	newnode_model(void);
	int	parsenodes(branch_t*,const char*,int*);
	void	printnodes(const branch_t*,int);
static	int	name2number(const char*,int*);
static	char*	number2name(char*,int);
/*--------------------------------------------------------------------------*/
extern struct status stats;
/*--------------------------------------------------------------------------*/
/* newnode_subckt: get a new node number, unique internal nodes in subckts
 */
int newnode_subckt(void)
{
 ++stats.subckt_nodes;
 return ++stats.total_nodes;
}
/*--------------------------------------------------------------------------*/
/* newnode_model: get a new node number, unique internal nodes in models
 */
int newnode_model(void)
{
 ++stats.model_nodes;
 return ++stats.total_nodes;
}
/*--------------------------------------------------------------------------*/
/* parsenodes: parse circuit connections from input string
 * result in brh.
 * n array must hold at least numnodes+1
 * cnt updated.
 */
int parsenodes(branch_t *brh, const char *cmd, int *cnt)
{
 int ii;
 int count = 0;
 for (ii = 0;  ii < brh->f->numnodes;  ii++){
    brh->n[ii].t = brh->n[ii].e = name2number(cmd,cnt);
    if (brh->n[ii].e != INVALIDNODE)
       count = ii+1;
 }
 brh->n[ii].t = brh->n[ii].e = INVALIDNODE;
 return count;
}
/*--------------------------------------------------------------------------*/
/* printnodes: print a node list
 */
void printnodes(const branch_t *brh, int where)
{
 int ii;
 for (ii = 0;   brh->n[ii].e != INVALIDNODE;   ii++){
    char name[LABELEN+1];
    mprintf(where, " %s ", number2name(name,brh->n[ii].e));
 }
}
/*--------------------------------------------------------------------------*/
/* name2number: convert node name to node number
 * returns node number
 * cnt updated
 */
static int name2number(const char *cmd, int *cnt)
{
 int test;
 int node;

 test = *cnt;
 node = ctoi(cmd,cnt);
 return  (test == *cnt)  ?  INVALIDNODE  :  node;
}
/*--------------------------------------------------------------------------*/
/* number2name: convert node number to node name
 * result in name (must be big enough)
 * returns name
 */
static char* number2name(char *name, int node)
{
 (void)sprintf(name, "%d", node);
 return name;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
