/* outset.c  93.12.20
 * Copyright 1983-1992   Albert Davis
 * Sets up output direction and format for most commands
 * returns  NO	 if it did nothing
 *	    fORD if nothing with a file
 *	    fOUT if it set up an output file
 *	    fIN	 if is set up an input file
 * updates pointers into the string
 * outreset starts it all over
 */
#include "ecah.h"
#include "error.h"
#include "formats.h"
#include "io.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	initio(int,FILE*);
	void	decipher(char*);
	void	outreset(void);
	int	outset(const char*,int*,const char*,const char*);
static	FILE*	file_open(const char*,int*,const char*,const char*,FILE*);
/*--------------------------------------------------------------------------*/
extern struct ioctrl io;
static FILE *fn;		/* write file				    */
/*--------------------------------------------------------------------------*/
/* initio: initialize file encryption, etc
 */
void initio(int Where, FILE *Whence)
{
 const char *tag;
 tag = "''''";
 if (io.outcipher)			/* if writing an encrypted file,    */
    mprintf(Where,"%s\n",tag);		/* mark it as encrypted		    */
 if (Whence){
    char buf[BUFLEN];
    if (!fgets(buf, BUFLEN, Whence))	/* if the first line deciphers to   */
       return;				/* the cipher tag, it is encrypted  */
    io.incipher = YES;			/* otherwise,			    */
    decipher(buf);			/*	 rewind and read normally   */
    if (strcmp(buf,tag) != 0){   /* mismatch */
       io.incipher = NO;
       (void)fseek(Whence,0L,SEEK_SET);
    }
 }
}
/*--------------------------------------------------------------------------*/
/* decipher: un-encrypt a line of text in place
 */
void decipher(char *buf)
{
 if (io.incipher){
    for ( ; isprint(buf[1]); buf++ ){
       int fixed;
       fixed = (int)buf[1] - (int)buf[0];
       while (!isascii(fixed) || !isprint(fixed))
	   fixed += (0x7f-0x20);
       buf[0] = (char)fixed;
    }
    buf[0] = '\0';
 }
}
/*--------------------------------------------------------------------------*/
/* outreset: close files and set i/o flags to standard values
 */
void outreset(void)
{
 xclose(&fn);
 xclose(&io.whence);
 io.where = io.formaat = 0;
 io.incipher = io.outcipher = io.pack = NO;
 if (io.echoflag)
    io.where |= io.mstdout;
 if (io.printflag)
    io.where |= io.mprint;
}
/*--------------------------------------------------------------------------*/
/* outset: set up i/o for a command
 * return whether or not it did anything
 */
int outset(const char *cmd, int *cnt, const char *inext, const char *outext)
{
 int retcode = NO;
 
 for (;;){
    if (pmatch(cmd,cnt,"Printer")){
       io.where |= io.mprint;
    }else if (pmatch(cmd,cnt,"Noprint")){
       io.where &= ~io.mprint;
    }else if (pmatch(cmd,cnt,"Basic")){
       io.formaat = FMTEXP;
    }else if (pmatch(cmd,cnt,"Cipher")){
       io.outcipher = io.pack = YES;
    }else if (pmatch(cmd,cnt,"Pack")){
       io.pack = YES;
    }else if (pmatch(cmd,cnt,"Quiet")){
       io.where &= ~io.mstdout;
    }else if (pmatch(cmd,cnt,"Echo") || pmatch(cmd,cnt,"List")){
       io.where |= io.mstdout;
    }else if (outext && pmatch(cmd,cnt,"SAve")){
       fn = file_open(cmd,cnt,outext,"w",fn);
       io.where |= 1<<fileno(fn);
    }else if (outext && pmatch(cmd,cnt,">")){
       const char *access;
       access = (pmatch(cmd,cnt,">")) ? "a" : "w";
       fn = file_open(cmd,cnt,outext,access,fn);
       io.where |= 1<<fileno(fn);
       io.formaat = FMTEXP;
    }else if (inext && pmatch(cmd,cnt,"<")){
       io.whence = file_open(cmd,cnt,inext,"r",io.whence);
    }else{
       break;
    }
    retcode = YES;
 }
 return retcode;
}
/*--------------------------------------------------------------------------*/
/* file_open: a different interface for xopen
 */
static FILE *file_open(
	const char *cmd,
	int *cnt,
	const char *ext,
	const char *access,
	FILE *fileptr)
{
 xclose(&fileptr);
 fileptr = xopen(cmd,cnt,ext,access);
 if (!fileptr)
    error(bERROR, "");
 return fileptr;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
