/* skipbl.c  93.12.21
 * Copyright 1983-1992   Albert Davis
 * skip whitespace.  (any non-graphic character is ws)
 * =,(,) are also ws
 * update string pointer
 * pointer points to first non-space
 * also ..... skipcom, skiplparen, skiprparen.  obvious
 * all but skipbl returns the # of them skipped (1 or 0).
 */
#include "ecah.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	skipbl(const char*,int*);
	int	skipcom(const char*,int*);
	int	skiplparen(const char*,int*);
	int	skiprparen(const char*,int*);
	int	skipequal(const char*,int*);
/*--------------------------------------------------------------------------*/
void skipbl(const char *cmd, int *cnt)
{
 while (cmd[*cnt]  &&  (!isgraph(cmd[*cnt])))
    (*cnt)++ ;
}
/*--------------------------------------------------------------------------*/
int skipcom(const char *cmd, int *cnt)
{
 skipbl(cmd,cnt);
 if (cmd[*cnt] == ','  ||  cmd[*cnt] == '='){
    (*cnt)++;
    skipbl(cmd,cnt);
    return 1;
 }else{
    skipbl(cmd,cnt);
    return 0;
 }
}
/*--------------------------------------------------------------------------*/
int skiplparen(const char *cmd, int *cnt)
{
 skipbl(cmd,cnt);
 if (cmd[*cnt] == '('  ||  cmd[*cnt] == '['){
    (*cnt)++;
    skipbl(cmd,cnt);
    return 1;
 }else{
    skipbl(cmd,cnt);
    return 0;
 }
}
/*--------------------------------------------------------------------------*/
int skiprparen(const char *cmd, int *cnt)
{
 skipbl(cmd,cnt);
 if (cmd[*cnt] == ')'  ||  cmd[*cnt] == ']'){
    (*cnt)++;
    skipbl(cmd,cnt);
    return 1;
 }else{
    skipbl(cmd,cnt);
    return 0;
 }
}
/*--------------------------------------------------------------------------*/
int skipequal(const char *cmd, int *cnt)
{
 skipbl(cmd,cnt);
 if (cmd[*cnt] == '='){
    (*cnt)++;
    skipbl(cmd,cnt);
    return 1;
 }else{
    skipbl(cmd,cnt);
    return 0;
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
